/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.launcher.ICtcRetriever;
import cerent.util.KDebug;
import cerent.util.tty.CLIShowArpAction;
import cerent.util.tty.CLIShowVersionAction;
import cerent.util.tty.CtcCLIRetrieverException;
import java.io.IOException;
import java.util.List;

public class CtcCLIRetriever
implements ICtcRetriever {
    private static final KDebug db = new KDebug("CtcCliRetriever");
    private static CtcCLIRetriever instance;

    private CtcCLIRetriever() {
    }

    public static final CtcCLIRetriever instance() {
        if (instance == null) {
            instance = new CtcCLIRetriever();
        }
        return instance;
    }

    public String getNeType(String string) throws CtcCLIRetrieverException, IOException {
        CLIShowVersionAction cLIShowVersionAction = new CLIShowVersionAction(string, db);
        CLIShowVersionAction.PlatformInfo platformInfo = cLIShowVersionAction.get();
        if (platformInfo == null) {
            throw new CtcCLIRetrieverException("Unable to retrieve version info from node " + string);
        }
        return platformInfo.getNeType();
    }

    public String getSwVersion(String string) throws CtcCLIRetrieverException, IOException {
        CLIShowVersionAction cLIShowVersionAction = new CLIShowVersionAction(string, db);
        CLIShowVersionAction.PlatformInfo platformInfo = cLIShowVersionAction.get();
        if (platformInfo == null) {
            throw new CtcCLIRetrieverException("Unable to retrieve version info from node " + string);
        }
        return platformInfo.getVersion();
    }

    public String getNodeId(String string) throws CtcCLIRetrieverException, IOException {
        CLIShowArpAction cLIShowArpAction = new CLIShowArpAction(string, db);
        List<CLIShowArpAction.ArpInfo> list = cLIShowArpAction.get();
        if (list == null) {
            throw new CtcCLIRetrieverException("Unable to retrieve ARP info for node " + string);
        }
        for (CLIShowArpAction.ArpInfo arpInfo : list) {
            if (!arpInfo.getIp().equals(string)) continue;
            return arpInfo.getMacAddress().replaceAll("\\.", "").substring(4);
        }
        throw new CtcCLIRetrieverException("The IP " + string + " was not found in the CRS ARP table");
    }
}

