/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import cerent.util.tty.TTYSessionsPool;
import de.mud.jta.ICliSession;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TTYSession
implements ITTYSession {
    protected ICliSession cliSession;
    protected TTYSessionsPool myPool;
    protected static final String[] expected_prompts = new String[]{"XML>"};
    protected static Log log;
    protected String hostname;
    private long executionstart = 0L;

    public TTYSession(ICliSession iCliSession, TTYSessionsPool tTYSessionsPool) {
        log = LogFactory.getLog(TTYSession.class);
        this.cliSession = iCliSession;
        this.myPool = tTYSessionsPool;
        this.hostname = tTYSessionsPool.getHostName();
    }

    @Override
    public void sendKeepAlive() throws IOException {
        if (this.cliSession == null) {
            log.debug((Object)("sendKeepAlive on node " + this.myPool.getHostName() + " failed, invalid ITTYSession, null cli session, ITTYSession not properly destroyed."));
            this.startLogToMyPool("Disposed CLI session found, keep-alive aborted.");
            this.dispose();
            throw new IOException("Invalid TTY Session");
        }
        try {
            this.startLogToMyPool("Sending Keep-alive...");
            this.cliSession.getRawSession().setReadTimeout(TTYSessionsPool.KEEPALIVE_TIMEOUT);
            this.cliSession.sendKeepAlive();
            int n = this.cliSession.getRawSession().read(new byte[1024]);
            this.cliSession.getRawSession().setReadTimeout(TTYSessionsPool.SESSION_TIMEOUT);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node " + this.myPool.getHostName() + " is alive"));
            }
            this.stopLogToMyPool("Keep-alive successful.", null);
        }
        catch (IOException iOException) {
            log.debug((Object)("Node " + this.myPool.getHostName() + " is down, sendKeepAlive failed."));
            this.startLogToMyPool("Keep-alive failed for " + iOException.getMessage() + ".");
            this.myPool.releaseSession(this, true);
            throw iOException;
        }
    }

    @Override
    public abstract String sendCommand(String var1) throws IOException, TTYException;

    @Override
    public boolean isClosed() {
        if (this.cliSession != null) {
            return this.cliSession.isClosed();
        }
        return true;
    }

    @Override
    public void releaseMe() {
        this.myPool.releaseSession(this, false);
    }

    @Override
    public void destroy() {
        try {
            if (this.cliSession != null) {
                this.cliSession.disconnect();
            }
        }
        catch (IOException iOException) {
            log.warn((Object)("Cannot disconnect session with " + this.myPool.getHostName() + ": " + iOException.getMessage()));
        }
        this.cliSession = null;
    }

    protected void dispose() throws IOException {
        this.myPool.releaseSession(this, true);
        this.cliSession = null;
        this.myPool = null;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void getLock() {
    }

    @Override
    public void releaseLock() {
        this.releaseMe();
    }

    protected void startLogToMyPool(String string) {
        this.executionstart = System.currentTimeMillis();
        Date date = new Date(this.executionstart);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm:ss");
        if (this.myPool.getDb().on()) {
            this.myPool.getDb().println(this.hostname + "@" + simpleDateFormat.format(date) + "> " + string);
        }
    }

    protected void stopLogToMyPool(String string, String string2) {
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm:ss");
        if (this.myPool.getDb().on()) {
            String string3 = "";
            if (string2 != null && this.myPool.getDb().isFinestEnabled()) {
                string3 = "\nResult:" + string2.replaceAll("\n", "").replaceAll("\r", "");
            }
            this.myPool.getDb().println(this.hostname + "@" + simpleDateFormat.format(date) + "> " + string + string3 + (this.executionstart == 0L ? "" : "\nExecuted in " + (l - this.executionstart) + "ms."));
        }
        this.executionstart = 0L;
    }

    @Override
    public abstract String sendCommand(String var1, boolean var2) throws TTYException, IOException;
}

