/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.tty;

import cerent.util.tty.ITTYSession;
import cerent.util.tty.TTYException;
import cerent.util.tty.TTYSession;
import cerent.util.tty.TTYSessionFactory;
import cerent.util.tty.TTYSessionsPool;
import de.mud.jta.ICliSession;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class XMLTTYSession
extends TTYSession {
    private static final String XML = "xml";
    private static final char ERROR_PROMPT = '^';
    private static final String ERROR_STRING = "Error";
    private boolean switchfailed = false;

    public XMLTTYSession(ICliSession iCliSession, TTYSessionsPool tTYSessionsPool) {
        super(iCliSession, tTYSessionsPool);
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H:mm:ss");
        try {
            String string = this.sendCommand(XML);
            if (string.indexOf(ERROR_STRING) != -1 || string.indexOf(94) != -1) {
                this.switchfailed = true;
                log.error((Object)"Cannot switch to XML mode");
                this.startLogToMyPool("Switch to XML Mode failed.");
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Cannot switch to XML mode fo IOException", (Throwable)iOException);
            this.startLogToMyPool("Switch to XML Mode failed for " + iOException.getMessage() + ".");
            this.switchfailed = true;
        }
        catch (TTYException tTYException) {
            log.error((Object)"Cannot switch to XML mode fo TTYException", (Throwable)tTYException);
            this.startLogToMyPool("Switch to XML Mode failed for " + tTYException.getMessage() + ".");
            this.switchfailed = true;
        }
    }

    @Override
    public String sendCommand(String string) throws IOException, TTYException {
        String[] stringArray = new String[1];
        if (this.cliSession == null || this.switchfailed) {
            this.startLogToMyPool("Disposed CLI session found, " + string + " aborted.");
            this.dispose();
            throw new TTYException("Command executed on invalid XMLTTYSession, " + (this.switchfailed ? "switch to XML mode failed" : "null cli session") + ": " + string);
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("TTYXMLMode", null);
            this.startLogToMyPool("Send " + string);
            if (this.cliSession.sendCommand(string, expected_prompts, null, null, 0, stringArray, hashMap)) {
                this.stopLogToMyPool("Sent " + string, stringArray[0]);
                return stringArray[0];
            }
            this.stopLogToMyPool("Sent " + string + "\n FAILED", stringArray[0]);
            throw new TTYException(string + "\n" + stringArray[0]);
        }
        catch (IOException iOException) {
            this.stopLogToMyPool("Sent " + string + "\n FAILED for IOException " + iOException.getMessage(), null);
            this.dispose();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendCommand(String string, boolean bl) throws TTYException, IOException {
        String string2;
        if (XML.equals(string)) {
            return "";
        }
        if ("exit".equals(string)) {
            return "";
        }
        if (bl) {
            return this.sendCommand(string);
        }
        ITTYSession iTTYSession = TTYSessionFactory.instance().getSession(this.hostname, TTYSessionFactory.SessionType.CLI);
        try {
            string2 = iTTYSession.sendCommand(string);
        }
        finally {
            iTTYSession.releaseMe();
        }
        return string2;
    }
}

