/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvNodeModel;
import cerent.util.view.fv.IViewManagerView;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewDomainGrapher;
import cerent.util.view.fv.ViewGeneralGrapher;
import cerent.util.view.fv.ViewGrapher;
import cerent.util.view.fv.helper.FunctDialog;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvHandlesSelection;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphic.IlvIcon;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphlayout.IlvGraphLayoutException;
import ilog.views.graphlayout.link.shortlink.IlvShortLinkLayout;
import ilog.views.graphlayout.springembedder.IlvSpringEmbedderLayout;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.interactor.IlvSelectInteractorMoveSelection;
import ilog.views.interactor.IlvZoomViewInteractor;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.swing.IlvToolTipManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractView
extends IlvManagerView
implements TransformerListener,
IViewManagerView {
    static final int VIEW_HEIGHT = 2400;
    static final int VIEW_WIDTH = 5200;
    private int zoomCount = 0;
    static boolean DEBUG_ENABLE_DEFAULT_RECT = false;
    private static IlvRect DEFAULT_RECT = new IlvRect(0.0f, 0.0f, 5200.0f, 2400.0f);
    protected static IlvRectangle DEFAULT_DOMAIN = new IlvRectangle(DEFAULT_RECT);
    private IlvJScrollManagerView graphWin = null;
    private IlvZoomViewInteractor zoomViewInteractor = null;
    protected ViewGeneralGrapher rootGraph = null;
    protected IlvSelectInteractor selInter = null;
    protected IlvManagerViewInteractor actInt = null;
    protected IlvShortLinkLayout linkLayout = null;
    protected IFvNodeModel nmd = null;
    private boolean inited = false;

    public AbstractView(IFvNodeModel iFvNodeModel, ViewGeneralGrapher viewGeneralGrapher) {
        this.nmd = iFvNodeModel;
        CustomSelectInteractor customSelectInteractor = new CustomSelectInteractor();
        customSelectInteractor.setOpaqueMove(true);
        this.pushInteractor((IlvManagerViewInteractor)customSelectInteractor);
        this.setKeepingAspectRatio(true);
        IlvToolTipManager.registerView((IlvManagerView)this);
        IlvHandlesSelection.defaultHandleColor = Color.black;
        IlvHandlesSelection.defaultHandleBackgroundColor = Color.white;
        IlvHandlesSelection.defaultHandleShape = 3;
        IlvHandlesSelection.defaultHandleSize = 1.0f;
        this.setAntiAliasing(true);
        super.ensureVisible(new IlvPoint(1250.0f, 1050.0f));
        this.addTransformerListener(this);
        this.rootGraph = viewGeneralGrapher;
        this.setGraph(viewGeneralGrapher);
    }

    protected void init() {
        this.initLayout();
        this.dolayout();
        this.addAllDomainDim();
    }

    protected void dispose() {
        if (this.rootGraph != null) {
            this.rootGraph.dispose();
        }
        this.rootGraph = null;
        this.graphWin = null;
        this.zoomViewInteractor = null;
        this.selInter = null;
        this.actInt = null;
        if (this.linkLayout != null) {
            this.linkLayout.detach();
        }
        this.linkLayout = null;
        this.nmd = null;
        super.popInteractor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAllDomainDim() {
        if (!this.inited) {
            try {
                if (DEBUG_ENABLE_DEFAULT_RECT) {
                    this.rootGraph.addObject((IlvGraphic)DEFAULT_DOMAIN, 0, false);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                this.inited = true;
            }
        }
    }

    public IlvGraphic getDefaultDomain() {
        return DEFAULT_DOMAIN;
    }

    public IlvRect getDefaultRect() {
        return DEFAULT_RECT;
    }

    protected void initLayout() {
        this.linkLayout = new IlvShortLinkLayout();
        this.linkLayout.attach((IlvGrapher)this.rootGraph);
        this.linkLayout.setGlobalLinkStyle(4);
        this.linkLayout.setCombinedInterGraphLinksMode(true);
        this.linkLayout.setAutoLayout(false);
        this.rootGraph.setContentsAdjusting(true);
        try {
            this.linkLayout.performLayout();
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            ilvGraphLayoutException.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dolayout() {
        try {
            this.linkLayout.setAutoLayout(false);
            this.linkLayout.setCombinedInterGraphLinksMode(false);
            this.linkLayout.setAnimate(true);
            int n = this.linkLayout.performLayout(true, true, true);
            if (n == 5) return;
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            ilvGraphLayoutException.printStackTrace();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setBackgroundI(String string) {
    }

    public void setGraph(IlvGrapher ilvGrapher) {
        if (ilvGrapher != null) {
            super.setManager((IlvManager)ilvGrapher);
            this.zoomCount = 0;
        }
    }

    public IFvNodeModel getNodeModel() {
        return this.nmd;
    }

    public ViewGrapher getGraph() {
        IlvManager ilvManager = super.getManager();
        if (ilvManager instanceof IlvGrapher) {
            return (ViewGrapher)ilvManager;
        }
        return null;
    }

    public void resetZoom() {
        int n = this.getZoomCount();
        for (int i = 0; i < Math.abs(n - 0); ++i) {
            if (n < 0) {
                this.zoomIn();
                continue;
            }
            this.zoomOut();
        }
    }

    protected void zoomIn() {
        ++this.zoomCount;
        Dimension dimension = super.getSize();
        super.zoom(new IlvPoint((float)(dimension.width / 2), (float)(dimension.height / 2)), 1.1, 1.1, true);
    }

    protected void zoomOut() {
        --this.zoomCount;
        Dimension dimension = super.getSize();
        super.zoom(new IlvPoint((float)(dimension.width / 2), (float)(dimension.height / 2)), 0.9090909090909091, 0.9090909090909091, true);
    }

    public int getZoomCount() {
        return this.zoomCount;
    }

    void resetZoomCount() {
        this.zoomCount = 0;
    }

    public void setAntiAliasing(boolean bl) {
        super.setAntialiasing(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSpringLayout(IlvGrapher ilvGrapher, Rectangle2D rectangle2D) {
        if (ilvGrapher == null) {
            return;
        }
        IlvSpringEmbedderLayout ilvSpringEmbedderLayout = new IlvSpringEmbedderLayout();
        ilvSpringEmbedderLayout.attach(ilvGrapher);
        ViewCardGrapher[] viewCardGrapherArray = this.getNodes();
        for (int i = 0; i < viewCardGrapherArray.length; ++i) {
            ViewCardGrapher viewCardGrapher = viewCardGrapherArray[i];
        }
        ilvSpringEmbedderLayout.setPreserveFixedNodes(true);
        ilvSpringEmbedderLayout.setLayoutRegion((IlvManagerView)this);
        try {
            ilvSpringEmbedderLayout.performLayout(false, true);
        }
        catch (Exception exception) {
        }
        finally {
            ilvSpringEmbedderLayout.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getallComponents() {
        ArrayList<IlvGraphic> arrayList = new ArrayList<IlvGraphic>();
        AbstractView abstractView = this;
        synchronized (abstractView) {
            IlvGraphicEnumeration ilvGraphicEnumeration = this.rootGraph.getObjects();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                arrayList.add(ilvGraphicEnumeration.nextElement());
            }
        }
        return arrayList.toArray(new Object[0]);
    }

    public double clipWorldX(double d) {
        if (d > (double)AbstractView.getCanvasWidth()) {
            d = AbstractView.getCanvasWidth();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public double clipWorldY(double d) {
        if (d > (double)AbstractView.getCanvasHeight()) {
            d = AbstractView.getCanvasHeight();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public ViewCardGrapher[] getNodes() {
        LinkedList<Component> linkedList = new LinkedList<Component>();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof ViewCardGrapher)) continue;
            linkedList.add(componentArray[i]);
        }
        return linkedList.toArray(new ViewCardGrapher[0]);
    }

    public void doUniformLengthEdgesLayout(Rectangle2D rectangle2D) {
    }

    void reDraw(Rectangle2D rectangle2D) {
        super.invalidateRect(new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight()));
        super.reDrawViews();
    }

    public void reDraw() {
        super.invalidateView();
        try {
            this.linkLayout.performLayout();
        }
        catch (IlvGraphLayoutException ilvGraphLayoutException) {
            ilvGraphLayoutException.printStackTrace();
        }
        super.reDrawViews();
    }

    public Object getFunctObjectAt(float f, float f2) {
        IlvGraphic ilvGraphic = this.getGraph().getObject(new IlvPoint(f, f2), this);
        if (ilvGraphic instanceof IlvIcon) {
            return null;
        }
        return ilvGraphic;
    }

    public JComponent getGraphWindow() {
        if (this.graphWin == null) {
            this.graphWin = new IlvJScrollManagerView((IlvManagerView)this);
            this.graphWin.setPreferredSize(new Dimension(600, 600));
        }
        return this.graphWin;
    }

    public static int getCanvasCenterX() {
        return 2600;
    }

    public static int getCanvasCenterY() {
        return 1200;
    }

    public static int getCanvasHeight() {
        return 2400;
    }

    public static int getCanvasWidth() {
        return 5200;
    }

    double getRotationAngle(IlvLinkImage ilvLinkImage) {
        double d = 0.0;
        IlvPoint[] ilvPointArray = ilvLinkImage.getLinkPoints(this.getTransformer());
        if (ilvPointArray.length == 2) {
            double d2 = ilvPointArray[1].getX() - ilvPointArray[0].getX();
            double d3 = ilvPointArray[1].getY() - ilvPointArray[0].getY();
            d = d2 == 0.0 ? 90.0 : Math.toDegrees(Math.atan(d3 / d2));
        }
        if (d < 0.0) {
            d = 360.0 + d;
        }
        return d;
    }

    Point2D.Double getWorldPoint(Point2D.Double double_) {
        IlvPoint ilvPoint = new IlvPoint((float)double_.getX(), (float)double_.getY());
        this.getTransformer().inverse(ilvPoint);
        return new Point2D.Double(ilvPoint.getX(), ilvPoint.getY());
    }

    public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
        this.viewChanged();
    }

    protected abstract double viewChanged();

    public abstract void showFunctViewPowerBallons();

    public void fitView() {
        this.dofit();
    }

    private void dofit() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewGrapher viewGrapher = AbstractView.this.getGraph();
                if (viewGrapher != null) {
                    AbstractView.this.fitTransformerToContent();
                    AbstractView.this.zoomCount = 0;
                }
            }
        });
    }

    public void setDefaultView() {
        IlvTransformer ilvTransformer = this.getTransformer();
        double d = 1.0;
        double d2 = this.getViewRect().getWidth();
        double d3 = this.getViewRect().getHeight();
        Rectangle2D.Float float_ = new Rectangle2D.Float(AbstractView.DEFAULT_RECT.x, AbstractView.DEFAULT_RECT.y, AbstractView.DEFAULT_RECT.width, AbstractView.DEFAULT_RECT.height);
        double d4 = (((RectangularShape)float_).getWidth() - d2) / 2.0;
        double d5 = (((RectangularShape)float_).getHeight() - d3) / 2.0;
        IlvTransformer ilvTransformer2 = new IlvTransformer(d, ilvTransformer.getx12(), ilvTransformer.getx21(), d, -(((RectangularShape)float_).getX() + d4), -(((RectangularShape)float_).getY() + d5));
        this.setTransformer(ilvTransformer2);
        this.resetZoomCount();
        this.reDraw();
    }

    public void setDefaultViewTo(IlvGraphic ilvGraphic) {
        IlvTransformer ilvTransformer = this.getTransformer();
        IlvTransformer ilvTransformer2 = null;
        IlvTransformer.computeTransformer((IlvRect)this.getGraph().boundingBox(), (IlvRect)ilvGraphic.boundingBox(), ilvTransformer2);
        this.setTransformer(ilvTransformer2);
        this.resetZoomCount();
        this.reDraw();
    }

    public void centerView(Map<String, ViewDomainGrapher> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        IlvTransformer ilvTransformer = this.getTransformer();
        double d = 1.0;
        double d2 = this.getViewRect().getWidth();
        double d3 = this.getViewRect().getHeight();
        Rectangle2D rectangle2D = this.getRect(map);
        double d4 = (rectangle2D.getWidth() - d2) / 2.0;
        double d5 = (rectangle2D.getHeight() - d3) / 2.0;
        IlvTransformer ilvTransformer2 = new IlvTransformer(d, ilvTransformer.getx12(), ilvTransformer.getx21(), d, -(rectangle2D.getX() + d4), -(rectangle2D.getY() + d5));
        this.setTransformer(ilvTransformer2);
        this.resetZoomCount();
        this.reDraw();
    }

    public Rectangle2D getRect(Map<String, ViewDomainGrapher> map) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (map == null || map.size() == 0) {
            return double_;
        }
        double d = AbstractView.getCanvasWidth();
        double d2 = AbstractView.getCanvasHeight();
        double d3 = 0.0;
        double d4 = 0.0;
        for (ViewDomainGrapher viewDomainGrapher : map.values()) {
            double d5 = viewDomainGrapher.getInfo().getCenterX();
            double d6 = viewDomainGrapher.getInfo().getCenterY();
            if (d5 < d) {
                d = d5;
            }
            if (d6 < d2) {
                d2 = d6;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        double_.setRect(d, d2, d3 - d, d4 - d2);
        return double_;
    }

    boolean isSelectZoom() {
        return this.getInteractor() instanceof IlvZoomViewInteractor;
    }

    void zoomSelectedArea() {
        if (this.zoomViewInteractor == null) {
            this.zoomViewInteractor = new IlvZoomViewInteractor();
        }
        super.pushInteractor((IlvManagerViewInteractor)this.zoomViewInteractor);
        this.resetZoomCount();
    }

    public Rectangle2D getViewRect() {
        return new Rectangle2D.Double(0.0, 0.0, super.visibleRect().getWidth(), super.visibleRect().getHeight());
    }

    protected ViewCardGrapher[] getCards() {
        return new ViewCardGrapher[0];
    }

    protected void doAutoLayout() {
        Point2D.Double double_;
        ViewCardGrapher viewCardGrapher;
        int n;
        Rectangle2D rectangle2D = this.getViewRect();
        HashMap<ViewCardGrapher, Point2D.Double> hashMap = new HashMap<ViewCardGrapher, Point2D.Double>();
        ViewCardGrapher[] viewCardGrapherArray = this.getCards();
        for (n = 0; n < viewCardGrapherArray.length; ++n) {
            viewCardGrapher = viewCardGrapherArray[n];
            double_ = new Point2D.Double(viewCardGrapher.boundingBox().getCenterX(), viewCardGrapher.boundingBox().getCenterY());
            hashMap.put(viewCardGrapher, double_);
        }
        this.doSpringLayout(this.rootGraph, rectangle2D);
        this.doUniformLengthEdgesLayout(rectangle2D);
        this.postAutoLayout();
        if (!FunctDialog.instance().yesNoFvDialog(this.getGraphWindow(), "Accept Auto Layout result?", "Auto Layout")) {
            for (n = 0; n < viewCardGrapherArray.length; ++n) {
                viewCardGrapher = viewCardGrapherArray[n];
                double_ = (Point2D.Double)hashMap.get(viewCardGrapher);
                if (double_ == null) continue;
                Double d = new Double(double_.getX());
                Double d2 = new Double(double_.getY());
                viewCardGrapher.safeMove(d.floatValue(), d2.floatValue());
            }
            this.reDraw();
        }
    }

    void postAutoLayout() {
        ViewCardGrapher[] viewCardGrapherArray = this.getCards();
        Rectangle2D rectangle2D = this.getRect(viewCardGrapherArray);
        double d = this.getTransformer().getx11();
        double d2 = Math.abs(this.getTransformer().getx0() / d);
        double d3 = Math.abs(this.getTransformer().gety0() / d);
        double d4 = d2 - rectangle2D.getX();
        double d5 = d3 - rectangle2D.getY();
        for (int i = 0; i < viewCardGrapherArray.length; ++i) {
            ViewCardGrapher viewCardGrapher = viewCardGrapherArray[i];
            Double d6 = new Double(viewCardGrapher.boundingBox().getCenterX() + d4 + 50.0);
            Double d7 = new Double(viewCardGrapher.boundingBox().getCenterY() + d5 + 50.0);
            viewCardGrapher.safeMove(d6.floatValue(), d7.floatValue());
        }
    }

    public Rectangle2D getRect(ViewCardGrapher[] viewCardGrapherArray) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (viewCardGrapherArray == null || viewCardGrapherArray.length == 0) {
            return double_;
        }
        double d = AbstractView.getCanvasWidth();
        double d2 = AbstractView.getCanvasHeight();
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < viewCardGrapherArray.length; ++i) {
            ViewCardGrapher viewCardGrapher = viewCardGrapherArray[i];
            if (viewCardGrapher == null) continue;
            double d5 = viewCardGrapher.boundingBox().getCenterX();
            double d6 = viewCardGrapher.boundingBox().getCenterY();
            if (d5 < d) {
                d = d5;
            }
            if (d6 < d2) {
                d2 = d6;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        double_.setRect(d, d2, d3 - d, d4 - d2);
        return double_;
    }

    public ViewGeneralGrapher getRootGraph() {
        return this.rootGraph;
    }

    @Override
    public boolean isZoomLevelVisible() {
        return true;
    }

    class CustomSelectInteractor
    extends IlvSelectInteractor {
        CustomSelectInteractor() {
        }

        protected IlvManagerViewInteractor getMoveSelectionInteractor() {
            return new CustomSelectInteractorMoveSelection(this);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = 50;
            IlvTransformer ilvTransformer = this.getTransformer();
            int n2 = (int)ilvTransformer.getx0();
            int n3 = (int)ilvTransformer.gety0();
            int n4 = keyEvent.getKeyCode();
            Rectangle rectangle = AbstractView.this.visibleRect();
            int n5 = (int)rectangle.getHeight();
            int n6 = (int)rectangle.getWidth();
            double d = ilvTransformer.getx11();
            double d2 = ilvTransformer.getx22();
            if (n4 == 33 || n4 == 38) {
                if (n3 <= 0) {
                    int n7 = Math.abs(n3) < 2 * n ? Math.abs(n3) : n;
                    AbstractView.this.translate(0.0f, n7, true);
                }
            } else if (n4 == 34 || n4 == 40) {
                double d3 = (double)(Math.abs(n3) + n5) / d2;
                if (d3 < 2400.0) {
                    int n8 = (int)(2400.0 * d2 - (double)Math.abs(n3) - (double)n5);
                    int n9 = Math.min(n8, n);
                    AbstractView.this.translate(0.0f, -1 * n9, true);
                }
            } else if (n4 == 37) {
                if (n2 <= 0) {
                    int n10 = Math.abs(n2) < 2 * n ? Math.abs(n2) : n;
                    AbstractView.this.translate(n10, 0.0f, true);
                }
            } else if (n4 == 39) {
                double d4 = (double)(Math.abs(n2) + n6) / d;
                if (d4 < 5200.0) {
                    int n11 = (int)(5200.0 * d - (double)Math.abs(n2) - (double)n6);
                    int n12 = Math.min(n11, n);
                    AbstractView.this.translate(-1 * n12, 0.0f, true);
                }
            } else if (n4 == 36) {
                // empty if block
            }
        }
    }

    class CustomSelectInteractorMoveSelection
    extends IlvSelectInteractorMoveSelection {
        public CustomSelectInteractorMoveSelection(IlvSelectInteractor ilvSelectInteractor) {
            super(ilvSelectInteractor);
        }
    }
}

