/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvAlarmStatus;
import cerent.cms.fv.IFvAlarmStore;
import cerent.util.view.fv.ViewAlarmGrapher;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;

public class AlarmCounterGraphic
extends Observable
implements Observer,
Runnable {
    private IFvAlarmStore alarmStore;
    private ViewAlarmGrapher vAlmGraph;
    private boolean init;

    public AlarmCounterGraphic(ViewAlarmGrapher viewAlarmGrapher) {
        this.vAlmGraph = viewAlarmGrapher;
        this.init = false;
        this.run();
    }

    @Override
    public void update(Observable observable, Object object) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        if (!this.init) {
            String string = this.vAlmGraph.getSideNameAssociated();
            if (string.equals("Omnidirectional")) {
                string = "Unknown";
            }
            this.setAlarmStore(this.vAlmGraph.getViewManager().getElementAlarmStore(string));
        } else if (this.alarmStore != null) {
            IFvAlarmStatus iFvAlarmStatus = this.alarmStore.getAlarmStatus();
            this.vAlmGraph.setAlarmLabel(Integer.toString(iFvAlarmStatus.critical()) + " CR", ViewAlarmGrapher.AlarmEnum.CR);
            this.vAlmGraph.setAlarmLabel(Integer.toString(iFvAlarmStatus.major()) + " MJ", ViewAlarmGrapher.AlarmEnum.MJ);
            this.vAlmGraph.setAlarmLabel(Integer.toString(iFvAlarmStatus.minor()) + " MN", ViewAlarmGrapher.AlarmEnum.MN);
        }
    }

    public void setAlarmStore(IFvAlarmStore iFvAlarmStore) {
        if (iFvAlarmStore != null) {
            if (this.alarmStore != null) {
                this.alarmStore.deleteAlarmStatusObserver(this);
            }
            this.alarmStore = iFvAlarmStore;
            if (this.alarmStore != null) {
                this.alarmStore.addAlarmStatusObserver(this);
            }
            this.init = true;
        }
        SwingUtilities.invokeLater(this);
    }

    public void destroy() {
        if (this.alarmStore != null) {
            this.alarmStore.deleteAlarmStatusObserver(this);
        }
    }
}

