/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.IFvDebug;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.ViewCircuitPathElement;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.helper.FunctDebug;
import ilog.views.IlvLinkImage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class ViewCircuitPath
implements IObserver {
    private ArrayList<ViewCircuitPathElement> activeCircuitElements = null;
    private boolean workingIsActive;
    private IFvInterfaceModel psmInterface;
    private IFvDebug db = FunctDebug.instance().addChild("ViewCircuitPath", "Dump the info related to CircuitPath");
    private ViewManagerToolKit vm;
    HashMap<IViewLink, Color> patchcordVerifiedLinks;
    private float originalWidth = 2.0f;

    public ViewCircuitPath(ViewManagerToolKit viewManagerToolKit) {
        this.vm = viewManagerToolKit;
        this.patchcordVerifiedLinks = new HashMap();
    }

    public void paint(Collection<ViewCircuitPathElement> collection) {
        this.clearActiveCircuit();
        this.activeCircuitElements = new ArrayList<ViewCircuitPathElement>(collection);
        this.registerPsmInterface();
        this.updatePaint();
    }

    public void paintAddedObj(ViewCircuitPathElement viewCircuitPathElement) {
        this.activeCircuitElements.add(viewCircuitPathElement);
        this.updatePaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPsmInterface() {
        if (this.activeCircuitElements != null) {
            ArrayList<ViewCircuitPathElement> arrayList = this.activeCircuitElements;
            synchronized (arrayList) {
                for (int i = 0; i < this.activeCircuitElements.size(); ++i) {
                    ViewCircuitPathElement viewCircuitPathElement = this.activeCircuitElements.get(i);
                    if (this.psmInterface != null) continue;
                    this.psmInterface = viewCircuitPathElement.getPsmInterface();
                    if (this.psmInterface == null) continue;
                    try {
                        this.workingIsActive = this.psmInterface.isCurrentlyActive();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        this.workingIsActive = true;
                        this.workingIsActive = true;
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        this.workingIsActive = true;
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        this.workingIsActive = true;
                    }
                    ((IObservable)((Object)this.psmInterface)).addObserver(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePaint() {
        IFvNodeModel iFvNodeModel = null;
        if (this.activeCircuitElements != null) {
            ArrayList<ViewCircuitPathElement> arrayList = this.activeCircuitElements;
            synchronized (arrayList) {
                for (int i = 0; i < this.activeCircuitElements.size(); ++i) {
                    ViewCircuitPathElement viewCircuitPathElement = this.activeCircuitElements.get(i);
                    if (iFvNodeModel == null && (iFvNodeModel = viewCircuitPathElement.getNode()) != null) {
                        iFvNodeModel.clearSelectedCircuitCells();
                    }
                    IViewLink iViewLink = viewCircuitPathElement.getLink();
                    viewCircuitPathElement.setDebugInfo(true);
                    if (iViewLink != null && iViewLink instanceof IlvLinkImage) {
                        IlvLinkImage ilvLinkImage = (IlvLinkImage)iViewLink;
                        ilvLinkImage.reDraw();
                    }
                    if (iFvNodeModel == null) continue;
                    iFvNodeModel.addSelectedCircuitCell(viewCircuitPathElement.getTableCell());
                }
            }
        }
        if (this.vm.isOpenedFromNetFv()) {
            this.maskAlarmForCircuit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActiveCircuit() {
        this.dispose();
        if (this.activeCircuitElements != null) {
            ArrayList<ViewCircuitPathElement> arrayList = this.activeCircuitElements;
            synchronized (arrayList) {
                for (ViewCircuitPathElement viewCircuitPathElement : this.activeCircuitElements) {
                    viewCircuitPathElement.setDebugInfo(false);
                    IViewLink iViewLink = viewCircuitPathElement.getLink();
                    if (!(iViewLink instanceof IlvLinkImage)) continue;
                    IlvLinkImage ilvLinkImage = (IlvLinkImage)iViewLink;
                    ilvLinkImage.reDraw();
                }
                this.maskAlarmForCircuit(false);
            }
        }
    }

    public void maskAlarmForCircuit(boolean bl) {
        if (this.vm != null) {
            this.vm.maskAlarmForCircuit(bl);
        }
    }

    @Override
    public void update(IObservable iObservable, Object object) {
        if (this.db.on()) {
            this.db.println("ObjectChange = " + iObservable + "in ViewCircuitPath");
        }
        if (iObservable instanceof IFvInterfaceModel) {
            try {
                boolean bl = this.psmInterface.isCurrentlyActive();
                if (bl != this.workingIsActive) {
                    this.workingIsActive = bl;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewCircuitPath.this.updatePaint();
                        }
                    });
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace(noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                FunctDebug.printStackTrace(wrongInterfaceType);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                FunctDebug.printStackTrace(unsupportedOperation);
            }
        }
    }

    public void dispose() {
        if (this.psmInterface != null) {
            ((IObservable)((Object)this.psmInterface)).deleteObserver(this);
        }
    }

    public void clearActiveVerifiedPatchCords() {
        Iterator<IViewLink> iterator = this.patchcordVerifiedLinks.keySet().iterator();
        while (iterator.hasNext()) {
            IViewLink iViewLink = iterator.next();
            if (!(iViewLink instanceof IlvLinkImage)) continue;
            Color color = this.patchcordVerifiedLinks.get(iViewLink);
            ((IlvLinkImage)iViewLink).setForeground(color);
            ((IlvLinkImage)iViewLink).setLineWidth(this.originalWidth);
            ((IlvLinkImage)iViewLink).reDraw();
            iterator.remove();
        }
    }

    public void paintVerifiedPatchCords(HashMap<IViewLink, Integer> hashMap, Color color, int n) {
        for (IViewLink iViewLink : hashMap.keySet()) {
            if (!(iViewLink instanceof IlvLinkImage)) continue;
            Color color2 = new Color(((IlvLinkImage)iViewLink).getForeground().getRGB());
            ((IlvLinkImage)iViewLink).setForeground(color);
            if (n != -1) {
                this.originalWidth = ((IlvLinkImage)iViewLink).getLineWidth();
                ((IlvLinkImage)iViewLink).setLineWidth((float)n);
            }
            ((IlvLinkImage)iViewLink).reDraw();
            this.patchcordVerifiedLinks.put(iViewLink, color2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showBalloonActiveCircuit() {
        if (this.activeCircuitElements != null) {
            ArrayList<ViewCircuitPathElement> arrayList = this.activeCircuitElements;
            synchronized (arrayList) {
                for (ViewCircuitPathElement viewCircuitPathElement : this.activeCircuitElements) {
                    viewCircuitPathElement.setDebugInfo(true);
                    viewCircuitPathElement.setBalloonVisible(true);
                    viewCircuitPathElement.getNode().addSelectedCircuitCell(viewCircuitPathElement.getTableCell());
                }
            }
        }
    }
}

