/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.view.fv;

import cerent.cms.fv.IFvNodeModel;
import cerent.cms.fv.IFvPortModel;
import cerent.util.gui.UPopupMenu;
import cerent.util.view.fv.AbstractViewLink;
import cerent.util.view.fv.ISvgParams;
import cerent.util.view.fv.IViewGraph;
import cerent.util.view.fv.IViewGrapherCmd;
import cerent.util.view.fv.IViewLink;
import cerent.util.view.fv.IViewShapeInfo;
import cerent.util.view.fv.IViewSvgParamInfo;
import cerent.util.view.fv.MouseViewCommand;
import cerent.util.view.fv.ViewAttribute;
import cerent.util.view.fv.ViewCardGrapher;
import cerent.util.view.fv.ViewCompositeGraphic;
import cerent.util.view.fv.ViewGraphic;
import cerent.util.view.fv.ViewGraphicSet;
import cerent.util.view.fv.ViewLabel;
import cerent.util.view.fv.ViewManager;
import cerent.util.view.fv.ViewManagerToolKit;
import cerent.util.view.fv.ViewPin;
import cerent.util.view.fv.ViewPoint;
import cerent.util.view.fv.ViewPortGraphic;
import cerent.util.view.fv.ViewPureGraphicalLink;
import cerent.util.view.fv.ViewSvgDecoderHelper;
import cerent.util.view.fv.ViewSvgParamInfo;
import cerent.util.view.fv.ViewZoomLabel;
import cerent.util.view.fv.helper.FunctDebug;
import cerent.util.view.fv.helper.FunctException;
import ilog.views.IlvApplyObject;
import ilog.views.IlvDefaultManagerFrame;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerFrame;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.graphic.IlvDefaultCollapsedGraphic;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.prototypes.IlvGraphicElement;
import ilog.views.prototypes.IlvGroup;
import ilog.views.prototypes.IlvGroupBag;
import ilog.views.prototypes.IlvGroupElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;

public abstract class ViewGrapher
extends IlvGrapher
implements IViewGraph,
IViewGrapherCmd {
    protected ISvgParams params = null;
    protected HashMap<String, IViewGraph> children = new HashMap();
    protected HashMap<Integer, IViewLink> graphLinks = new HashMap();
    protected HashMap<Integer, ViewPureGraphicalLink> mpoLinks = new HashMap();
    protected HashMap<Integer, IViewLink> sideGraphLinks = new HashMap();
    protected ViewLabel graphlabel_hf = null;
    protected ViewLabel graphlabel_vf = null;
    protected IlvGraphic background = null;
    protected ViewGraphic extraIcon = null;
    protected HashMap<String, ViewZoomLabel> cardlabels = new HashMap();

    @Override
    public void dispose() {
        Collection<Object> collection;
        Object object;
        this.params = null;
        if (this.children != null) {
            object = this.children.values();
            collection = object.iterator();
            while (collection.hasNext()) {
                Iterator<Object> iterator = (IViewGraph)collection.next();
                iterator.dispose();
                iterator = null;
            }
            this.children.clear();
            this.children = null;
        }
        object = this.getObjects();
        if (this.graphLinks != null) {
            collection = this.graphLinks.values();
            for (Object object2 : collection) {
                if (this.isManaged((IlvGraphic)((AbstractViewLink)object2))) {
                    this.reDraw();
                }
                object2.dispose();
            }
            this.graphLinks.clear();
            this.graphLinks = null;
        }
        if (this.cardlabels != null) {
            collection = this.cardlabels.values();
            for (Object object2 : collection) {
                ((ViewZoomLabel)object2).dispose();
            }
            this.cardlabels.clear();
            this.cardlabels = null;
        }
        if (this.mpoLinks != null) {
            collection = this.mpoLinks.values();
            for (Object object2 : collection) {
                if (this.isManaged((IlvGraphic)((AbstractViewLink)object2))) {
                    // empty if block
                }
                object2.dispose();
            }
            this.mpoLinks.clear();
            this.mpoLinks = null;
        }
        if (this.sideGraphLinks != null) {
            collection = this.sideGraphLinks.values();
            for (Object object2 : collection) {
                if (this.isManaged((IlvGraphic)((AbstractViewLink)object2))) {
                    // empty if block
                }
                object2.dispose();
            }
            this.sideGraphLinks.clear();
            this.sideGraphLinks = null;
        }
        if ((collection = this.getGraphicBag()) == null) {
            this.setCollapsedGraphic((IlvGraphic)new IlvDefaultCollapsedGraphic());
        } else {
            collection.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ViewGrapher.this.setCollapsedGraphic((IlvGraphic)new IlvDefaultCollapsedGraphic());
                }
            }, null, false);
        }
        this.graphlabel_hf = null;
        this.graphlabel_vf = null;
        this.background = null;
        this.extraIcon = null;
    }

    public ISvgParams getParams() {
        return this.params;
    }

    public void grapherRotate(Point point, double d) {
        this.safeRotate(new IlvPoint((float)point.x, (float)point.y), d);
    }

    private IlvGroupBag getgBag() {
        return IlvGroupBag.getGroupBag((IlvManager)this);
    }

    @Override
    public HashMap<String, IViewGraph> getGraphChildren() {
        if (this.children != null) {
            return (HashMap)this.children.clone();
        }
        return null;
    }

    public HashMap<String, IViewGraph> getGraphChildren(String string) {
        HashMap<String, IViewGraph> hashMap = new HashMap<String, IViewGraph>();
        Collection<IViewGraph> collection = this.getGraphChildren().values();
        for (IViewGraph iViewGraph : collection) {
            String string2 = iViewGraph.getGraphKey();
            if (!string2.contains(string)) continue;
            hashMap.put(string2, iViewGraph);
        }
        return hashMap;
    }

    public HashMap<Integer, IViewLink> getGraphLinks() {
        if (this.graphLinks == null) {
            return new HashMap<Integer, IViewLink>();
        }
        return (HashMap)this.graphLinks.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphLinks(Integer n, IViewLink iViewLink) {
        HashMap<Integer, IViewLink> hashMap = this.graphLinks;
        synchronized (hashMap) {
            this.graphLinks.put(n, iViewLink);
        }
    }

    public HashMap<Integer, IViewLink> getMpoLinks() {
        if (this.mpoLinks == null) {
            return new HashMap<Integer, IViewLink>();
        }
        return (HashMap)this.mpoLinks.clone();
    }

    public void insertMpoLinks(Integer n, ViewPureGraphicalLink viewPureGraphicalLink) {
        this.mpoLinks.put(n, viewPureGraphicalLink);
    }

    public HashMap<Integer, IViewLink> getSideGraphLinks() {
        return (HashMap)this.sideGraphLinks.clone();
    }

    public ViewGrapher(ISvgParams iSvgParams) {
        this.params = iSvgParams;
    }

    public IViewGraph getOwner() {
        return this.params.getOwner();
    }

    public ViewManager getViewManager() {
        if (this.params == null) {
            return null;
        }
        return this.params.getViewManager();
    }

    public IFvNodeModel getNode() {
        return this.getViewManager().getNode();
    }

    public ViewManagerToolKit getTk() {
        return this.getViewManager().getViewTk();
    }

    public boolean isTheActiveGraph() {
        return this.getTk().getGraph() == this;
    }

    public int compareTo(IViewGraph iViewGraph) {
        return iViewGraph.getGraphKey().compareTo(this.getGraphKey());
    }

    private ViewAttribute<IViewSvgParamInfo, Object, Object> getViewAttr(IlvGraphic ilvGraphic) {
        try {
            ViewSvgParamInfo viewSvgParamInfo = ViewSvgDecoderHelper.getSvgParamInfo(ilvGraphic.getName());
            return new ViewAttribute(viewSvgParamInfo, ilvGraphic);
        }
        catch (FunctException functException) {
            FunctDebug.printStackTrace(functException);
            return null;
        }
    }

    protected void initViewGraphic(Object object) {
        if (object instanceof ViewGraphicSet) {
            IlvGroup ilvGroup;
            IlvGraphic[] ilvGraphicArray;
            ViewGraphicSet viewGraphicSet = (ViewGraphicSet)((Object)object);
            HashMap<Integer, IFvPortModel> hashMap = this.getModels();
            IlvGraphicEnumeration ilvGraphicEnumeration = viewGraphicSet.getObjects();
            LinkedList<IlvGraphic> linkedList = new LinkedList<IlvGraphic>();
            ArrayList<IlvGraphic[]> arrayList = new ArrayList<IlvGraphic[]>();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvGraphicArray = ilvGraphicEnumeration.nextElement();
                if (!Character.isUpperCase(ilvGraphicArray.getName().charAt(0)) || ilvGraphicArray.getName().length() < 9) continue;
                arrayList.add(ilvGraphicArray);
            }
            ilvGraphicArray = arrayList.toArray(new IlvGraphic[0]);
            for (int i = 0; i < ilvGraphicArray.length; ++i) {
                ViewSvgDecoderHelper.SvgTypeEnum svgTypeEnum;
                IViewSvgParamInfo iViewSvgParamInfo;
                IlvGraphic ilvGraphic = ilvGraphicArray[i];
                boolean bl = false;
                ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute = this.getViewAttr(ilvGraphic);
                if (viewAttribute == null || (iViewSvgParamInfo = viewAttribute.getKey()) == null || (svgTypeEnum = iViewSvgParamInfo.getSvgTyp()) == ViewSvgDecoderHelper.SvgTypeEnum.UNK) continue;
                try {
                    switch (viewAttribute.getKey().getSvgTyp()) {
                        case CARD_BCKG: {
                            this.updateCardBckgInfo(viewAttribute);
                            this.background = ilvGraphic;
                            break;
                        }
                        case CARD_PORT: {
                            this.setInfoPos(viewAttribute);
                            viewAttribute.setBag(hashMap);
                            IViewGraph iViewGraph = this.createCardPort(viewAttribute);
                            if (iViewGraph != null) {
                                this.addPort(iViewGraph, viewAttribute.getKey());
                            }
                            bl = true;
                            break;
                        }
                        case MPO_PORT: {
                            this.setInfoPos(viewAttribute);
                            viewAttribute.setBag(hashMap);
                            this.addPort(this.createMpoPort(viewAttribute), viewAttribute.getKey());
                            bl = true;
                            break;
                        }
                        case SIDE_PORT: {
                            this.setInfoPos(viewAttribute);
                            viewAttribute.setBag(hashMap);
                            this.addPort(this.createSidePort(viewAttribute), viewAttribute.getKey());
                            bl = true;
                            break;
                        }
                        case SIDE_LABEL: {
                            this.createSideLabel(viewAttribute);
                            break;
                        }
                        case WORK_SELECT_LINE: 
                        case PROT_SELECT_LINE: {
                            this.createSelectorLine(viewAttribute);
                            break;
                        }
                        case ICON_LABEL: {
                            this.createIconLabel(viewAttribute);
                            break;
                        }
                        case PORT_LABEL: {
                            this.createPortLabel(viewAttribute);
                            break;
                        }
                        case ALARM_LABEL: {
                            this.createAlarmLabel(viewAttribute);
                            break;
                        }
                        case CARD_NAME_LABEL: {
                            this.createCardNameLabel(viewAttribute);
                            break;
                        }
                        case CARD_EXTRA_LABEL: {
                            this.createCardExtraLabel(viewAttribute);
                            break;
                        }
                        case EXTRA_ICON: {
                            this.createExtraIcon(viewAttribute);
                            break;
                        }
                        case ALARM_BALLOON: {
                            this.makeBalloonVisible(ilvGraphic, false);
                            break;
                        }
                    }
                    if (!bl) continue;
                    linkedList.add((IlvGraphic)viewAttribute.getValue());
                    continue;
                }
                catch (FunctException functException) {
                    FunctDebug.printStackTrace(functException);
                    continue;
                }
                catch (Exception exception) {
                    FunctDebug.printStackTrace(exception);
                }
            }
            for (IlvGraphic ilvGraphic : linkedList) {
                if (this.getGraphicBag() == null) continue;
                viewGraphicSet.removeObject(ilvGraphic, false);
            }
            viewGraphicSet.setName(this.getGraphName());
            if (this.isDomain()) {
                this.getCollapsedGraphic();
                ilvGroup = this.getGraphicBag();
                if (ilvGroup == null) {
                    this.setCollapsedGraphic((IlvGraphic)viewGraphicSet);
                    this.setCollapsed(false);
                } else {
                    ilvGroup.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                        public void apply(IlvGraphic ilvGraphic, Object object) {
                            ViewGrapher.this.setCollapsedGraphic((IlvGraphic)object);
                            ViewGrapher.this.setCollapsed(false);
                        }
                    }, (Object)viewGraphicSet, false);
                }
            } else {
                ilvGroup = this.createGroup(viewGraphicSet);
                viewGraphicSet.setToolTipText(this.getGraphName());
                this.disableAll();
            }
        }
    }

    protected void makeBalloonVisible(IlvGraphic ilvGraphic, boolean bl) {
    }

    public void setLabelVisible(ViewSvgDecoderHelper.SvgTypeEnum svgTypeEnum) {
        if (this.graphlabel_hf == null || this.graphlabel_vf == null) {
            return;
        }
        switch (svgTypeEnum) {
            case CARD_NAME_LABEL: {
                this.graphlabel_hf.setVisible(false);
                this.graphlabel_vf.setVisible(false);
                break;
            }
            case CARD_LABEL_HF: {
                this.graphlabel_hf.setVisible(true);
                this.graphlabel_vf.setVisible(false);
                break;
            }
            case CARD_LABEL_VF: {
                this.graphlabel_hf.setVisible(false);
                this.graphlabel_vf.setVisible(true);
                break;
            }
        }
    }

    public abstract String getShortName();

    public void setAlarmColor(final Color color) {
        this.background = ((IlvGraphicSet)this.getCollapsedGraphic()).getObject("CARD_BCKG");
        if (this.background != null && color != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewGrapher.this.background.setBackground(color);
                    ViewGrapher.this.reDraw();
                    ViewGrapher.this.paintParent(color);
                }
            });
        }
    }

    public abstract void paintParent(Color var1);

    private IlvGroup createGroup(ViewGraphicSet viewGraphicSet) {
        IlvGroupBag ilvGroupBag = new IlvGroupBag((IlvManager)this);
        IlvGroup ilvGroup = new IlvGroup(this.getGraphKey());
        ilvGroup.addElement((IlvGroupElement)new IlvGraphicElement((IlvGraphic)viewGraphicSet));
        for (IViewGraph iViewGraph : this.getGraphChildren().values()) {
            if (!(iViewGraph instanceof ViewPortGraphic)) continue;
            ilvGroup.addElement((IlvGroupElement)new IlvGraphicElement((IlvGraphic)((ViewPortGraphic)iViewGraph)));
        }
        ilvGroupBag.addGroup(ilvGroup);
        return ilvGroup;
    }

    protected boolean isDomain() {
        return false;
    }

    protected HashMap<Integer, IFvPortModel> getModels() {
        return null;
    }

    protected void disableAll() {
        IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            this.setSelectable(ilvGraphic, true);
            this.setMovable(ilvGraphic, false);
            this.setEditable(ilvGraphic, false);
        }
    }

    protected String getGrapherName() {
        return this.getGraphKey();
    }

    private void setInfoPos(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) {
        viewAttribute.getKey().setPos((Rectangle2D)((IlvGraphic)viewAttribute.getValue()).boundingBox());
    }

    protected void createPortLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createCardNameLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createCardExtraLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createExtraIcon(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createAlarmLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createSideLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createSelectorLine(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected void createIconLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    protected IViewGraph createSidePort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected IViewGraph createMpoPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected IViewGraph createCardPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception, FunctException {
        ViewSvgDecoderHelper.SvgTypePortEnum svgTypePortEnum = viewAttribute.getKey().getSvgPortTyp();
        if (svgTypePortEnum == null) {
            throw new FunctException("Error in port Creation");
        }
        if (svgTypePortEnum == ViewSvgDecoderHelper.SvgTypePortEnum.BAND_PORT) {
            return this.createBandPort(viewAttribute);
        }
        return this.createGenericPort(viewAttribute);
    }

    protected IViewGraph createBandPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected IViewGraph createGenericPort(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected ViewLabel createCardLabel(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
        return null;
    }

    protected void addPort(IViewGraph iViewGraph, IViewSvgParamInfo iViewSvgParamInfo) {
    }

    protected void addCardBackground(IlvGraphic ilvGraphic) {
        Background background = new Background(ilvGraphic);
        this.addNode((IlvGraphic)background, IViewGraph.Layers.Port.ordinal(), true);
        this.setSelectable((IlvGraphic)background, true);
        this.setMovable((IlvGraphic)background, true);
        this.setEditable((IlvGraphic)background, false);
        background.setVisible(true);
    }

    protected void addLabel(ViewLabel viewLabel) {
        this.addObject((IlvGraphic)viewLabel, false);
    }

    protected void updateCardBckgInfo(ViewAttribute<IViewSvgParamInfo, Object, Object> viewAttribute) throws Exception {
    }

    public abstract IViewShapeInfo getInfo();

    protected abstract void onInitPopupMenu(UPopupMenu var1);

    protected void addViewGraph(Object object, int n, boolean bl) {
        if (object instanceof IlvGraphic) {
            this.addObject((IlvGraphic)object, n, bl);
        }
    }

    public boolean isObjectsIntersected(Object object, Object object2) {
        if (object instanceof IlvGrapher && object2 instanceof IlvGrapher) {
            IlvGrapher ilvGrapher = (IlvGrapher)object;
            IlvGrapher ilvGrapher2 = (IlvGrapher)object2;
            IlvRect ilvRect = ilvGrapher.boundingBox();
            IlvRect ilvRect2 = ilvGrapher2.boundingBox();
            return ilvRect.intersects((Rectangle2D)ilvRect2);
        }
        return false;
    }

    @Override
    public void addGraph(IViewGraph iViewGraph, boolean bl, IViewGraph.Layers layers) {
        if (iViewGraph instanceof IlvGraphic && !this.children.containsKey(iViewGraph.getGraphKey())) {
            this.children.put(iViewGraph.getGraphKey(), iViewGraph);
            IlvGraphic ilvGraphic = (IlvGraphic)iViewGraph;
            ViewManager.addToLog(this, "ViewGrapher> addGraph name:" + iViewGraph.getGraphKey() + " layer:" + (Object)((Object)layers));
            this.addObject(ilvGraphic, layers.ordinal(), bl);
        }
    }

    @Override
    public void addGraphNode(IViewGraph iViewGraph, boolean bl, IViewGraph.Layers layers) {
        this.addGraphNode(iViewGraph, bl, layers, iViewGraph.getGraphKey());
    }

    public void setFrameName(String string) {
        ((IlvDefaultManagerFrame)this.getFrame()).setTitle(string);
    }

    public String getFrameName() {
        return ((IlvDefaultManagerFrame)this.getFrame()).getTitle();
    }

    public void setManagerFrame(String string) {
        IlvDefaultManagerFrame ilvDefaultManagerFrame = new IlvDefaultManagerFrame();
        ilvDefaultManagerFrame.setTitle(string);
        ilvDefaultManagerFrame.setShowingTitle(true);
        ilvDefaultManagerFrame.setOpaque(true);
        ilvDefaultManagerFrame.setMaxTitleZoomFactor(2.0);
        ilvDefaultManagerFrame.setFont(new Font("Verdana", 0, 28));
        ilvDefaultManagerFrame.setTitleColor(Color.BLACK);
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.setFrame((IlvManagerFrame)ilvDefaultManagerFrame);
        } else {
            ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ((IlvGrapher)ilvGraphic).setFrame((IlvManagerFrame)((IlvDefaultManagerFrame)object));
                }
            }, (Object)ilvDefaultManagerFrame, false);
        }
    }

    protected void addGraphNode(IViewGraph iViewGraph, boolean bl, IViewGraph.Layers layers, String string) {
        if (iViewGraph != null && !this.children.containsKey(string)) {
            this.children.put(string, iViewGraph);
            ViewManager.addToLog(this, "ViewGrapher> addGraphNode name:" + string + " layer:" + (Object)((Object)layers));
            try {
                this.addNode((IlvGraphic)iViewGraph, layers.ordinal(), bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void delGraphNode(IViewGraph iViewGraph) {
        if (iViewGraph != null && this.children.containsKey(iViewGraph.getGraphKey())) {
            IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
            if (ilvGraphicBag == null) {
                this.removeObject((IlvGraphic)iViewGraph, false);
            } else {
                ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        ((ViewGrapher)ilvGraphic).removeObject((IlvGraphic)object, false);
                    }
                }, (Object)iViewGraph, false);
            }
            this.children.remove(iViewGraph.getGraphKey());
        }
    }

    public void delGraphNode(IViewGraph iViewGraph, boolean bl) {
        if (iViewGraph != null && this.children.containsKey(iViewGraph.getGraphKey())) {
            IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
            if (ilvGraphicBag == null) {
                this.removeObject((IlvGraphic)iViewGraph, bl);
            } else {
                ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        ((ViewGrapher)ilvGraphic).removeObject((IlvGraphic)object, true);
                    }
                }, (Object)iViewGraph, false);
            }
            this.children.remove(iViewGraph.getGraphKey());
        }
    }

    public void delGraphLink(IViewLink iViewLink, boolean bl) {
        if (iViewLink != null) {
            IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
            if (ilvGraphicBag == null) {
                this.removeObject((IlvGraphic)iViewLink, bl);
            } else {
                ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        ((ViewGrapher)ilvGraphic).removeObject((IlvGraphic)object, true);
                    }
                }, (Object)iViewLink, false);
            }
            this.graphLinks.remove(iViewLink.getIndex());
            this.mpoLinks.remove(iViewLink.getIndex());
            this.sideGraphLinks.remove(iViewLink.getIndex());
        }
    }

    public int compareTo(Object object) {
        return 0;
    }

    @Override
    public IViewGraph getGraphParent() {
        return null;
    }

    @Override
    public void doMouseClick(MouseViewCommand mouseViewCommand) {
    }

    @Override
    public void doMouseDoubleClick(MouseViewCommand mouseViewCommand) {
    }

    @Override
    public void doMouseDrag(MouseViewCommand mouseViewCommand) {
    }

    @Override
    public void doMousePopup(MouseViewCommand mouseViewCommand) {
    }

    @Override
    public void doMouseUpdate(MouseViewCommand mouseViewCommand) {
    }

    public Rectangle2D getGraphBound() {
        return this.boundingBox().getBounds2D();
    }

    @Override
    public IViewGraph.Layers getLayer() {
        return this.params.getLayer();
    }

    public void doFlipH() {
    }

    public void doFlipV() {
    }

    public void flipPortsLabel(int n, int n2) {
        for (ViewZoomLabel viewZoomLabel : this.cardlabels.values()) {
            float f = (float)viewZoomLabel.boundingBox().getMinX();
            float f2 = (float)viewZoomLabel.boundingBox().getMinY();
            viewZoomLabel.safeScale(n, n2);
            viewZoomLabel.safeMove(new ViewPoint(f, f2));
        }
    }

    public String toString() {
        return "ViewGrapher";
    }

    public ViewPortGraphic getPortGraph(int n) {
        return (ViewPortGraphic)this.getGraphChildren().get(ViewManager.idToString(n));
    }

    public void setViewCollapsed(final boolean bl) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.setCollapsed(bl);
        } else {
            ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ViewGrapher.this.setCollapsed(bl);
                }
            }, (Object)this, false);
        }
    }

    public void setViewCollapsedGraphic(final IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.setCollapsedGraphic(ilvGraphic);
        } else {
            ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic2, Object object) {
                    ViewGrapher.this.setCollapsedGraphic(ilvGraphic);
                }
            }, null, false);
        }
    }

    public void connectPorts(ViewCompositeGraphic viewCompositeGraphic, ViewPortGraphic viewPortGraphic, ViewCompositeGraphic viewCompositeGraphic2, ViewPortGraphic viewPortGraphic2, IViewLink iViewLink) throws FunctException {
        if (viewPortGraphic != null) {
            iViewLink.setFromName(viewPortGraphic.getPortName());
        } else {
            iViewLink.setFromName("Omnidirectional");
        }
        if (viewPortGraphic2 != null) {
            iViewLink.setToName(viewPortGraphic2.getPortName());
        } else {
            iViewLink.setToName("Omnidirectional");
        }
        this.addLink((IlvLinkImage)iViewLink, 1, false);
        HashMap<String, ViewPin> hashMap = viewCompositeGraphic.getGraphPins();
        HashMap<String, ViewPin> hashMap2 = viewCompositeGraphic2.getGraphPins();
        String string = "";
        if (viewCompositeGraphic instanceof ViewCardGrapher) {
            string = String.valueOf(((ViewCardGrapher)viewCompositeGraphic).getShelfId()) + "-" + String.valueOf(((ViewCardGrapher)viewCompositeGraphic).getSlotId()) + "-";
        }
        ViewPin viewPin = hashMap.get(string + viewPortGraphic.getPortName());
        String string2 = "";
        if (viewCompositeGraphic2 instanceof ViewCardGrapher) {
            string2 = String.valueOf(((ViewCardGrapher)viewCompositeGraphic2).getShelfId()) + "-" + String.valueOf(((ViewCardGrapher)viewCompositeGraphic2).getSlotId()) + "-";
        }
        ViewPin viewPin2 = hashMap2.get(string2 + viewPortGraphic2.getPortName());
        if (viewPin == null || viewPin2 == null) {
            throw new FunctException("Error in link Creation");
        }
        viewCompositeGraphic.getConnector().connectLink((IlvLinkImage)iViewLink, (IlvGrapherPin)viewPin, true);
        viewCompositeGraphic2.getConnector().connectLink((IlvLinkImage)iViewLink, (IlvGrapherPin)viewPin2, false);
    }

    public void addPureGraphicLink(ViewPureGraphicalLink viewPureGraphicalLink, IViewGraph iViewGraph, IViewGraph iViewGraph2) {
        if (iViewGraph instanceof IlvGraphic && iViewGraph2 instanceof IlvGraphic) {
            IlvGrapher ilvGrapher = IlvGrapher.getLowestCommonGrapher((IlvGraphic)((IlvGraphic)iViewGraph), (IlvGraphic)((IlvGraphic)iViewGraph2));
            ilvGrapher.addLink((IlvLinkImage)viewPureGraphicalLink, 1, false);
        }
    }

    public void safeScale(int n, int n2) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.scale(n, n2);
        } else {
            ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new ScaleGrapher(n, n2), (Object)this, true);
        }
    }

    public void safeMove(float f, float f2) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.move(f, f2);
        } else {
            ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new MoveGrapher(f, f2), (Object)this, true);
        }
    }

    @Override
    public void safeRotate(IlvPoint ilvPoint, double d) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag == null) {
            this.rotate(ilvPoint, d);
        } else {
            ilvGraphicBag.applyToObject((IlvGraphic)this, (IlvApplyObject)new RotateGrapher(ilvPoint, d), (Object)this, true);
        }
    }

    class Background
    extends IlvCompositeGraphic {
        public Background(IlvGraphic ilvGraphic) {
            IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
            if (ilvGraphicBag == null) {
                this.setChildren(0, ilvGraphic);
            } else {
                ilvGraphicBag.applyToObject((IlvGraphic)this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        ((IlvCompositeGraphic)ilvGraphic).setChildren(0, (IlvGraphic)object);
                    }
                }, (Object)ilvGraphic, false);
            }
        }
    }

    static class MoveGrapher
    implements IlvApplyObject {
        float x;
        float y;

        MoveGrapher(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            ilvGraphic.move(this.x, this.y);
        }
    }

    static class RotateGrapher
    implements IlvApplyObject {
        IlvPoint center;
        double angle;

        RotateGrapher(IlvPoint ilvPoint, double d) {
            this.center = ilvPoint;
            this.angle = d;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            ilvGraphic.rotate(this.center, this.angle);
        }
    }

    static class ScaleGrapher
    implements IlvApplyObject {
        double scalex;
        double scaley;

        ScaleGrapher(double d, double d2) {
            this.scalex = d;
            this.scaley = d2;
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            ilvGraphic.scale(this.scalex, this.scaley);
        }
    }
}

