/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.xml;

import cerent.cms.model.CTCUserException;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.xml.IDOMParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractDOMParser
implements IDOMParser,
ErrorHandler {
    protected static String charset = Preferences.instance().getProperty("ctc", "xml.charset", null);
    protected boolean isValidating;
    protected ErrorHandler handler_;
    protected DocumentBuilder parser;
    protected DocumentBuilderFactory factory;
    protected static final KDebug db = new KDebug("AbstractDOMParser", false);

    protected AbstractDOMParser(String string, KDebug kDebug) throws CTCUserException {
        this(kDebug);
    }

    protected AbstractDOMParser(KDebug kDebug) throws CTCUserException {
        this((URL)null, kDebug);
    }

    protected AbstractDOMParser(URL uRL, KDebug kDebug) throws CTCUserException {
        try {
            boolean bl = Preferences.instance().getBoolean("ctc", "xml.validation", false);
            this.handler_ = this;
            this.setDOMParser(uRL == null ? null : uRL.toExternalForm(), kDebug, bl);
        }
        catch (CTCUserException cTCUserException) {
            String string = "error in setting up parser feature - " + cTCUserException.getMessage();
            if (kDebug != null) {
                kDebug.println(string);
            } else {
                System.out.println(string);
            }
            throw cTCUserException;
        }
        catch (RuntimeException runtimeException) {
            String string = "error in setting up parser feature - " + runtimeException.getMessage();
            if (kDebug != null) {
                kDebug.println(string);
            } else {
                System.out.println(string);
            }
            throw new CTCUserException(string, runtimeException);
        }
    }

    public void setDOMParser(String string, KDebug kDebug, boolean bl) throws CTCUserException {
        block12: {
            if (kDebug != null && kDebug.on()) {
                kDebug.println("setDOMParser(\"" + string + "\", -, " + bl + ")");
            }
            if (this.parser != null && bl == this.isValidating) {
                if (kDebug != null && kDebug.on()) {
                    kDebug.println("parser already has validate mode" + bl);
                }
                return;
            }
            this.factory = DocumentBuilderFactory.newInstance();
            this.factory.setIgnoringElementContentWhitespace(false);
            this.setNamespaceAware(bl || this.getDefaultNamespaceAwareness());
            this.factory.setValidating(bl);
            try {
                this.factory.setAttribute("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (kDebug == null || !kDebug.on()) break block12;
                KDebug.printStackTrace((Throwable)illegalArgumentException);
            }
        }
        if (bl) {
            this.setSchema(string, kDebug);
        } else {
            this.disableSchema();
        }
        try {
            this.parser = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            if (kDebug != null) {
                kDebug.println("error from the factory being unable to load the specified parser implementation");
            } else {
                System.out.println("error from the factory being unable to load the specified parser implementation");
            }
            throw new CTCUserException("Error in loading parser: " + parserConfigurationException.toString());
        }
        if (bl) {
            this.setErrorHandler(this.handler_);
            this.setEntityResolver();
        }
        this.isValidating = bl;
    }

    protected boolean getDefaultNamespaceAwareness() {
        return false;
    }

    protected final void setNamespaceAware(boolean bl) {
        this.factory.setNamespaceAware(bl);
    }

    public ErrorHandler getErrorHandler() {
        return this.handler_;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.handler_ = errorHandler;
        this.parser.setErrorHandler(errorHandler);
    }

    protected abstract String getSchema();

    protected abstract void setSchema(String var1, KDebug var2) throws CTCUserException;

    protected void setSchema(KDebug kDebug) throws CTCUserException {
        this.setSchema(null, kDebug);
    }

    protected abstract void disableSchema();

    protected abstract void setEntityResolver() throws CTCUserException;

    @Override
    public Document parseString(String string) throws SAXException, IOException, CTCUserException {
        InputSource inputSource = new InputSource(new StringReader(string));
        inputSource.setSystemId("");
        return this.parser.parse(inputSource);
    }

    @Override
    public Document parse(String string) throws SAXException, IOException, CTCUserException {
        return this.parse(string, null);
    }

    protected static Object createStream(String string) throws IOException {
        Closeable closeable;
        InputStream inputStream;
        URL uRL;
        block8: {
            uRL = null;
            inputStream = null;
            closeable = null;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                if (db == null || !db.on()) break block8;
                KDebug.printStackTrace((Throwable)malformedURLException);
            }
        }
        if (uRL != null) {
            if (db != null && db.on()) {
                db.println("parsing stream from url: " + uRL.toExternalForm());
            }
            inputStream = uRL.openStream();
        } else {
            File file = new File(string);
            if (db != null && db.on()) {
                db.println("parsing stream from file: " + file);
            }
            inputStream = new FileInputStream(file);
        }
        if (charset != null) {
            if (db != null && db.on()) {
                db.println("decoding file " + string + " thru chaset: " + charset + " reader");
            }
            closeable = new InputStreamReader(inputStream, charset);
        }
        return closeable != null ? closeable : inputStream;
    }

    public Document parse(String string, KDebug kDebug) throws SAXException, IOException, CTCUserException {
        Object var3_3 = null;
        InputStream inputStream = null;
        Reader reader = null;
        try {
            Document document;
            Object object = AbstractDOMParser.createStream(string);
            if (object instanceof Reader) {
                reader = (Reader)object;
                document = this.parse(reader);
            } else {
                inputStream = (InputStream)object;
                document = this.parse(inputStream);
            }
            Document document2 = document;
            return document2;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    KDebug.printStackTrace((Throwable)iOException);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    KDebug.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException, CTCUserException {
        InputSource inputSource = new InputSource(inputStream);
        return this.parse(inputSource);
    }

    public Document parse(Reader reader) throws SAXException, IOException, CTCUserException {
        InputSource inputSource = new InputSource(reader);
        return this.parse(inputSource);
    }

    public final Document parse(InputSource inputSource) throws SAXException, IOException, CTCUserException {
        return this.parser.parse(inputSource);
    }

    protected void logSAXException(SAXParseException sAXParseException, String string) throws SAXException {
        String string2 = string + " " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage();
        db.println(string2);
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.logSAXException(sAXParseException, "[Warning]");
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.logSAXException(sAXParseException, "[Error]");
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.logSAXException(sAXParseException, "[Fatal Error]");
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }
}

