/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.xml;

import cerent.util.matcher.AbstractMatcher;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CmsXmlSerializer
extends XMLSerializer {
    private AbstractMatcher matcher = null;
    static final Class superClass = XMLSerializer.class;
    static final String fPreserveSpaceFieldName = "fPreserveSpace";
    static final String mPrintAttributeName = "printAttribute";
    static final Class[] mPrintAttributeTypes = new Class[]{String.class, String.class, Boolean.TYPE};
    static final String mPrintNamespaceAttrName = "printNamespaceAttr";
    static final Class[] mPrintNamespaceAttrTypes = new Class[]{String.class, String.class};

    public CmsXmlSerializer(AbstractMatcher abstractMatcher) {
        this.matcher = abstractMatcher;
    }

    protected void serializeElement(Element element) throws IOException {
        String string;
        String string2;
        Attr attr;
        int n;
        if (this.fNamespaces) {
            this.fLocalNSBinder.reset();
            this.fNSBinder.pushContext();
        }
        String string3 = element.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string3);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (elementState.inCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
        }
        this.setPreserveSpace(elementState.preserveSpace);
        int n2 = 0;
        NamedNodeMap namedNodeMap = null;
        if (element.hasAttributes()) {
            namedNodeMap = element.getAttributes();
            n2 = namedNodeMap.getLength();
        }
        if (!this.fNamespaces) {
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            for (n = 0; n < n2; ++n) {
                attr = (Attr)namedNodeMap.item(n);
                string2 = attr.getName();
                string = attr.getValue();
                if (string == null) {
                    string = "";
                }
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    this._printer.printText(string2);
                    this._printer.printText("=\"");
                    this.printEscaped(string);
                    this._printer.printText('\"');
                }
                if (!string2.equals("xml:space")) continue;
                if (string.equals("preserve")) {
                    this.setPreserveSpace(true);
                    continue;
                }
                this.setPreserveSpace(this._format.getPreserveSpace());
            }
        } else {
            String string4;
            boolean bl;
            String string5;
            for (n = 0; n < n2; ++n) {
                attr = (Attr)namedNodeMap.item(n);
                string5 = attr.getNamespaceURI();
                if (string5 == null || !string5.equals(NamespaceContext.XMLNS_URI)) continue;
                string = attr.getNodeValue();
                if (string == null) {
                    string = XMLSymbols.EMPTY_STRING;
                }
                if (string.equals(NamespaceContext.XMLNS_URI)) {
                    if (this.fDOMErrorHandler == null) continue;
                    this.modifyDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)2, attr);
                    bl = this.fDOMErrorHandler.handleError((DOMError)this.fDOMError);
                    if (bl) continue;
                    throw new RuntimeException("Stopped at user request");
                }
                string4 = attr.getPrefix();
                string4 = string4 == null || string4.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                String string6 = this.fSymbolTable.addSymbol(attr.getLocalName());
                if (string4 == XMLSymbols.PREFIX_XMLNS) {
                    if ((string = this.fSymbolTable.addSymbol(string)).length() == 0) continue;
                    this.fNSBinder.declarePrefix(string6, string);
                    continue;
                }
                string = this.fSymbolTable.addSymbol(string);
                this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, string);
            }
            string5 = element.getNamespaceURI();
            string4 = element.getPrefix();
            if (string5 != null && string4 != null && string5.length() == 0 && string4.length() != 0) {
                string4 = null;
                this._printer.printText('<');
                this._printer.printText(element.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(string3);
                this._printer.indent();
            }
            if (string5 != null) {
                string5 = this.fSymbolTable.addSymbol(string5);
                String string7 = string4 = string4 == null || string4.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                if (this.fNSBinder.getURI(string4) != string5) {
                    this.cmsPrintNamespaceAttr(string4, string5);
                    this.fLocalNSBinder.declarePrefix(string4, string5);
                    this.fNSBinder.declarePrefix(string4, string5);
                }
            } else if (element.getLocalName() == null) {
                if (this.fDOMErrorHandler != null) {
                    this.modifyDOMError("DOM Level 1 Node: " + element.getNodeName(), (short)2, element);
                    bl = this.fDOMErrorHandler.handleError((DOMError)this.fDOMError);
                    if (!bl) {
                        throw new RuntimeException("Process stoped at user request");
                    }
                }
            } else {
                string5 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                if (string5 != null && string5.length() > 0) {
                    this.cmsPrintNamespaceAttr(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                }
            }
            for (n = 0; n < n2; ++n) {
                attr = (Attr)namedNodeMap.item(n);
                string = attr.getValue();
                string2 = attr.getNodeName();
                string5 = attr.getNamespaceURI();
                if (string5 != null && string5.length() == 0) {
                    string5 = null;
                    string2 = attr.getLocalName();
                }
                if (string == null) {
                    string = XMLSymbols.EMPTY_STRING;
                }
                if (string5 != null) {
                    string4 = attr.getPrefix();
                    string4 = string4 == null ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                    String string8 = this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (string5 != null && string5.equals(NamespaceContext.XMLNS_URI)) {
                        String string9;
                        string4 = attr.getPrefix();
                        string4 = string4 == null || string4.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                        string8 = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (string4 == XMLSymbols.PREFIX_XMLNS) {
                            string9 = this.fLocalNSBinder.getURI(string8);
                            if ((string = this.fSymbolTable.addSymbol(string)).length() == 0 || string9 != null) continue;
                            this.cmsPrintNamespaceAttr(string8, string);
                            this.fLocalNSBinder.declarePrefix(string8, string);
                            continue;
                        }
                        string5 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                        string9 = this.fLocalNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                        string = this.fSymbolTable.addSymbol(string);
                        if (string9 != null) continue;
                        this.cmsPrintNamespaceAttr(XMLSymbols.EMPTY_STRING, string);
                        continue;
                    }
                    string5 = this.fSymbolTable.addSymbol(string5);
                    String string10 = this.fNSBinder.getURI(string4);
                    if (string4 == XMLSymbols.EMPTY_STRING || string10 != string5) {
                        string2 = attr.getNodeName();
                        String string11 = this.fNSBinder.getPrefix(string5);
                        if (string11 != null && string11 != XMLSymbols.EMPTY_STRING) {
                            string4 = string11;
                            string2 = string4 + ":" + string8;
                        } else {
                            if (string4 == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string4) != null) {
                                int n3 = 1;
                                string4 = this.fSymbolTable.addSymbol("NS" + n3++);
                                while (this.fLocalNSBinder.getURI(string4) != null) {
                                    string4 = this.fSymbolTable.addSymbol("NS" + n3++);
                                }
                                string2 = string4 + ":" + string8;
                            }
                            this.cmsPrintNamespaceAttr(string4, string5);
                            string = this.fSymbolTable.addSymbol(string);
                            this.fLocalNSBinder.declarePrefix(string4, string);
                            this.fNSBinder.declarePrefix(string4, string5);
                        }
                    }
                    this.cmsPrintAttribute(string2, string == null ? XMLSymbols.EMPTY_STRING : string, attr.getSpecified());
                    continue;
                }
                if (attr.getLocalName() == null) {
                    if (this.fDOMErrorHandler != null) {
                        this.modifyDOMError("DOM Level 1 Node: " + string2, (short)2, attr);
                        boolean bl2 = this.fDOMErrorHandler.handleError((DOMError)this.fDOMError);
                        if (!bl2) {
                            throw new RuntimeException("Stopped at user request");
                        }
                    }
                    this.cmsPrintAttribute(string2, string, attr.getSpecified());
                    continue;
                }
                this.cmsPrintAttribute(string2, string, attr.getSpecified());
            }
        }
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string3, this.getPreserveSpace());
            elementState.doCData = this._format.isCDataElement(string3);
            elementState.unescaped = this._format.isNonEscapingElement(string3);
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!this.acceptChild(node)) continue;
                this.serializeNode(node);
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, string3);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            elementState.afterElement = true;
            elementState.afterComment = false;
            elementState.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    protected boolean acceptChild(Node node) {
        boolean bl = this.matcher == null || this.matcher.doesMatch(node);
        return bl;
    }

    private boolean getPreserveSpace() {
        boolean bl = false;
        try {
            Field field = superClass.getField(fPreserveSpaceFieldName);
            field.setAccessible(true);
            Boolean bl2 = (Boolean)field.get((Object)this);
            bl = bl2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private void setPreserveSpace(boolean bl) {
        try {
            Field field = superClass.getField(fPreserveSpaceFieldName);
            field.setAccessible(true);
            field.set((Object)this, new Boolean(bl));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cmsPrintAttribute(String string, String string2, boolean bl) throws IOException {
        try {
            Method method = superClass.getMethod(mPrintAttributeName, mPrintAttributeTypes);
            method.setAccessible(true);
            method.invoke((Object)this, string, string2, new Boolean(bl));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cmsPrintNamespaceAttr(String string, String string2) throws IOException {
        try {
            Method method = superClass.getMethod(mPrintNamespaceAttrName, mPrintNamespaceAttrTypes);
            method.setAccessible(true);
            method.invoke((Object)this, string, string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

