/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.xml;

import cerent.cms.model.CTCUserException;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.matcher.NotMatcher;
import cerent.util.matcher.OrMatcher;
import cerent.util.xml.AbstractDOMMatcher;
import cerent.util.xml.CmsXmlSerializer;
import cerent.util.xml.DOMAncestoryMatcher;
import cerent.util.xml.DOMIterator;
import cerent.util.xml.NodeNameMatcher;
import cerent.util.xml.NodeTypeMatcher;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static final int STD_INDENT = 2;
    public static final String OOB_TAG = "OutOfBand";
    public static final String ATTR_FAULTS_TAG = "AttributeFaults";
    private static final String XML_DEBUG = "ctc.xml.debug";
    private static final String PRINT_OOB = "printoob";
    private static final String PRINT_ALL = "ALL";
    private static final String FAULTS_ONLY = "FAULTS_ONLY";
    private static final String PRINT_NONE = "NONE";
    static DocumentBuilderFactory BuilderFactory = DocumentBuilderFactory.newInstance();
    static DocumentBuilder DocBuilder = null;
    static AbstractMatcher ElementMatcher = new NodeTypeMatcher(1);
    static AbstractMatcher TextMatcher = new NodeTypeMatcher(3);
    static AbstractMatcher CDATAMatcher = new NodeTypeMatcher(4);
    static AbstractMatcher CommentMatcher = new NodeTypeMatcher(8);
    static AbstractDOMMatcher oobMatcher = new NodeNameMatcher("OutOfBand");
    static AbstractDOMMatcher faultsMatcher = new NodeNameMatcher("AttributeFaults");
    static final byte MAX_ANCESTORY_HEIGHT = 3;
    static OrMatcher eleOrCommMatcher = new OrMatcher("", new AbstractMatcher[]{ElementMatcher, CommentMatcher});
    static AbstractDOMMatcher[] oobRelativeMatchers = new AbstractDOMMatcher[]{oobMatcher};
    static AbstractDOMMatcher[] faultOnlyRelativeMatchers = new AbstractDOMMatcher[]{oobMatcher, faultsMatcher};
    static DOMAncestoryMatcher anyAncestoryMatcher = new DOMAncestoryMatcher(null, null, 3);
    static DOMAncestoryMatcher oobAncestoryMatcher = new DOMAncestoryMatcher(oobMatcher, oobRelativeMatchers, 3);
    static AbstractMatcher notOobAncestoryMatcher = new NotMatcher("", oobAncestoryMatcher);
    static DOMAncestoryMatcher faultsOnlyAncestoryMatcher = new DOMAncestoryMatcher(oobMatcher, faultOnlyRelativeMatchers, 3);
    static KDebug db;

    private DOMUtil() {
    }

    public static Iterator getRootChildren(Document document) {
        Element element = document.getDocumentElement();
        return new DOMIterator(element, eleOrCommMatcher);
    }

    public static List getChildElements(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                arrayList.add(node2);
            }
        }
        return arrayList;
    }

    public static Iterator getChildElementsIterator(Node node) {
        return new DOMIterator(node, ElementMatcher);
    }

    public static Iterator getChildTextNodes(Node node) {
        return new DOMIterator(node, TextMatcher);
    }

    public static Iterator getChildCDATANodes(Node node) {
        return new DOMIterator(node, CDATAMatcher);
    }

    public static int getSize(Iterator iterator) {
        int n = -1;
        if (iterator instanceof DOMIterator) {
            DOMIterator dOMIterator = (DOMIterator)iterator;
            n = dOMIterator.size();
        }
        return n;
    }

    public static Document getOwnerDocument(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("getOwnerDocument() node arg cannot be null");
        }
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        return document;
    }

    public static String nodeToString(Node node) throws CTCUserException {
        return DOMUtil.nodeToString(node, 0, false, null);
    }

    public static String nodeToString(Node node, String string) throws CTCUserException {
        return DOMUtil.nodeToString(node, 2, false, string);
    }

    public static String nodeToString(Node node, int n, boolean bl) throws CTCUserException {
        return DOMUtil.nodeToString(node, 2, false, null);
    }

    public static String nodeToString(Node node, int n, boolean bl, String string) throws CTCUserException {
        if (node == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        AbstractMatcher abstractMatcher = DOMUtil.getPrintControlMatcher();
        CmsXmlSerializer cmsXmlSerializer = new CmsXmlSerializer(abstractMatcher);
        cmsXmlSerializer.setOutputCharStream(stringWriter);
        OutputFormat outputFormat = new OutputFormat();
        if (n > 0) {
            outputFormat.setLineSeparator(System.getProperty("line.separator"));
            outputFormat.setIndent(n);
        } else {
            outputFormat.setPreserveSpace(true);
        }
        if (string != null) {
            outputFormat.setEncoding(string);
        }
        boolean bl2 = bl && !node.equals(DOMUtil.getOwnerDocument(node));
        outputFormat.setOmitXMLDeclaration(bl2);
        cmsXmlSerializer.setOutputFormat(outputFormat);
        String string2 = "";
        boolean bl3 = node instanceof Element;
        try {
            if (!bl || !bl3) {
                cmsXmlSerializer.serialize(DOMUtil.getOwnerDocument(node));
            } else {
                cmsXmlSerializer.serialize((Element)node);
            }
            string2 = stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new CTCUserException("XmlSerializer failed -- may've hit an illegal character (per UTF-8) char. set", iOException);
        }
        return string2;
    }

    public static Document createDocument() {
        return DocBuilder.newDocument();
    }

    public static Document createDocument(String string, String string2) {
        DOMImplementation dOMImplementation = DocBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(string, null, string2);
        return dOMImplementation.createDocument(null, string, documentType);
    }

    public static void appendChild(Node node, Node node2) {
        DOMUtil.appendChild(node, node2, null);
    }

    public static void appendChild(Node node, Node node2, Node node3) {
        DOMUtil.appendChild(node, node2, -1, node3);
    }

    public static void appendChild(Node node, Node node2, int n) {
        DOMUtil.appendChild(node, node2, n, null);
    }

    public static void appendChild(Node node, Node node2, int n, Node node3) {
        if (node == null) {
            throw new IllegalArgumentException("appendChild() parent arg cannot be null");
        }
        if (node2 == null) {
            return;
        }
        try {
            if (node2 != null) {
                if (node3 == null || node != node3.getParentNode()) {
                    node.appendChild(node2);
                } else {
                    node.insertBefore(node2, node3);
                }
            }
        }
        catch (DOMException dOMException) {
            if (db.on()) {
                db.println(dOMException + " error in " + (n == -1 ? "" : Integer.toString(n)) + " appendChild");
                String string = "???";
                try {
                    string = DOMUtil.nodeToString(node2, 2, true);
                }
                catch (CTCUserException cTCUserException) {
                    // empty catch block
                }
                db.println(string);
            }
            throw dOMException;
        }
    }

    public static void appendChildren(Node node, Node[] nodeArray) {
        DOMUtil.appendChildren(node, nodeArray, null);
    }

    public static void appendChildren(Node node, Node[] nodeArray, Node node2) {
        if (node == null) {
            throw new IllegalArgumentException("appendChildren() parent arg cannot be null");
        }
        if (nodeArray == null) {
            return;
        }
        int n = nodeArray.length;
        for (int i = 0; i < n; ++i) {
            DOMUtil.appendChild(node, nodeArray[i], i, node2);
        }
    }

    public static String[] getChildNodeTags(Node node) {
        if (node == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public static void removeAttributeNodes(Element element) {
        if (element.hasAttributes()) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                element.removeAttributeNode((Attr)namedNodeMap.item(i));
            }
        }
    }

    public static void copyInto(Node node, Node node2) throws DOMException {
        Document document = node2.getOwnerDocument();
        Node node3 = node;
        Node node4 = node;
        Node node5 = node;
        while (node5 != null) {
            Node node6 = null;
            short s = node5.getNodeType();
            switch (s) {
                case 4: {
                    node6 = document.createCDATASection(node5.getNodeValue());
                    break;
                }
                case 8: {
                    node6 = document.createComment(node5.getNodeValue());
                    break;
                }
                case 1: {
                    Element element = document.createElement(node5.getNodeName());
                    node6 = element;
                    NamedNodeMap namedNodeMap = node5.getAttributes();
                    int n = namedNodeMap.getLength();
                    for (int i = 0; i < n; ++i) {
                        Attr attr = (Attr)namedNodeMap.item(i);
                        String string = attr.getNodeName();
                        String string2 = attr.getNodeValue();
                        element.setAttribute(string, string2);
                    }
                    break;
                }
                case 5: {
                    node6 = document.createEntityReference(node5.getNodeName());
                    break;
                }
                case 7: {
                    node6 = document.createProcessingInstruction(node5.getNodeName(), node5.getNodeValue());
                    break;
                }
                case 3: {
                    node6 = document.createTextNode(node5.getNodeValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("can't copy node type, " + s + " (" + node5.getNodeName() + ')');
                }
            }
            node2.appendChild(node6);
            if (node5.hasChildNodes()) {
                node4 = node5;
                node5 = node5.getFirstChild();
                node2 = node6;
                continue;
            }
            node5 = node5.getNextSibling();
            while (node5 == null && node4 != node3) {
                node5 = node4.getNextSibling();
                node4 = node4.getParentNode();
                node2 = node2.getParentNode();
            }
        }
    }

    public static NodeList getNodesByNodeType(Node node, int n) {
        NodeListImpl nodeListImpl = new NodeListImpl();
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != n) continue;
            nodeListImpl.add(node2);
        }
        return nodeListImpl;
    }

    public static Iterator getElementNodes(Node node) {
        return new DOMIterator(node, ElementMatcher);
    }

    public static List copyToList(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    protected static AbstractMatcher getPrintControlMatcher() {
        String string = DOMUtil.getPrintOobSetting();
        AbstractMatcher abstractMatcher = anyAncestoryMatcher;
        if (string.equals(FAULTS_ONLY)) {
            abstractMatcher = new OrMatcher("", new AbstractMatcher[]{notOobAncestoryMatcher, faultsOnlyAncestoryMatcher});
        } else if (string.equals(PRINT_NONE)) {
            abstractMatcher = notOobAncestoryMatcher;
        }
        return abstractMatcher;
    }

    public static String getPrintOobSetting() {
        String string = Preferences.instance().getProperty(XML_DEBUG, PRINT_OOB, FAULTS_ONLY);
        return string;
    }

    static {
        try {
            DocBuilder = BuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            System.out.println("DOMUtil init error: " + exception.getMessage());
            exception.printStackTrace(System.out);
        }
        db = new KDebug("DOMUtil");
    }

    public static class NodeListImpl
    implements NodeList {
        ArrayList items = new ArrayList();

        public void add(Node node) {
            this.items.add(node);
        }

        @Override
        public int getLength() {
            return this.items.size();
        }

        @Override
        public Node item(int n) {
            return (Node)this.items.get(n);
        }
    }
}

