/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.CWIFile;
import com.cisco.hfr.cwi.installer.IDescriptorRetriever;
import com.cisco.hfr.cwi.installer.IncompatibleCWIXMLVersionException;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import com.cisco.hfr.cwi.installer.XMLParsingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CWIDescriptor {
    private Log mLog = LogFactory.getLog(CWIDescriptor.class);
    private static final String ELEMENT_CWIXML = "cwixml";
    private static final String ELEMENT_RESOURCES = "resources";
    private static final String ELEMENT_NATIVE_LIB = "nativelib";
    private static final String ELEMENT_JAR = "jar";
    private static final String ELEMENT_J2SE = "j2se";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_OS = "os";
    private static final String DEFAULT_MAJOR_VERSION = "1";
    private Element mRootElement = null;
    private HashMap mProperties = null;
    private HashMap mFiles = null;
    private IDescriptorRetriever mDescriptorRetriever = null;

    public CWIDescriptor(IDescriptorRetriever retriever) throws IOException, IncompatibleCWIXMLVersionException, XMLParsingException {
        this.mDescriptorRetriever = retriever;
        this.mProperties = new HashMap();
        this.mFiles = new HashMap();
        this.loadDescriptor();
    }

    private void loadDescriptor() throws IOException, IncompatibleCWIXMLVersionException, XMLParsingException {
        InputStream inputStream = this.mDescriptorRetriever.getDescriptorFile();
        this.mRootElement = this.getDescriptorElement(inputStream);
        this.loadDescriptorFromXML();
        try {
            inputStream.close();
        }
        catch (IOException ex) {
            this.mLog.warn("Exception while closing input stream that reads the descriptor file", ex);
        }
    }

    private Element getDescriptorElement(InputStream xmlStream) throws XMLParsingException {
        Document rootDocument = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            rootDocument = builder.parse(xmlStream);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            this.mLog.error("Errors while parsing the Response.", x);
            throw new XMLParsingException("Errors while parsing the Response.", x);
        }
        catch (ParserConfigurationException pce) {
            this.mLog.error("Parser Configuration Exception occurred.", pce);
            throw new XMLParsingException("XML Parser configuration error.", pce);
        }
        catch (Exception ex) {
            this.mLog.error("Unknown error while parsing the response.", ex);
            throw new XMLParsingException("Unknown error while parsing the response.", ex);
        }
        return rootDocument.getDocumentElement();
    }

    public Object getProperty(String propertyName) {
        return this.mProperties.get(propertyName);
    }

    private void loadDescriptorFromXML() throws IncompatibleCWIXMLVersionException {
        this.loadProperties();
        NodeList resourcesList = this.mRootElement.getElementsByTagName(ELEMENT_RESOURCES);
        String osName = InstallerUtil.getOSName();
        for (int i = 0; i < resourcesList.getLength(); ++i) {
            Element resElement = (Element)resourcesList.item(i);
            String resOs = resElement.getAttribute(ATTR_OS);
            if (resOs.length() != 0 && !resOs.equals(osName)) continue;
            this.loadResources(resElement);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadProperties() throws IncompatibleCWIXMLVersionException {
        Element featureReleaseElem;
        String featureRelease;
        Element j2seElem;
        String cwiXMLMaxHeapSize;
        String majorVersion = DEFAULT_MAJOR_VERSION;
        NodeList cwiXMLNodeList = this.mRootElement.getElementsByTagName(ELEMENT_CWIXML);
        if (cwiXMLNodeList.getLength() <= 0) throw new IncompatibleCWIXMLVersionException("The version on router could not be found. This could be due to pre 3.3 IOS-XR  software release");
        Element cwiXMLElem = (Element)cwiXMLNodeList.item(0);
        String cwiXMLVersion = cwiXMLElem.getAttribute(ATTR_VERSION);
        if (cwiXMLVersion.length() <= 0) throw new IncompatibleCWIXMLVersionException("The version on router could not be found. This could be due to pre 3.3 IOS-XR  software release");
        int dotIndex = cwiXMLVersion.indexOf(".");
        if (dotIndex == -1) throw new IncompatibleCWIXMLVersionException("The version on router is not of the expected format MajorVersionNumber.MinorVersionNumber");
        String cwiXMLMajorVersion = cwiXMLVersion.substring(0, dotIndex);
        if (!majorVersion.equals(cwiXMLMajorVersion)) {
            throw new IncompatibleCWIXMLVersionException("The major version on router does not match the version CWI can handle");
        }
        this.mProperties.put("cwixmlversion", cwiXMLVersion);
        String maxHeapSize = "512m";
        NodeList j2seNodeList = this.mRootElement.getElementsByTagName(ELEMENT_J2SE);
        if (j2seNodeList.getLength() > 0 && (cwiXMLMaxHeapSize = (j2seElem = (Element)j2seNodeList.item(0)).getAttribute("max-heap-size")).length() > 0) {
            maxHeapSize = cwiXMLMaxHeapSize;
        }
        this.mProperties.put("max-heap-size", maxHeapSize);
        NodeList featureReleaseNodeList = this.mRootElement.getElementsByTagName("featurerelease");
        if (featureReleaseNodeList.getLength() <= 0 || (featureRelease = (featureReleaseElem = (Element)featureReleaseNodeList.item(0)).getAttribute(ATTR_VERSION)).length() <= 0) return;
        this.mProperties.put("featurerelease", featureRelease);
    }

    private void loadResources(Element element) throws IncompatibleCWIXMLVersionException {
        NodeList childList = element.getElementsByTagName(ELEMENT_JAR);
        this.loadCWIFiles(childList);
        childList = element.getElementsByTagName(ELEMENT_NATIVE_LIB);
        this.loadCWIFiles(childList);
    }

    private void loadCWIFiles(NodeList childList) {
        for (int i = 0; i < childList.getLength(); ++i) {
            Node childNode = childList.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element childElement = (Element)childNode;
            CWIFile cwiFile = new CWIFile(childElement);
            this.mFiles.put((String)cwiFile.getProperty("contextname"), cwiFile);
        }
    }

    public CWIFile[] getAllCWIFiles() {
        Collection collection = this.mFiles.values();
        CWIFile[] cwiFiles = null;
        if (collection.size() > 0) {
            cwiFiles = collection.toArray(new CWIFile[collection.size()]);
        }
        return cwiFiles;
    }

    public CWIFile getCWIFile(String filename) {
        CWIFile file = (CWIFile)this.mFiles.get(filename);
        this.mLog.info("file for " + filename + " is " + file);
        return file;
    }
}

