/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.IFileVersion;
import com.cisco.hfr.cwi.installer.IVersion;
import com.cisco.hfr.cwi.installer.IncompatibleVersionListException;
import com.cisco.hfr.cwi.installer.IncompatibleVersionStringException;
import com.cisco.hfr.cwi.installer.VersionFactory;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CWIFile
implements IFileVersion {
    private Log mLog = LogFactory.getLog(CWIFile.class);
    public static final String FILE_PROPERTY_NAME = "name";
    public static final String FILE_PROPERTY_CONTEXT_NAME = "contextname";
    public static final String FILE_PROPERTY_VERSION = "version";
    public static final String FILE_PROPERTY_COMPATIBILITY = "compatibility";
    public static final String FILE_PROPERTY_BACKWARD_COMPATIBILITY = "backwardcompatibility";
    public static final String FILE_PROPERTY_NENAME = "name";
    public static final String FILE_PROPERTY_SIZE = "size";
    public static final String FILE_PROPERTY_IS_CLASSPATH = "classpath";
    public static final String FILE_PROPERTY_IS_BOOT_CLASSPATH = "bootclasspath";
    public static final String FILE_PROPERTY_IS_LIBRARYPATH = "librarypath";
    public static final String FILE_PROPERTY_LOCAL_NAME = "localname";
    public static final String FILE_PROPERTY_NATIVE_LIB = "nativelib";
    private static final String ELEMENT_NATIVE_LIB = "nativelib";
    private static final String ELEMENT_PLATFORM = "platform";
    private HashMap mProperties = new HashMap();

    public CWIFile(Element element) {
        this.loadFromXML(element);
    }

    private void loadFromXML(Element element) {
        String path;
        Element parentElement;
        String compatibility;
        String tagName = element.getTagName();
        if (tagName.equals("nativelib")) {
            this.mProperties.put("nativelib", Boolean.TRUE);
        }
        if ((compatibility = element.getAttribute(FILE_PROPERTY_COMPATIBILITY)).length() > 0) {
            this.mProperties.put(FILE_PROPERTY_COMPATIBILITY, compatibility);
        }
        String version = element.getAttribute(FILE_PROPERTY_VERSION);
        String backwardCompatibility = element.getAttribute(FILE_PROPERTY_BACKWARD_COMPATIBILITY);
        String neType = null;
        Node parentNode = element.getParentNode();
        if (parentNode.getNodeType() == 1 && (tagName = (parentElement = (Element)parentNode).getTagName()).equals(ELEMENT_PLATFORM)) {
            neType = parentElement.getAttribute("name");
        }
        if (version.length() > 0) {
            if (backwardCompatibility.length() == 0) {
                backwardCompatibility = null;
            }
            try {
                IVersion versionObj = VersionFactory.instance().getVersion(version, neType, backwardCompatibility);
                this.mProperties.put(FILE_PROPERTY_VERSION, versionObj);
            }
            catch (IncompatibleVersionStringException ex) {
                this.mLog.warn("IncompatibleVersionStringException occurred during initialization of VersionList ", ex);
            }
            catch (IncompatibleVersionListException ex) {
                this.mLog.warn("IncompatibleVersionListException occurred during initialization of VersionList ", ex);
            }
        }
        String name = element.getAttribute("name");
        this.mProperties.put("name", name);
        String localName = element.getAttribute(FILE_PROPERTY_LOCAL_NAME);
        if (localName.length() != 0) {
            this.mProperties.put(FILE_PROPERTY_LOCAL_NAME, localName);
        }
        String contextName = CWIFile.getContextName(name, neType);
        this.mProperties.put(FILE_PROPERTY_CONTEXT_NAME, contextName);
        String sizeStr = element.getAttribute(FILE_PROPERTY_SIZE);
        if (sizeStr.length() > 0) {
            try {
                Long size = Long.valueOf(sizeStr);
                this.mProperties.put(FILE_PROPERTY_SIZE, size);
            }
            catch (NumberFormatException ex) {
                this.mLog.error("Error while retreiving size for file " + contextName, ex);
            }
        }
        if ((path = element.getAttribute(FILE_PROPERTY_IS_CLASSPATH)).length() > 0) {
            this.mProperties.put(FILE_PROPERTY_IS_CLASSPATH, new Boolean(path));
        }
        if ((path = element.getAttribute(FILE_PROPERTY_IS_BOOT_CLASSPATH)).length() > 0) {
            this.mProperties.put(FILE_PROPERTY_IS_BOOT_CLASSPATH, new Boolean(path));
        }
        if ((path = element.getAttribute(FILE_PROPERTY_IS_LIBRARYPATH)).length() > 0) {
            this.mProperties.put(FILE_PROPERTY_IS_LIBRARYPATH, new Boolean(path));
        }
    }

    public IVersion getVersion() {
        return (IVersion)this.mProperties.get(FILE_PROPERTY_VERSION);
    }

    public String getFileName() {
        String localName = (String)this.mProperties.get(FILE_PROPERTY_LOCAL_NAME);
        if (localName == null) {
            localName = (String)this.mProperties.get("name");
        }
        return localName;
    }

    public Object getProperty(String propertyName) {
        return this.mProperties.get(propertyName);
    }

    public static String getContextName(String filename) {
        return CWIFile.getContextName(filename, null);
    }

    public static String getContextName(String filename, String neType) {
        StringBuffer contextName = new StringBuffer();
        if (neType != null) {
            contextName.append(neType);
            contextName.append(File.separator);
        }
        contextName.append(filename);
        return contextName.toString();
    }
}

