/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.ICacheBackup;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheBackup
implements ICacheBackup {
    private static final String sTempHome = System.getProperty("java.io.tmpdir");
    private Log mLog = LogFactory.getLog(CacheBackup.class);
    private File mCompatibilityDir = null;
    private File mTempDir = null;

    public CacheBackup(File compatibilityDir) throws IOException {
        this.mCompatibilityDir = compatibilityDir;
        if (this.mCompatibilityDir.exists() && this.mCompatibilityDir.isDirectory()) {
            String tempDirPath = sTempHome + File.separator + this.mCompatibilityDir.getName();
            this.mTempDir = new File(tempDirPath);
            this.mLog.debug("Copying " + this.mCompatibilityDir.getPath() + " to " + this.mTempDir.getPath());
            InstallerUtil.copyDirectory(this.mCompatibilityDir, this.mTempDir);
        }
    }

    public void restore() throws IOException {
        if (this.mTempDir != null) {
            InstallerUtil.copyDirectory(this.mTempDir, this.mCompatibilityDir);
        } else {
            InstallerUtil.deleteDirectory(this.mCompatibilityDir);
        }
    }

    public void clean() {
        if (this.mTempDir != null) {
            InstallerUtil.deleteDirectory(this.mTempDir);
        }
    }
}

