/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.CWIDescriptor;
import com.cisco.hfr.cwi.installer.CWIFile;
import com.cisco.hfr.cwi.installer.CompatibilityDirectory;
import com.cisco.hfr.cwi.installer.FileInstallDialog;
import com.cisco.hfr.cwi.installer.IFileRetriever;
import com.cisco.hfr.cwi.installer.IVersion;
import com.cisco.hfr.cwi.installer.IVersionList;
import com.cisco.hfr.cwi.installer.IncompatibleCWIFileVersionException;
import com.cisco.hfr.cwi.installer.IncompatibleVersionListException;
import com.cisco.hfr.cwi.installer.IncompatibleVersionStringException;
import com.cisco.hfr.cwi.installer.InstallFailException;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import com.cisco.hfr.cwi.installer.Preferences;
import com.cisco.hfr.cwi.installer.Version;
import com.cisco.hfr.cwi.installer.VersionFactory;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheUtilities {
    private static Log sLog = LogFactory.getLog(CacheUtilities.class);
    private static final String CLASSPATH = " -classpath ";
    private static final String EXTENSION_CMD = ".cmd";
    private static final String EXTENSION_SH = ".sh";
    private static final String EXTENSION_URL = ".url";
    private static final String BOOTSTRAP = " com.cisco.hfr.cwi.installer.Bootstrap";
    private static final String BOOTCLASSPATH = "-Xbootclasspath/p:";
    private static final String HEAPSIZE_OPTION = " -Xmx";
    private static final String LIBRARYPATH = " -Djava.library.path=";
    private static final String UNINSTALL = " com.cisco.hfr.cwi.installer.Uninstall ";
    private static final String UNINSTALL_POSTFIX = "_uninstall";
    private static final String SHORTCUT_MSG = "Shortcut to launch CWI has been installed on desktop.";
    private static final int NO_COMPAT_UPGRADE = 0;
    private static final int NEW_COMPAT_UPGRADE = 1;
    private static final int MINOR_COMPAT_UPGRADE = 2;
    private static final int MINOR_COMPAT_DOWNGRADE = 3;
    private static final Pattern javaVersionPttn = Pattern.compile("^(\\d+)\\.(\\d+)");

    private static CompatibilityDirectory downloadToExistingCompat(int installAction, File compatDir, File oldCompatDir, IFileRetriever fileRetriever, CWIDescriptor cwiDescriptor, String cwiDirPath, Component parent) throws Exception {
        CWIFile[] filesToBeDownloaded;
        int size;
        CompatibilityDirectory directory = null;
        ArrayList<CWIFile> lowerVersionCWIFiles = new ArrayList<CWIFile>();
        ArrayList<CWIFile> cacheCWIFiles = new ArrayList<CWIFile>();
        if (oldCompatDir != null) {
            if (installAction == 2) {
                sLog.debug("Minor upgrade - renaming: " + oldCompatDir.getName() + " to: " + compatDir.getName());
                sLog.debug("oldCompatDir canRead: " + oldCompatDir.canRead() + " , canWrite: " + oldCompatDir.canWrite());
                boolean success = oldCompatDir.renameTo(compatDir);
                sLog.debug("oldCompatDir.renameTo sucess code: " + success);
                if (!success) {
                    String errMsg = "Install can not proceed because an application currently has a file or directory\nopen within: " + oldCompatDir.getAbsolutePath() + ".\n\nPlease close any currently open browsers or" + "other applications and then retry.\n";
                    throw new InstallFailException(errMsg);
                }
            } else if (installAction == 3) {
                compatDir = oldCompatDir;
            }
        }
        directory = CacheUtilities.setupCompatibilityDirectory(cwiDescriptor, compatDir, cwiDirPath);
        CWIFile[] files = cwiDescriptor.getAllCWIFiles();
        for (int i = 0; i < files.length; ++i) {
            String cwiFileName = files[i].getFileName();
            IVersion descriptorFileVersion = files[i].getVersion();
            sLog.debug("Getting version info for " + cwiFileName);
            if (cwiFileName.equals("cwi_if.jar") && installAction == 2) {
                sLog.debug("Minor Compatibility upgrade - Updating the " + cwiFileName);
                cacheCWIFiles.add(files[i]);
                continue;
            }
            IVersion[] versions = directory.getVersions(cwiFileName);
            sLog.debug("Filename " + cwiFileName + " has the following " + "versions.\n");
            if (versions != null) {
                for (int k = 0; k < versions.length; ++k) {
                    sLog.debug("Version[" + k + "]=" + ((Object)versions[k]).toString() + "\n");
                }
            }
            boolean versionFound = false;
            int versionComparison = 0;
            if (versions != null) {
                for (int j = 0; j < versions.length; ++j) {
                    IVersion cacheFileVersion = versions[j];
                    try {
                        versionComparison = descriptorFileVersion.compareVersion(cacheFileVersion);
                        if (versionComparison != 0) continue;
                        versionFound = true;
                        break;
                    }
                    catch (IncompatibleCWIFileVersionException ex) {
                        sLog.warn("Version objects don't match : " + ((Object)descriptorFileVersion).toString() + "; " + ((Object)cacheFileVersion).toString());
                    }
                }
            }
            if (versionFound) {
                sLog.debug("Version for " + cwiFileName + " on descriptor is found in the cache.");
                continue;
            }
            if (installAction == 3) {
                if (!cwiFileName.equals("cwi_ne.jar")) continue;
                sLog.debug("Minor Compatibility downgrade - Updating the " + cwiFileName);
                cacheCWIFiles.add(files[i]);
                continue;
            }
            if (!cwiFileName.equals("cwi_ne.jar") && versionComparison == -1) {
                sLog.debug("Version for " + cwiFileName + " on descriptor is less than the one in cache.");
                lowerVersionCWIFiles.add(files[i]);
                continue;
            }
            if (versions == null) {
                sLog.debug("No version for " + cwiFileName + " found in cache. It seems to be a new file.");
            } else {
                sLog.debug("Version for " + cwiFileName + " on descriptor is more than the one in cache.");
            }
            cacheCWIFiles.add(files[i]);
        }
        if (lowerVersionCWIFiles.size() > 0 && InstallerUtil.showQuestionDialog(parent, "An earlier version of the CWI application is available to be installed.\n\nDo you wish to install the older version before completing this installation?")) {
            cacheCWIFiles.addAll(lowerVersionCWIFiles);
        }
        if ((size = cacheCWIFiles.size()) > 0 && (filesToBeDownloaded = cacheCWIFiles.toArray(new CWIFile[cacheCWIFiles.size()])) != null) {
            fileRetriever.getFiles(filesToBeDownloaded, directory);
        }
        return directory;
    }

    private static CompatibilityDirectory downLoadRequiredFiles(int installAction, File compatDir, File oldCompatDir, IFileRetriever fileRetriever, CWIDescriptor cwiDescriptor, String cwiDirPath, Component parent) throws Exception {
        CompatibilityDirectory directory = null;
        switch (installAction) {
            case 0: 
            case 2: 
            case 3: {
                directory = CacheUtilities.downloadToExistingCompat(installAction, compatDir, oldCompatDir, fileRetriever, cwiDescriptor, cwiDirPath, parent);
                break;
            }
            case 1: {
                compatDir.mkdirs();
                directory = CacheUtilities.setupCompatibilityDirectory(cwiDescriptor, compatDir, cwiDirPath);
                CWIFile[] filesToBeDownloaded = cwiDescriptor.getAllCWIFiles();
                if (filesToBeDownloaded == null) break;
                fileRetriever.getFiles(filesToBeDownloaded, directory);
                break;
            }
            default: {
                sLog.error("Unsupported installAction: " + installAction);
            }
        }
        return directory;
    }

    public static String updateCache(IFileRetriever fileRetriever, CWIDescriptor cwiDescriptor, String cwiDirPath, Component parent) throws Exception {
        String msg = null;
        int installAction = 0;
        File oldCompatDir = null;
        File compatibilityDir = CacheUtilities.getCompatibilityFile(cwiDescriptor, cwiDirPath);
        Version compatVersion = new Version(compatibilityDir.getName());
        if (!compatibilityDir.exists()) {
            File parentDir = compatibilityDir.getParentFile();
            File[] files = parentDir.listFiles();
            int highestMaintVer = -1;
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                try {
                    int maintVersion;
                    IVersion version = VersionFactory.instance().getVersion(files[i].getName());
                    if (version.getFeatureVersion() != compatVersion.getFeatureVersion() || (maintVersion = version.getMaintenanceVersion()) <= highestMaintVer) continue;
                    highestMaintVer = maintVersion;
                    oldCompatDir = files[i];
                    continue;
                }
                catch (IncompatibleVersionStringException ex) {
                    sLog.debug("IncompatibleVersionStringException - Skipping check on compatibility directory: " + files[i].getName());
                    continue;
                }
                catch (IncompatibleVersionListException ex) {
                    sLog.debug("IncompatibleVersionListException - Skipping check on compatibility directory: " + files[i].getName());
                }
            }
            if (highestMaintVer == -1) {
                installAction = 1;
            } else if (compatVersion.getMaintenanceVersion() > highestMaintVer) {
                installAction = 2;
            } else if (compatVersion.getMaintenanceVersion() < highestMaintVer) {
                installAction = 3;
            } else {
                sLog.error("Unexpected condition for: " + ((Object)compatVersion).toString());
            }
        } else if (compatibilityDir.isDirectory()) {
            installAction = 0;
        }
        sLog.debug("updateCache::installAction = " + installAction);
        CompatibilityDirectory directory = CacheUtilities.downLoadRequiredFiles(installAction, compatibilityDir, oldCompatDir, fileRetriever, cwiDescriptor, cwiDirPath, parent);
        switch (installAction) {
            case 3: {
                msg = SHORTCUT_MSG;
                break;
            }
            case 0: {
                CacheUtilities.extractDefinitions(cwiDescriptor, directory, parent);
                msg = CacheUtilities.updateLaunchFile(installAction, compatVersion, cwiDescriptor, cwiDirPath, directory, parent);
                CacheUtilities.createUninstallFile(installAction, compatVersion, cwiDescriptor, directory, cwiDirPath);
                break;
            }
            case 1: 
            case 2: {
                CacheUtilities.extractDefinitions(cwiDescriptor, directory, parent);
                CacheUtilities.extractCWIIcon(cwiDescriptor, directory);
                msg = CacheUtilities.updateLaunchFile(installAction, compatVersion, cwiDescriptor, cwiDirPath, directory, parent);
                CacheUtilities.createUninstallFile(installAction, compatVersion, cwiDescriptor, directory, cwiDirPath);
                directory.generateInstallFile();
                break;
            }
            default: {
                sLog.error("Unsupported installAction: " + installAction);
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractCWIIcon(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory) {
        String compatibilityDir = compatibilityDirectory.getAbsolutePath();
        String cacheIconFileName = compatibilityDir + File.separator + "cwi.ico";
        BufferedReader reader = null;
        String iconFileName = "images/cwi.ico";
        try {
            String[] installLocations = compatibilityDirectory.getAbsolutePath("installer.jar");
            JarFile installJar = new JarFile(installLocations[0]);
            InputStream iconFile = installJar.getInputStream(installJar.getEntry(iconFileName));
            reader = new BufferedReader(new InputStreamReader(iconFile));
            sLog.debug("Reading contents of " + iconFile + " from the Jar " + " at location " + installLocations[0] + " for writing " + "file " + cacheIconFileName);
            String iconContents = InstallerUtil.readFile(reader);
            InstallerUtil.createFile(compatibilityDirectory, compatibilityDir, "cwi.ico", iconContents, compatibilityDir);
        }
        catch (IOException ex) {
            sLog.error("Unexpected IOException while extracting out the CWI Icon File " + cacheIconFileName, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    sLog.warn("IOException occurred while closing the input stream attached to file " + iconFileName, ex);
                }
            }
        }
    }

    private static int getFileNameToWrite(int actionCode, File dir, File file, StringBuffer fileNameToWrite, Component parent) {
        String fileName = file.getName();
        int maxNumber = CacheUtilities.getMaximumFilenameNumber(dir, fileName);
        String newFileName = fileName + "." + (maxNumber + 1);
        switch (actionCode) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                String DISPLAY = "Definition file is already present: \n[" + file.getPath() + "]\n\n" + "You are installing a version of CWI that already exists on your " + "computer.  If you have made modifications\nto this file then you " + "may choose not to overwrite it with the version from the " + "installer.\n\n" + "Do you wish to overwrite this file?\n\n" + "Selecting 'Overwrite' will overwrite the existing file.\n" + "Selecting 'Backup' will write the file being installed as " + newFileName + " in the same directory.\n" + "Selecting 'Skip' will do nothing.";
                actionCode = FileInstallDialog.showDialog(null, parent, DISPLAY);
            }
        }
        switch (actionCode) {
            case -1: {
                sLog.error("Returned UNKNOWN action code for: " + file.getPath());
                break;
            }
            case 0: 
            case 3: {
                fileNameToWrite.append(fileName);
                sLog.debug("Overwriting file: " + fileName);
                break;
            }
            case 2: 
            case 5: {
                sLog.debug("Skipping file: " + fileName);
                break;
            }
            case 1: 
            case 4: {
                fileNameToWrite.append(newFileName);
                sLog.debug("Backing up file: " + newFileName);
                break;
            }
            default: {
                sLog.error("Unsupported action code: " + actionCode + " for: " + file.getPath());
            }
        }
        return actionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractDefinitions(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory, Component parent) {
        String NOT_USER_EDITABLE_MACRO = "<$$not-user-editable$$>";
        BufferedReader manifestReader = null;
        BufferedReader reader = null;
        int actionCode = -1;
        try {
            String compatibilityDir = compatibilityDirectory.getAbsolutePath();
            String[] datafileLocations = compatibilityDirectory.getAbsolutePath("cwi_definitions.jar");
            HashSet<String> allFilesExtracted = new HashSet<String>();
            for (int i = 0; i < datafileLocations.length; ++i) {
                JarFile datafileJar = new JarFile(datafileLocations[i]);
                InputStream manifestDatafile = datafileJar.getInputStream(datafileJar.getEntry("manifestdatafile"));
                manifestReader = new BufferedReader(new InputStreamReader(manifestDatafile));
                HashMap fileDirMap = InstallerUtil.readReaderAsMap(manifestReader);
                Set fileKeys = fileDirMap.keySet();
                for (String fileName : fileKeys) {
                    if (allFilesExtracted.contains(fileName)) continue;
                    allFilesExtracted.add(fileName);
                    String macroDirPath = (String)fileDirMap.get(fileName);
                    macroDirPath.trim();
                    boolean isUserEditable = true;
                    if (macroDirPath.startsWith("<$$not-user-editable$$>")) {
                        isUserEditable = false;
                        macroDirPath = macroDirPath.substring("<$$not-user-editable$$>".length()).trim();
                    }
                    String trueDirPath = CacheUtilities.expandMacroPath(macroDirPath, cwiDescriptor, compatibilityDir);
                    String filePath = trueDirPath + File.separator + fileName;
                    InputStream datafile = datafileJar.getInputStream(datafileJar.getEntry(fileName));
                    reader = new BufferedReader(new InputStreamReader(datafile));
                    sLog.debug("Reading contents of " + fileName + " from the Jar " + " at location " + datafileLocations[0]);
                    String fileContents = InstallerUtil.readFile(reader);
                    sLog.debug("Contents of " + fileName + " are " + fileContents);
                    File file = new File(filePath);
                    if (file.exists() && file.isFile()) {
                        String fileNameToWrite = null;
                        if (!isUserEditable) {
                            fileNameToWrite = fileName;
                        } else {
                            File dir = new File(trueDirPath);
                            StringBuffer fileNameBuf = new StringBuffer();
                            actionCode = CacheUtilities.getFileNameToWrite(actionCode, dir, file, fileNameBuf, parent);
                            fileNameToWrite = fileNameBuf.toString();
                        }
                        if (fileNameToWrite != null && !fileNameToWrite.equals("")) {
                            InstallerUtil.createFile(compatibilityDirectory, trueDirPath, fileNameToWrite, fileContents, compatibilityDir);
                        }
                    } else {
                        if (file.exists() && file.isDirectory()) {
                            file.delete();
                        }
                        InstallerUtil.createFile(compatibilityDirectory, trueDirPath, fileName, fileContents, compatibilityDir);
                    }
                    if (reader == null) continue;
                    try {
                        reader.close();
                        reader = null;
                    }
                    catch (IOException ex) {
                        sLog.warn("IOException occurred while closing the input stream attached to file " + fileName, ex);
                    }
                }
                if (manifestReader == null) continue;
                try {
                    manifestReader.close();
                    manifestReader = null;
                    continue;
                }
                catch (IOException ex) {
                    sLog.warn("IOException occurred while closing the input stream attached to file manifestdatafile", ex);
                }
            }
        }
        catch (IOException ex) {
            sLog.warn("Unexpected IOException occurred while extracting out definition files.", ex);
        }
        finally {
            if (manifestReader != null) {
                try {
                    manifestReader.close();
                }
                catch (IOException ex) {
                    sLog.warn("IOException occurred while closing the input stream attached to file manifestdatafile", ex);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException ex) {
                    sLog.warn("IOException occurred while closing the input stream attached to file ", ex);
                }
            }
        }
    }

    private static String expandMacroPath(String macroDirName, CWIDescriptor cwiDescriptor, String compatibilityDir) {
        String COMPATIBILITY_MACRO = "<$$compatibility$$>";
        String NE_CRS_MACRO = "<$$ne_crs$$>";
        String NE_C12K_MACRO = "<$$ne_c12k$$>";
        StringBuffer dirName = new StringBuffer(macroDirName);
        for (int i = 0; i < dirName.length(); ++i) {
            if (dirName.charAt(i) != '/') continue;
            dirName.setCharAt(i, File.separatorChar);
        }
        if (macroDirName.startsWith("<$$compatibility$$>")) {
            dirName.replace(0, "<$$compatibility$$>".length(), compatibilityDir);
        } else if (macroDirName.startsWith("<$$ne_crs$$>") || macroDirName.startsWith("<$$ne_c12k$$>")) {
            String neType = null;
            int macroSize = 0;
            if (macroDirName.startsWith("<$$ne_crs$$>")) {
                macroSize = "<$$ne_crs$$>".length();
                neType = "crs";
            } else {
                macroSize = "<$$ne_c12k$$>".length();
                neType = "c12k";
            }
            CWIFile cwiFile = cwiDescriptor.getCWIFile(CWIFile.getContextName("cwi_ne.jar", neType));
            String filePath = CacheUtilities.getCacheFilePath(compatibilityDir, cwiFile.getFileName(), cwiFile.getVersion());
            dirName.replace(0, macroSize, InstallerUtil.getParentDirName(filePath));
        }
        return dirName.toString();
    }

    private static int getMaximumFilenameNumber(File dir, String fileName) {
        int maxNumber = 0;
        String[] fileNames = dir.list();
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                int index = fileNames[i].indexOf(fileName);
                if (index == -1 || fileNames[i].equals(fileName)) continue;
                int lastIndex = fileNames[i].lastIndexOf(".");
                String numberStr = fileNames[i].substring(lastIndex + 1);
                int number = 0;
                try {
                    number = Integer.valueOf(numberStr);
                }
                catch (NumberFormatException ex) {
                    sLog.warn("Unexpected NumberFormatException while parsing filename " + fileNames[i], ex);
                }
                if (maxNumber >= number) continue;
                maxNumber = number;
            }
        }
        return maxNumber;
    }

    private static String getExtension(String fileName) {
        String FILE_DOT = ".";
        String extension = fileName;
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            extension = fileName.substring(index + ".".length());
        }
        return extension;
    }

    private static final String getFileNameWithoutExtension(String fileName) {
        String fileNameWithoutExtension = fileName;
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            fileNameWithoutExtension = fileName.substring(0, index);
        }
        return fileNameWithoutExtension;
    }

    private static CompatibilityDirectory setupCompatibilityDirectory(CWIDescriptor cwiDescriptor, File compatibilityDir, String cwiDirPath) {
        CompatibilityDirectory compatibilityDirectory = new CompatibilityDirectory(compatibilityDir);
        CacheUtilities.createNEBackwardCompatibleFiles(cwiDescriptor, compatibilityDirectory, cwiDirPath);
        return compatibilityDirectory;
    }

    private static void createUninstallFile(int installAction, IVersion compatVersion, CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory, String cwiDirPath) {
        boolean windows = InstallerUtil.isWindows();
        String uninstallFilePrefix = CacheUtilities.getLaunchFileNameWithoutExtension(cwiDescriptor);
        String uninstallFileName = uninstallFilePrefix + UNINSTALL_POSTFIX;
        uninstallFileName = !windows ? uninstallFileName + EXTENSION_SH : uninstallFileName + EXTENSION_CMD;
        String uninstallDirectoryPath = cwiDirPath + File.separator + "uninstall";
        File uninstallFile = new File(uninstallDirectoryPath + File.separator + uninstallFileName);
        if (uninstallFile.exists()) {
            uninstallFile.delete();
        }
        StringBuffer uninstallContents = new StringBuffer();
        if (windows) {
            uninstallContents.append("@echo off\n");
        }
        uninstallContents.append(CacheUtilities.generateScriptContents(false, compatibilityDirectory)).append(CLASSPATH);
        String installerPath = compatibilityDirectory.getAbsolutePath("installer.jar")[0];
        if (windows) {
            uninstallContents.append("\"").append(installerPath).append("\"");
        } else {
            uninstallContents.append(installerPath);
        }
        uninstallContents.append(UNINSTALL);
        String compatibility = CacheUtilities.getCompatibility(cwiDescriptor);
        String compatibilityDir = cwiDirPath + File.separator + "versions" + File.separator + compatibility;
        String installFilePath = compatibilityDir + File.separator + "install_file_log";
        if (windows) {
            uninstallContents.append("\"").append(installFilePath).append("\"\n").append("if %errorlevel% EQU 0 ( \n").append("echo ****** DELETING ").append(compatibilityDir).append(" ******\n").append("rmdir  /s/q \"").append(compatibilityDir).append("\"\n").append("if %errorlevel% EQU 0 (\necho ****** ").append(" SUCCESSFULLY UNINSTALLED ").append(compatibility).append(" ******\n").append("del \"").append(uninstallFile.getPath()).append("\"\n) else echo ****** UNABLE TO UNINSTALL ").append(compatibility).append(" COMPATIBILITY : Directory ").append(compatibilityDir).append(" not removed ******\n").append(") else echo ****** UNABLE TO ").append(" UNINSTALL ").append(compatibility).append(" COMPATIBILITY : CWI component in directory ").append(compatibilityDir).append(" not removed ******\n");
        } else {
            uninstallContents.append(installFilePath).append("\nif [ $? -eq 0 ]; then \n").append("\techo ****** DELETING ").append(compatibilityDir).append(" ******\n").append("\trm -rf ").append(compatibilityDir).append("\n\tif [ $? -eq 0 ]; then\n\t\techo ****** ").append(" SUCCESSFULLY UNINSTALLED ").append(compatibility).append(" ******\n").append("\t\trm ").append(uninstallFile.getPath()).append("\n\telse\n\t\techo ****** UNABLE TO UNINSTALL ").append(compatibility).append(" COMPATIBILITY : Directory ").append(compatibilityDir).append(" not removed ******\n\tfi\n").append("else\n\techo ****** UNABLE TO ").append(" UNINSTALL ").append(compatibility).append(" COMPATIBILITY : CWI component in directory ").append(compatibilityDir).append(" not removed ******\nfi");
        }
        sLog.debug("Contents of uninstall file : " + uninstallContents.toString());
        if (installAction == 2) {
            CacheUtilities.deleteCompatExecFiles(new File(uninstallDirectoryPath), compatVersion, "_", UNINSTALL_POSTFIX);
        }
        InstallerUtil.createFile(null, uninstallDirectoryPath, uninstallFileName, uninstallContents.toString());
    }

    public static String getCompatibility(CWIDescriptor cwiDescriptor) {
        CWIFile ifFile = cwiDescriptor.getCWIFile("cwi_if.jar");
        return (String)ifFile.getProperty("compatibility");
    }

    public static File getCompatibilityFile(CWIDescriptor cwiDescriptor, String cwiDirPath) {
        String compatibility = CacheUtilities.getCompatibility(cwiDescriptor);
        return new File(cwiDirPath + File.separator + "versions" + File.separator + compatibility);
    }

    private static String createDesktopFile(int installAction, IVersion compatVersion, CompatibilityDirectory compatibilityDirectory, String dirName, String fileNameWithoutExtension, String contents, Component parent) {
        String shortcutMsg = null;
        String desktopDirName = null;
        sLog.debug("Contents of desktop file : " + contents);
        String fileName = null;
        if (InstallerUtil.isWindows()) {
            desktopDirName = dirName;
            fileName = fileNameWithoutExtension + EXTENSION_URL;
            String cwiIconFilePath = compatibilityDirectory.getAbsolutePath() + File.separator + "cwi.ico";
            StringBuffer desktopContents = new StringBuffer();
            desktopContents.append("[InternetShortcut]\n").append("URL=\"").append(contents).append("\"\nIconIndex=0\n").append("IconFile=\"").append(cwiIconFilePath).append("\"\n");
            InstallerUtil.createFile(compatibilityDirectory, dirName, fileName, desktopContents.toString());
            shortcutMsg = SHORTCUT_MSG;
        } else if (InstallerUtil.isMacOS()) {
            String macOSDir;
            fileName = fileNameWithoutExtension;
            String desktopFilepath = dirName + File.separator + fileName + ".app";
            desktopDirName = macOSDir = desktopFilepath + File.separator + "Contents" + File.separator + "MacOS";
            InstallerUtil.createDirectoryIfNecessary(macOSDir);
            InstallerUtil.createFile(compatibilityDirectory, macOSDir, fileName, "#!/bin/sh\n" + contents, desktopFilepath);
            try {
                String command = "chmod u+x " + macOSDir + File.separator + fileName;
                Runtime.getRuntime().exec(command);
            }
            catch (Exception ex) {
                sLog.error("Error while changing the permissions for the shortcut.", ex);
            }
            shortcutMsg = SHORTCUT_MSG;
        } else {
            desktopDirName = dirName;
            fileName = fileNameWithoutExtension;
            File desktopDirectory = new File(dirName);
            if (!desktopDirectory.exists() || !desktopDirectory.isDirectory()) {
                dirName = System.getProperty("user.home");
                sLog.debug("Desktop directory not found.\n Creating CWI shortcut in user's home directory :" + dirName);
            } else {
                sLog.debug("Creating CWI shortcut in user's Desktop directory :" + dirName);
            }
            shortcutMsg = "Script to launch CWI has been installed as :\n" + dirName + File.separator + fileName;
            sLog.debug("Creating shortcut in the directory: " + dirName);
            InstallerUtil.createFile(compatibilityDirectory, dirName, fileName, "#!/bin/sh\n" + contents);
            try {
                String command = "chmod u+x " + dirName + File.separator + fileName;
                Runtime.getRuntime().exec(command);
            }
            catch (Exception ex) {
                sLog.error("Error while changing the permissions for the shortcut.", ex);
            }
        }
        if (installAction == 2) {
            CacheUtilities.deleteCompatExecFiles(new File(desktopDirName), compatVersion, "_", EXTENSION_URL);
        }
        return shortcutMsg;
    }

    private static String getLaunchFileNameWithoutExtension(CWIDescriptor cwiDescriptor) {
        String featureReleaseVersion = (String)cwiDescriptor.getProperty("featurerelease");
        String compatibility = CacheUtilities.getCompatibility(cwiDescriptor);
        return "CWI_" + featureReleaseVersion + "_" + compatibility;
    }

    private static final void deleteCompatExecFiles(File parentDir, IVersion compatVersion, String preFixToCompat, String postFixToCompat) {
        File[] files = parentDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int startIndex;
            if (files[i].isDirectory()) continue;
            String fileName = files[i].getName();
            sLog.debug("Checking file for possible deletion: " + fileName + ", against version: " + ((Object)compatVersion).toString());
            int endIndex = fileName.lastIndexOf(postFixToCompat);
            if (endIndex == -1 || (startIndex = fileName.lastIndexOf(preFixToCompat, endIndex - 1)) == -1) continue;
            String compat = fileName.substring(startIndex + preFixToCompat.length(), endIndex);
            try {
                Version existingVersion;
                if (!VersionFactory.instance().isVersionStringFormat(compat) || (existingVersion = new Version(compat)).getFeatureVersion() != compatVersion.getFeatureVersion() || existingVersion.getMaintenanceVersion() == compatVersion.getMaintenanceVersion()) continue;
                sLog.debug("Deleting file which is no longer required: " + fileName);
                files[i].delete();
                continue;
            }
            catch (IncompatibleVersionStringException ex) {
                sLog.debug("Encountered exception on attempted deletion of file: " + fileName + ", ignoring this exception: " + ex.getMessage());
            }
        }
    }

    private static String updateLaunchFile(int installAction, IVersion compatVersion, CWIDescriptor cwiDescriptor, String cwiDirPath, CompatibilityDirectory compatibilityDirectory, Component parent) throws Exception {
        String msg = null;
        String launchFilenameWithoutExtension = CacheUtilities.getLaunchFileNameWithoutExtension(cwiDescriptor);
        String launchFilename = launchFilenameWithoutExtension + EXTENSION_CMD;
        String binDirectoryPath = cwiDirPath + File.separator + "bin";
        File launchFile = new File(binDirectoryPath + File.separator + launchFilename);
        if (launchFile.exists()) {
            launchFile.delete();
        }
        if (installAction == 2) {
            CacheUtilities.deleteCompatExecFiles(launchFile.getParentFile(), compatVersion, "_", EXTENSION_CMD);
        }
        String contents = CacheUtilities.generateLaunchContents(cwiDescriptor, compatibilityDirectory);
        try {
            InstallerUtil.createFile(compatibilityDirectory, binDirectoryPath, launchFilename, contents);
            String desktopDir = System.getProperty("user.home") + File.separator + "Desktop";
            msg = CacheUtilities.createDesktopFile(installAction, compatVersion, compatibilityDirectory, desktopDir, launchFilenameWithoutExtension, launchFile.getPath(), parent);
        }
        catch (Exception e) {
            sLog.error("Exception when generating CWI launch file and shortcut  file: ", e);
            throw e;
        }
        return msg;
    }

    private static String generateLaunchContents(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory) {
        String classPath;
        String libraryPath;
        StringBuffer cmd = new StringBuffer();
        boolean isWindows = InstallerUtil.isWindows();
        if (isWindows) {
            cmd.append("@echo off\n");
        }
        CWIFile commJar = null;
        CWIFile[] cwiFiles = cwiDescriptor.getAllCWIFiles();
        for (int ii = 0; ii < cwiFiles.length; ++ii) {
            String localName = cwiFiles[ii].getFileName();
            if (!localName.equals("comm.jar")) continue;
            commJar = cwiFiles[ii];
            break;
        }
        if (commJar != null) {
            String commJarPath = compatibilityDirectory.getAbsolutePath(commJar.getFileName())[0];
            commJarPath = commJarPath.substring(0, commJarPath.lastIndexOf(File.separator));
            cmd.append("cd ");
            if (isWindows) {
                cmd.append("/d ");
            }
            cmd.append(commJarPath + "\n");
        }
        cmd.append(CacheUtilities.generateScriptContents(true, compatibilityDirectory));
        String bootClassPath = CacheUtilities.getBootClassPath(cwiDescriptor, compatibilityDirectory);
        if (bootClassPath != null) {
            cmd.append(bootClassPath);
            cmd.append(" ");
        }
        if ((libraryPath = CacheUtilities.getLibraryPath(cwiDescriptor, compatibilityDirectory)) != null) {
            cmd.append(libraryPath);
            cmd.append(" ");
        }
        if ((classPath = CacheUtilities.getClassPath(cwiDescriptor, compatibilityDirectory)) != null) {
            cmd.append(classPath);
            cmd.append(" ");
        }
        cmd.append(" com.cisco.hfr.cwi.installer.Bootstrap ");
        cmd.append(CacheUtilities.getBuildString(cwiDescriptor, compatibilityDirectory));
        if (!isWindows) {
            cmd.append(" 2> /dev/null ");
        }
        String os = System.getProperty("os.name");
        sLog.debug("OS Name = " + os);
        sLog.debug("Generated launch file contents " + cmd.toString());
        return cmd.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateScriptContents(boolean fork, CompatibilityDirectory compatibilityDirectory) {
        StringBuffer cmd = new StringBuffer();
        boolean windows = InstallerUtil.isWindows();
        String javaHome = System.getProperty("java.home");
        String javaVersion = System.getProperty("java.version");
        Matcher m = javaVersionPttn.matcher(javaVersion);
        m.find();
        String javaMajor = m.group(1);
        String javaMinor = m.group(2);
        sLog.info("Java Major Version " + javaMajor);
        sLog.info("Java Minor Version " + javaMinor);
        String javaVerMajorMinorOnly = javaMajor + "." + javaMinor;
        String javaVerMajorMinorOnlyUnderscore = javaMajor + "_" + javaMinor;
        if (windows) {
            cmd.append("set JAVA_HOME=" + javaHome + "\n");
            cmd.append("set JAVA_VER=" + javaVerMajorMinorOnly + "\n");
            cmd.append("set JAVA_VER_STR=" + javaVerMajorMinorOnlyUnderscore + "\n");
            String javaCmdName = null;
            javaCmdName = fork ? "javaw" : "java";
            cmd.append("set JAVA_CMD_NAME=" + javaCmdName + "\n");
            cmd.append("set JAVA_EXEC=" + javaCmdName + "\n");
        } else {
            cmd.append("#!/bin/sh\n");
            cmd.append("JAVA_HOME=" + javaHome + "\n");
            cmd.append("JAVA_VER=" + javaVerMajorMinorOnly + "\n");
            cmd.append("JAVA_VER_STR=" + javaVerMajorMinorOnlyUnderscore + "\n");
            cmd.append("JAVA_CMD_NAME=java\n");
            cmd.append("JAVA_EXEC=java\n");
        }
        BufferedReader bufReader = null;
        String scriptTemplateFileName = null;
        try {
            String str;
            scriptTemplateFileName = windows ? "LauncherScriptTemplate_Windows" : "LauncherScriptTemplate_UnixLike";
            String compatibilityDir = compatibilityDirectory.getAbsolutePath();
            scriptTemplateFileName = "templates/" + scriptTemplateFileName;
            String[] installLocations = compatibilityDirectory.getAbsolutePath("installer.jar");
            JarFile installJar = new JarFile(installLocations[0]);
            InputStream scriptTemplateFile = installJar.getInputStream(installJar.getEntry(scriptTemplateFileName));
            sLog.error("Reading the script template file: " + scriptTemplateFileName);
            bufReader = new BufferedReader(new InputStreamReader(scriptTemplateFile));
            while ((str = bufReader.readLine()) != null) {
                cmd.append(str + "\n");
            }
        }
        catch (Exception e) {
            sLog.error("Error while reading the script template file " + scriptTemplateFileName, e);
        }
        finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException ex) {
                    sLog.warn("IOException occurred while closing the input stream attached to file " + scriptTemplateFileName, ex);
                }
            }
        }
        cmd.append("\n");
        if (windows) {
            if (fork) {
                cmd.append("start \"\" ");
            }
            cmd.append("%JAVA_EXEC%");
        } else {
            cmd.append("$JAVA_EXEC");
        }
        cmd.append(" ");
        return cmd.toString();
    }

    private static String getBuildString(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory) {
        CWIFile desktop = cwiDescriptor.getCWIFile("cwi_desktop.jar");
        String desktopVersion = ((Object)desktop.getVersion()).toString();
        return (String)cwiDescriptor.getProperty("featurerelease") + "." + compatibilityDirectory.getCompatibility() + "." + desktopVersion;
    }

    private static String getCWIBootClassPath(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory) {
        StringBuffer cwiBootClassPath = new StringBuffer();
        CWIFile[] files = cwiDescriptor.getAllCWIFiles();
        for (int i = 0; i < files.length; ++i) {
            String[] paths;
            String filename = files[i].getFileName();
            Boolean isBootClasspath = (Boolean)files[i].getProperty("bootclasspath");
            if (isBootClasspath == null || !isBootClasspath.booleanValue() || (paths = compatibilityDirectory.getAbsolutePath(files[i].getFileName())) == null) continue;
            for (int j = 0; j < paths.length; ++j) {
                cwiBootClassPath.append(paths[j]).append(File.pathSeparator);
            }
        }
        sLog.debug("cwibootclasspath: " + cwiBootClassPath.toString());
        return cwiBootClassPath.toString();
    }

    private static String getLibraryPath(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory) {
        HashSet<String> paths = new HashSet<String>();
        StringBuffer libraryPath = new StringBuffer();
        CWIFile[] files = cwiDescriptor.getAllCWIFiles();
        for (int i = 0; i < files.length; ++i) {
            String[] fullPaths;
            String filename = files[i].getFileName();
            Boolean isLibraryPath = (Boolean)files[i].getProperty("librarypath");
            if (isLibraryPath == null || !isLibraryPath.booleanValue() || (fullPaths = compatibilityDirectory.getAbsolutePath(files[i].getFileName())) == null) continue;
            for (int j = 0; j < fullPaths.length; ++j) {
                String pathWithoutFilename = fullPaths[j].substring(0, fullPaths[j].lastIndexOf(File.separator));
                paths.add(pathWithoutFilename);
            }
        }
        if (paths.size() > 0) {
            boolean windows = InstallerUtil.isWindows();
            libraryPath.append(LIBRARYPATH);
            if (windows) {
                libraryPath.append("\"");
            }
            Iterator iter = paths.iterator();
            while (iter.hasNext()) {
                libraryPath.append((String)iter.next()).append(File.pathSeparator);
            }
            if (windows) {
                libraryPath.append("\"");
            }
        }
        String path = libraryPath.toString();
        sLog.debug("library path:" + path);
        return path;
    }

    private static String getBootClassPath(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory) {
        StringBuffer bootClassPath = new StringBuffer();
        sLog.debug("Entering getBootClassPath()");
        boolean windows = InstallerUtil.isWindows();
        String javaHome = System.getProperty("java.home");
        sLog.debug("JAVA Home directory is : " + javaHome);
        String jsseJarName = javaHome + File.separator + "lib" + File.separator + "jsse.jar";
        String rtJarName = javaHome + File.separator + "lib" + File.separator + "rt.jar";
        String cwiBootClassPath = CacheUtilities.getCWIBootClassPath(cwiDescriptor, compatibilityDirectory);
        if (windows) {
            bootClassPath.append("\"");
            bootClassPath.append(BOOTCLASSPATH + jsseJarName).append(File.pathSeparator + rtJarName);
            if (cwiBootClassPath.length() > 0) {
                bootClassPath.append(File.pathSeparator + cwiBootClassPath);
            }
            bootClassPath.append("\"");
        } else if (InstallerUtil.isMacOS()) {
            if (cwiBootClassPath.length() > 0) {
                bootClassPath.append(BOOTCLASSPATH + cwiBootClassPath);
            }
        } else {
            bootClassPath.append(BOOTCLASSPATH + jsseJarName).append(File.pathSeparator + rtJarName);
            if (cwiBootClassPath.length() > 0) {
                bootClassPath.append(File.pathSeparator + cwiBootClassPath);
            }
        }
        String maxHeapSize = (String)cwiDescriptor.getProperty("max-heap-size");
        bootClassPath.append(HEAPSIZE_OPTION).append(maxHeapSize);
        String path = bootClassPath.toString();
        sLog.debug("bootclasspath is: " + path);
        return path;
    }

    private static String getClassPath(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory) {
        StringBuffer classPath = new StringBuffer();
        CWIFile[] files = cwiDescriptor.getAllCWIFiles();
        for (int i = 0; i < files.length; ++i) {
            Boolean isAddToClassPath = (Boolean)files[i].getProperty("classpath");
            if (isAddToClassPath == null || !isAddToClassPath.booleanValue()) continue;
            String filename = files[i].getFileName();
            if (filename.equals("comm.jar")) {
                classPath.append("." + File.separator + filename);
                classPath.append(File.pathSeparator);
                continue;
            }
            String[] paths = compatibilityDirectory.getAbsolutePath(filename);
            for (int j = 0; j < paths.length; ++j) {
                classPath.append(paths[j]);
                classPath.append(File.pathSeparator);
            }
        }
        StringBuffer completePathOption = new StringBuffer();
        if (classPath.length() > 0) {
            completePathOption.append(CLASSPATH);
            boolean windows = InstallerUtil.isWindows();
            if (windows) {
                completePathOption.append("\"").append(classPath.toString()).append("\"");
            } else {
                completePathOption.append(classPath.toString());
            }
        }
        String path = completePathOption.toString();
        sLog.debug("classpath : " + path);
        return path;
    }

    private static void createNEBackwardCompatibleFiles(CWIDescriptor cwiDescriptor, CompatibilityDirectory compatibilityDirectory, String cwiDir) {
        CWIFile[] neCWIFiles = CacheUtilities.getNEFiles(cwiDescriptor);
        if (neCWIFiles != null) {
            for (int i = 0; i < neCWIFiles.length; ++i) {
                IVersionList backwardCompatible = neCWIFiles[i].getVersion().getBackwardCompatibleVersionList();
                if (backwardCompatible == null) continue;
                String backwardCompatibleString = backwardCompatible.toString();
                String compatibilityDir = cwiDir + File.separator + "versions" + File.separator + CacheUtilities.getCompatibility(cwiDescriptor);
                String fileDirectory = compatibilityDir + File.separator + ((Object)neCWIFiles[i].getVersion()).toString();
                File directory = new File(fileDirectory);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                String backwardCompatiblePath = fileDirectory + File.separator + "backward_compatible";
                try {
                    Preferences pref = Preferences.getPreferenceInstance(backwardCompatiblePath);
                    pref.setProperty("ne", "backward_compatible_version_list", backwardCompatibleString);
                    pref.store();
                    compatibilityDirectory.addToInstallFileLog(backwardCompatiblePath, compatibilityDir);
                    continue;
                }
                catch (IOException ex) {
                    sLog.warn("Unexpected IOException when creating backward compatible file " + backwardCompatiblePath, ex);
                }
            }
        }
    }

    private static CWIFile[] getNEFiles(CWIDescriptor cwiDescriptor) {
        CWIFile[] files = cwiDescriptor.getAllCWIFiles();
        ArrayList<CWIFile> neFiles = new ArrayList<CWIFile>();
        CWIFile[] neCWIFiles = null;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getFileName().equals("cwi_ne.jar")) continue;
            neFiles.add(files[i]);
        }
        if (neFiles.size() > 0) {
            neCWIFiles = neFiles.toArray(new CWIFile[neFiles.size()]);
        }
        return neCWIFiles;
    }

    public static String getCacheFilePath(String relativePath, String filename, IVersion version) {
        StringBuffer cacheFileName = new StringBuffer();
        if (version != null) {
            File versionDirectory = new File(relativePath + File.separator + version);
            if (!versionDirectory.exists()) {
                versionDirectory.mkdirs();
            }
            cacheFileName.append(versionDirectory.getPath());
        } else {
            cacheFileName.append(relativePath);
        }
        cacheFileName.append(File.separator).append(filename);
        sLog.info("Cache file name : " + cacheFileName);
        return cacheFileName.toString();
    }
}

