/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.ICopy;
import com.cisco.hfr.cwi.installer.IProgressObserver;
import java.io.IOException;
import java.util.Observable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedFile
extends Observable
implements IProgressObserver {
    private Log mLog = LogFactory.getLog(CachedFile.class);
    private String mFrom;
    private String mTo;
    private long mCurrent;
    private long mMaximum;
    private ICopy mCopy;

    public CachedFile(String from, String to, long fileSize, ICopy copyFile) {
        this.mFrom = from;
        this.mTo = to;
        this.mCurrent = 0L;
        this.mMaximum = fileSize;
        this.mCopy = copyFile;
    }

    public void init() throws IOException {
        this.mCopy.copyFile(this.mFrom, this.mTo, this);
    }

    public long getCurrent() {
        return this.mCurrent;
    }

    public void setCurrent(long current) {
        this.mCurrent = current;
    }

    public long getMaximum() {
        return this.mMaximum;
    }

    public void progressUpdate(int delta) {
        this.mCurrent += (long)delta;
        this.setChanged();
        this.notifyObservers(this);
    }
}

