/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.IFileVersion;
import com.cisco.hfr.cwi.installer.INEVersion;
import com.cisco.hfr.cwi.installer.IVersion;
import com.cisco.hfr.cwi.installer.IncompatibleCWIFileVersionException;
import com.cisco.hfr.cwi.installer.IncompatibleVersionListException;
import com.cisco.hfr.cwi.installer.IncompatibleVersionStringException;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import com.cisco.hfr.cwi.installer.Preferences;
import com.cisco.hfr.cwi.installer.VersionFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompatibilityDirectory {
    private Log mLog = LogFactory.getLog(CompatibilityDirectory.class);
    private static final String[] sPlatforms = new String[]{"crs", "c12k", "gsrios", "800ios"};
    private File mFile = null;
    private HashMap mFileVersionMap = null;
    private HashMap mInstallFileData = null;

    public CompatibilityDirectory(File dir) {
        this.mFile = dir;
        this.mFileVersionMap = new HashMap();
        this.mInstallFileData = new HashMap();
        this.initialize();
        this.print();
    }

    private void initialize() {
        this.initializeFileVersionInfo();
        this.readInstallFileLog();
    }

    private void initializeFileVersionInfo() {
        File[] files = this.mFile.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory()) continue;
                String filename = files[i].getName();
                if (this.isPlatformString(filename)) {
                    File[] neFiles = files[i].listFiles();
                    if (neFiles == null) continue;
                    for (int k = 0; k < neFiles.length; ++k) {
                        String neDirName = neFiles[k].getName();
                        try {
                            if (!neFiles[k].isDirectory() || !VersionFactory.instance().isVersionStringFormat(neFiles[k].getName())) continue;
                            this.addFileVersionInfo(neFiles[k], filename);
                            continue;
                        }
                        catch (IncompatibleVersionStringException ex) {
                            this.mLog.warn("Directory under platform " + filename + " has name " + neDirName + " which is " + "not in Version format", ex);
                        }
                    }
                    continue;
                }
                try {
                    if (!VersionFactory.instance().isVersionStringFormat(filename)) continue;
                    this.addFileVersionInfo(files[i]);
                    continue;
                }
                catch (IncompatibleVersionStringException ex) {
                    this.mLog.warn("Directory " + filename + " has name which is " + "not in Version format", ex);
                }
            }
        }
    }

    private void readInstallFileLog() {
        String compatibilityPath = this.getAbsolutePath();
        String installFileLogName = compatibilityPath + File.separator + "install_file_log";
        if (new File(installFileLogName).exists()) {
            try {
                this.mInstallFileData = InstallerUtil.readFileAsMap(installFileLogName);
            }
            catch (IOException ex) {
                this.mLog.warn("Unexpected IOException while reading file " + installFileLogName, ex);
            }
        }
    }

    private boolean isPlatformString(String platform) {
        boolean isPlatformString = false;
        for (int i = 0; i < sPlatforms.length; ++i) {
            if (!sPlatforms[i].equals(platform)) continue;
            isPlatformString = true;
            break;
        }
        return isPlatformString;
    }

    private void addFileVersionInfo(File versionDirectory) {
        this.addFileVersionInfo(versionDirectory, null);
    }

    private void addFileVersionInfo(File versionDirectory, String neType) {
        String directoryName = versionDirectory.getName();
        try {
            String versionList = this.readVersionList(versionDirectory.getPath());
            IVersion versionObj = VersionFactory.instance().getVersion(directoryName, neType, versionList);
            File[] versionDirectoryFiles = versionDirectory.listFiles();
            for (int j = 0; j < versionDirectoryFiles.length; ++j) {
                if (!versionDirectoryFiles[j].isFile()) continue;
                String filename = versionDirectoryFiles[j].getName();
                try {
                    this.addFileVersionInfo(filename, versionObj, false);
                    continue;
                }
                catch (IOException ex) {
                    this.mLog.warn("IOException occurred while adding file version for " + filename + " that has version " + ((Object)versionObj).toString(), ex);
                }
            }
        }
        catch (IncompatibleVersionStringException ex) {
            this.mLog.warn("Directory " + directoryName + " is not a Version directory", ex);
        }
        catch (IncompatibleVersionListException ex) {
            this.mLog.warn("IncompatibleVersionListException occurred during addFileVersionInfo.", ex);
        }
    }

    private String readVersionList(String versionDirName) {
        String versionList = null;
        String filename = versionDirName + File.separator + "backward_compatible";
        File backwardCompatibleFile = new File(filename);
        if (backwardCompatibleFile.exists() && backwardCompatibleFile.isFile()) {
            Preferences pref = Preferences.getPreferenceInstance(filename);
            versionList = pref.getProperty("ne", "backward_compatible_version_list", null);
        }
        return versionList;
    }

    public IVersion[] getVersions(String filename) {
        return (IVersion[])this.mFileVersionMap.get(filename);
    }

    private void remove(String filename, IVersion version) {
        if (!filename.equals("cwi_ne.jar")) {
            String relativePathname = ((Object)version).toString();
            File[] files = this.mFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isDirectory() || !files[i].getName().equals(relativePathname)) continue;
                File[] versionedFiles = files[i].listFiles();
                for (int j = 0; j < versionedFiles.length; ++j) {
                    if (!versionedFiles[j].getName().equals(filename)) continue;
                    versionedFiles[j].delete();
                    break;
                }
                if ((versionedFiles = files[i].listFiles()) == null || versionedFiles.length != 0) break;
                files[i].delete();
                break;
            }
        }
    }

    public void addFileVersionInfo(String filename, IVersion version, boolean addToLog) throws IOException {
        if (addToLog) {
            this.addToInstallFileLog(this.getAbsolutePath(filename, version), this.getAbsolutePath());
        }
        if (!filename.equals("backward_compatible")) {
            IVersion[] existingVersions = (IVersion[])this.mFileVersionMap.get(filename);
            if (existingVersions != null && filename.equals("cwi_ne.jar")) {
                IVersion[] newVersions = new IVersion[existingVersions.length + 1];
                System.arraycopy(existingVersions, 0, newVersions, 0, existingVersions.length);
                newVersions[existingVersions.length] = version;
                this.mFileVersionMap.put(filename, newVersions);
            } else {
                if (existingVersions != null) {
                    this.remove(filename, existingVersions[0]);
                    this.removeFromInstallFileLog(this.getAbsolutePath(filename, existingVersions[0]));
                    if (filename.equalsIgnoreCase("cwi_help.zip")) {
                        File helpDir = new File(this.getHelpPath());
                        InstallerUtil.deleteDirectory(helpDir);
                    }
                }
                this.mFileVersionMap.put(filename, new IVersion[]{version});
            }
        }
    }

    private String getAbsolutePath(String filename, IVersion version) {
        StringBuffer filePath = new StringBuffer();
        filePath.append(this.getAbsolutePath()).append(File.separator);
        if (version != null) {
            filePath.append(((Object)version).toString()).append(File.separator);
        }
        filePath.append(filename);
        return filePath.toString();
    }

    public String getCompatibility() {
        return this.mFile.getName();
    }

    public String getAbsolutePath() {
        return this.mFile.getPath();
    }

    public String getHelpPath() {
        return this.mFile.getPath() + File.separator + "help";
    }

    public String[] getAbsolutePath(String filename) {
        String[] absolutePathnames = null;
        IVersion[] versions = (IVersion[])this.mFileVersionMap.get(filename);
        if (versions != null) {
            int size = versions.length;
            absolutePathnames = new String[size];
            for (int i = 0; i < size; ++i) {
                absolutePathnames[i] = this.mFile.getPath() + File.separator + versions[i] + File.separator + filename;
            }
        }
        return absolutePathnames;
    }

    public IFileVersion[] getAllFileVersionInfo() {
        IFileVersion[] allFilesVersions = null;
        ArrayList<1> filesVersions = new ArrayList<1>();
        Set keys = this.mFileVersionMap.keySet();
        for (final String key : keys) {
            IVersion[] versions = (IVersion[])this.mFileVersionMap.get(key);
            for (int i = 0; i < versions.length; ++i) {
                final IVersion version = versions[i];
                filesVersions.add(new IFileVersion(){

                    public IVersion getVersion() {
                        return version;
                    }

                    public String getFileName() {
                        return key;
                    }
                });
            }
        }
        if (filesVersions.size() > 0) {
            allFilesVersions = filesVersions.toArray(new IFileVersion[filesVersions.size()]);
        }
        return allFilesVersions;
    }

    public void print() {
        IFileVersion[] filesVersions = this.getAllFileVersionInfo();
        if (filesVersions != null) {
            for (int i = 0; i < filesVersions.length; ++i) {
                if (filesVersions[i].getVersion() == null) continue;
                this.mLog.debug("File : " + filesVersions[i].getFileName() + "; Version:" + ((Object)filesVersions[i].getVersion()).toString());
            }
        }
    }

    public INEVersion getCompatibleNEVersion(INEVersion neVersion) throws IncompatibleCWIFileVersionException, IncompatibleVersionStringException, IncompatibleVersionListException {
        INEVersion compatibleNEVersion = null;
        IVersion[] versions = (IVersion[])this.mFileVersionMap.get("cwi_ne.jar");
        if (versions != null) {
            for (int i = 0; i < versions.length; ++i) {
                try {
                    if (versions[i].compareVersion(neVersion) != 0) continue;
                    compatibleNEVersion = (INEVersion)versions[i];
                    break;
                }
                catch (IncompatibleCWIFileVersionException ie) {
                    this.mLog.info("Comparing ne version types...");
                    continue;
                }
                catch (Exception e) {
                    this.mLog.error("Exception at NEVersion compare", e);
                }
            }
            if (compatibleNEVersion == null) {
                for (int j = 0; j < versions.length; ++j) {
                    if (versions[j].getBackwardCompatibleVersionList() == null || !versions[j].getBackwardCompatibleVersionList().contains(neVersion)) continue;
                    compatibleNEVersion = (INEVersion)versions[j];
                    break;
                }
            }
        }
        if (compatibleNEVersion == null) {
            throw new IncompatibleCWIFileVersionException("Compatible NE version object not found");
        }
        return compatibleNEVersion;
    }

    public void addToInstallFileLog(String filePath) {
        this.addToInstallFileLog(filePath, null);
    }

    public void removeFromInstallFileLog(String filePath) {
        this.mInstallFileData.remove(filePath);
    }

    public void addToInstallFileLog(String filePath, String dirPath) {
        this.mInstallFileData.put(filePath, dirPath);
    }

    private String getInstallFileContents() {
        StringBuffer installFileLogContents = new StringBuffer();
        Set keys = this.mInstallFileData.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            String dirName = (String)this.mInstallFileData.get(fileName);
            installFileLogContents.append(fileName);
            if (dirName != null) {
                installFileLogContents.append(": ");
                installFileLogContents.append(dirName);
            }
            if (!iter.hasNext()) continue;
            installFileLogContents.append("\n");
        }
        return installFileLogContents.toString();
    }

    public void generateInstallFile() {
        String compatibilityPath = this.getAbsolutePath();
        String installFileLogName = compatibilityPath + File.separator + "install_file_log";
        this.addToInstallFileLog(installFileLogName, compatibilityPath);
        String installFileLogContents = this.getInstallFileContents();
        this.mLog.debug("Contents of " + installFileLogName + " are: " + installFileLogContents);
        InstallerUtil.createFile(this, compatibilityPath, "install_file_log", installFileLogContents);
    }
}

