/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.CWIFile;
import com.cisco.hfr.cwi.installer.CacheUtilities;
import com.cisco.hfr.cwi.installer.CachedFile;
import com.cisco.hfr.cwi.installer.CompatibilityDirectory;
import com.cisco.hfr.cwi.installer.DownloadUpdate;
import com.cisco.hfr.cwi.installer.ICopy;
import com.cisco.hfr.cwi.installer.IDescriptorRetriever;
import com.cisco.hfr.cwi.installer.IFileRetriever;
import com.cisco.hfr.cwi.installer.IProgressObserver;
import com.cisco.hfr.cwi.installer.IVersion;
import com.cisco.hfr.cwi.installer.InstallerPanel;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import com.cisco.hfr.mgbl.security.SSLInitializer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Encoder;

public class HTTPFileRetriever
implements IFileRetriever,
IDescriptorRetriever,
ICopy {
    private Log mLog = LogFactory.getLog(HTTPFileRetriever.class);
    private URL mBaseURL = null;
    private String mHostName = null;
    private String mUserName = null;
    private String mPassword = null;
    private InstallerPanel mInstallerPanel = null;

    public HTTPFileRetriever(String username, String password, String hostname, URL baseURL, InstallerPanel panel) {
        this.mBaseURL = baseURL;
        this.mHostName = hostname;
        this.mUserName = username;
        this.mPassword = password;
        this.mInstallerPanel = panel;
    }

    public InputStream getDescriptorFile() throws IOException {
        String urlStr = null;
        BufferedInputStream inputStream = null;
        Object urlConnection = null;
        File tempFile = File.createTempFile("descriptor", null);
        String tempFileName = tempFile.getPath();
        try {
            urlStr = this.mBaseURL.toString() + "cwi.xml";
            this.mLog.info("Downloading descriptor file from " + urlStr);
            this.copyURLContentsToFile(urlStr, tempFileName);
            inputStream = new BufferedInputStream(new FileInputStream(tempFileName));
        }
        catch (FileNotFoundException ex) {
            this.mLog.error("FileNotFoundException occurred while retrieving descriptor file ", ex);
            throw ex;
        }
        finally {
            tempFile.deleteOnExit();
        }
        return inputStream;
    }

    private final void setAuthenticationInfo(HttpURLConnection urlConnection) {
        if (this.mUserName != null && this.mPassword != null) {
            String userPassword = this.mUserName + ":" + this.mPassword;
            String encoding = new BASE64Encoder().encode(userPassword.getBytes());
            urlConnection.setRequestProperty("Authorization", "Basic " + encoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFiles(CWIFile[] files, CompatibilityDirectory downloadDirectory) throws IOException {
        long maxSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            maxSize += ((Long)files[i].getProperty("size")).longValue();
        }
        this.mInstallerPanel.showProgress();
        DownloadUpdate downloadUpdate = new DownloadUpdate(this.mInstallerPanel.getProgressBar());
        long currentOffset = 0L;
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getFileName();
            this.mInstallerPanel.setProgressLabel("Downloading " + fileName);
            IVersion version = files[i].getVersion();
            String cacheFileName = CacheUtilities.getCacheFilePath(downloadDirectory.getAbsolutePath(), fileName, version);
            String urlStr = this.mBaseURL.toString() + files[i].getProperty("name");
            this.mLog.info("File to be downloaded is : " + cacheFileName);
            this.mLog.info("Caching : " + urlStr);
            CachedFile file = new CachedFile(urlStr, cacheFileName, maxSize, this);
            file.setCurrent(currentOffset);
            file.addObserver(downloadUpdate);
            try {
                file.init();
                downloadDirectory.addFileVersionInfo(fileName, files[i].getVersion(), true);
            }
            finally {
                file.deleteObserver(downloadUpdate);
            }
            currentOffset = file.getCurrent();
        }
        this.mInstallerPanel.setProgressMaximum();
        this.mInstallerPanel.setProgressLabel("");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            this.mLog.warn("Sleep before showing Cisco logo disrupted", ex);
        }
        this.mInstallerPanel.showCiscoLogo();
    }

    private void copyURLContentsToFile(String url, String filename) throws IOException {
        this.copyFile(url, filename, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFile(String url, String filename, IProgressObserver observer) throws IOException {
        URL sourceUrl = null;
        InputStream source = null;
        OutputStream cached = null;
        byte[] data = new byte[16384];
        int nread = 0;
        HttpURLConnection urlc = null;
        sourceUrl = new URL(url);
        urlc = "https".equalsIgnoreCase(sourceUrl.getProtocol()) ? SSLInitializer.instance().initializeHttpsProtocol(sourceUrl.toString()) : (HttpURLConnection)sourceUrl.openConnection();
        this.setAuthenticationInfo(urlc);
        urlc.setUseCaches(false);
        urlc.connect();
        source = urlc.getInputStream();
        nread = source.read(data, 0, data.length);
        if (nread > 0) {
            File toFile = new File(filename);
            File toDir = new File(toFile.getParent());
            if (!InstallerUtil.checkPermissions(toDir)) {
                throw new IOException(toFile.getParent() + " has read-only access");
            }
            cached = new FileOutputStream(filename);
        }
        while (nread > 0) {
            cached.write(data, 0, nread);
            if (observer != null) {
                observer.progressUpdate(nread);
            }
            try {
                nread = source.read(data, 0, data.length);
            }
            catch (IOException ex) {
                this.mLog.error("Unexpected IOException occurred while reading data through http(s).", ex);
                throw ex;
            }
        }
        urlc.disconnect();
        if (cached != null) {
            Thread closeThread = new Thread(new CloseOutputStream(cached));
            closeThread.start();
        }
        if (source == null) return;
        try {
            source.close();
            return;
        }
        catch (IOException ex) {
            this.mLog.warn("IOException occurred while closing the input stream attached to url " + url, ex);
            return;
        }
        catch (GeneralSecurityException ex) {
            this.mLog.error("GeneralSecurityException(SSL) occurred while downloading files through http(s).", ex);
            throw new IOException("SSL exception occurred during download of " + url);
            catch (MalformedURLException ex2) {
                this.mLog.error("MalformedURLException occurred while downloading files through http(s).", ex2);
                return;
            }
            catch (FileNotFoundException ex3) {
                this.mLog.error("FileNotFoundException occurred while downloading files through http(s).", ex3);
                throw ex3;
            }
        }
        finally {
            urlc.disconnect();
            if (cached != null) {
                Thread closeThread = new Thread(new CloseOutputStream(cached));
                closeThread.start();
            }
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException ex) {
                    this.mLog.warn("IOException occurred while closing the input stream attached to url " + url, ex);
                }
            }
        }
    }

    private class CloseOutputStream
    implements Runnable {
        private OutputStream mOutputStream;

        CloseOutputStream(OutputStream os) {
            this.mOutputStream = os;
        }

        public void run() {
            try {
                this.mOutputStream.close();
            }
            catch (Exception ex) {
                System.out.println("Error : " + ex.toString());
            }
        }
    }
}

