/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.CWIDescriptor;
import com.cisco.hfr.cwi.installer.CacheBackup;
import com.cisco.hfr.cwi.installer.CacheUtilities;
import com.cisco.hfr.cwi.installer.HTTPFileRetriever;
import com.cisco.hfr.cwi.installer.ICacheBackup;
import com.cisco.hfr.cwi.installer.IDescriptorRetriever;
import com.cisco.hfr.cwi.installer.IFileRetriever;
import com.cisco.hfr.cwi.installer.InstallFailException;
import com.cisco.hfr.cwi.installer.InstallOptionsDialog;
import com.cisco.hfr.cwi.installer.InstallerPanel;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import com.cisco.hfr.cwi.installer.LocalCopyFileRetriever;
import com.cisco.hfr.cwi.installer.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class InstallerApplet
extends JApplet {
    private Log mLog = null;
    private static final String INSTALLATION_UNSUCCESSFUL = "Installation was unsuccessful.";
    private static final String INSTALLATION_SUCCESSFUL = "Installation was successful.";
    private static final String sUserHome = System.getProperty("user.home");
    private static final String sCurrentDir = System.getProperty("user.dir");
    private static final String CLOSE_PAGE_HTML = "closePage.html";
    private CWIDescriptor mDescriptor = null;
    private IDescriptorRetriever mDescriptorRetriever = null;
    private IFileRetriever mFileRetriever = null;
    private boolean mAppletProblem = false;
    private String mCWIHomeDir = null;
    private boolean mAddToDesktop = false;
    private String mNodeName;
    private String mUserName;
    private String mPassword;
    private String mProtocol = null;
    private int mPort = 80;
    private ICacheBackup mBackup = null;
    private InstallerPanel mInstallerPanel = new InstallerPanel();

    public static void main(String[] args) {
        final JFrame mainFrame = new JFrame("CWI Installer");
        InstallerApplet applet = new InstallerApplet();
        applet.initializeApacheCommonsLogging();
        applet.mFileRetriever = new LocalCopyFileRetriever(new File(sCurrentDir), applet.mInstallerPanel);
        applet.mDescriptorRetriever = (IDescriptorRetriever)((Object)applet.mFileRetriever);
        try {
            applet.initialize(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            InstallerUtil.showErrorDialog(null, "Error while initializing CWI Installer");
            System.exit(0);
        }
        mainFrame.getContentPane().add("Center", applet);
        Dimension frameSize = new Dimension(800, 600);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mainFrame.setSize(frameSize);
        mainFrame.pack();
        frameSize = mainFrame.getSize();
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        mainFrame.setLocation(x, y);
        mainFrame.addWindowListener(new WindowListener(){

            public void windowClosed(WindowEvent we) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent we) {
                mainFrame.dispose();
            }

            public void windowActivated(WindowEvent we) {
            }

            public void windowDeactivated(WindowEvent we) {
            }

            public void windowDeiconified(WindowEvent we) {
            }

            public void windowIconified(WindowEvent we) {
            }

            public void windowOpened(WindowEvent we) {
            }
        });
        mainFrame.show();
        applet.start();
    }

    private void initPort() {
        if (this.mPort == -1) {
            this.mPort = "https".equalsIgnoreCase(this.mProtocol) ? 443 : 80;
        }
    }

    public void init() {
        this.initializeApacheCommonsLogging();
        if (!InstallerUtil.checkPermissions()) {
            this.mAppletProblem = true;
            String errorMessage = "Applet security restrictions are preventing CWI from\nstarting.  Please review the installation instructions\nto make sure that the CWI installer is given the permissions it needs.\n\nNote that you must exit and re-start your browser in order\nfor the new permissions to take effect. ";
            InstallerUtil.showErrorDialog(this, errorMessage);
            this.stop();
        }
        if (!this.mAppletProblem) {
            this.mProtocol = this.getDocumentBase().getProtocol();
            this.mPort = this.getDocumentBase().getPort();
            InstallerUtil.initializeProtocol(this.mProtocol);
            this.initPort();
            this.setupCommonParameters(this.getDocumentBase().getHost());
            this.mFileRetriever = new HTTPFileRetriever(this.mUserName, this.mPassword, this.mNodeName, this.getCodeBase(), this.mInstallerPanel);
            this.mDescriptorRetriever = (IDescriptorRetriever)((Object)this.mFileRetriever);
            try {
                this.initialize(false);
            }
            catch (Exception ex) {
                String error = "Error while initializing CWI Installer";
                this.mLog.error(error, ex);
                InstallerUtil.showErrorDialog(this, error);
                this.stop();
            }
        }
    }

    private void setupCommonParameters(String nodename) {
        this.mNodeName = nodename;
    }

    private void initialize(final boolean isStandaloneApplication) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception ex) {
            this.mLog.warn("Metal look and feel not supported", ex);
        }
        if (File.separator.equals("/")) {
            System.setProperty("cwi.ini.file", sUserHome + File.separator + ".cwirc");
        } else {
            System.setProperty("cwi.ini.file", sUserHome + File.separator + "cwi.ini");
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.mInstallerPanel, "Center");
        contentPane.validate();
        new Thread(new Runnable(){

            public void run() {
                InstallerApplet.this.install(isStandaloneApplication);
                if (isStandaloneApplication) {
                    System.exit(0);
                }
            }
        }).start();
    }

    private void initializeApacheCommonsLogging() {
        System.setProperty("org.apache.commons.logging.LogFactory", LogFactoryImpl.class.getName());
        System.setProperty("org.apache.commons.logging.Log", Jdk14Logger.class.getName());
        this.mLog = LogFactory.getLog(InstallerApplet.class);
        Logger.getLogger("").setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void install(boolean isStandAloneApplication) {
        try {
            block64: {
                block62: {
                    block63: {
                        prefs = Preferences.getPreferenceInstance(InstallerUtil.getCWIPreferenceFileName());
                        homeDir = InstallerUtil.getCWIHomeDirectory();
                        if (homeDir.length() != 0) break block62;
                        dlg = new InstallOptionsDialog(null, this);
                        dlg.show();
                        if (dlg.isOKSelected()) break block63;
                        var9_11 = null;
                        ** GOTO lbl278
                    }
                    homeDir = dlg.getInstallDirectory().trim();
                    this.mCWIHomeDir = homeDir.endsWith(File.separator) ? homeDir + "cwi" : homeDir + File.separator + "cwi";
                    break block64;
                }
                this.mCWIHomeDir = homeDir;
            }
            InstallerUtil.createCWIDirectoryStructure(this.mCWIHomeDir);
            installLogFileName = this.mCWIHomeDir + File.separator + "logger" + File.separator + "install.log";
            installLog = new File(installLogFileName);
            if (installLog.exists()) {
                installLog.delete();
            }
            logFile = new FileHandler(installLogFileName);
            logFile.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(logFile);
            this.mLog.info("CWI Home directory : " + this.mCWIHomeDir);
            prefs.setProperty("cwi", "home", this.mCWIHomeDir);
            prefs.store();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.mInstallerPanel.setInfoLabel("Retrieving Version information...");
            this.mInstallerPanel.showInfo();
            this.mDescriptor = new CWIDescriptor(this.mDescriptorRetriever);
            try {
                this.mInstallerPanel.setInfoLabel("Backing up cache...");
                this.mBackup = new CacheBackup(CacheUtilities.getCompatibilityFile(this.mDescriptor, this.mCWIHomeDir));
            }
            catch (IOException ex) {
                this.mLog.warn("Unexpected IOException occurred during backing up compatibility directory", ex);
            }
            this.mInstallerPanel.setInfoLabel("Verifying the local cache...");
            shortcutMsg = CacheUtilities.updateCache(this.mFileRetriever, this.mDescriptor, this.mCWIHomeDir, this);
            if (this.mBackup != null) {
                this.mInstallerPanel.setInfoLabel("Cleaning backed up cache...");
                this.mBackup.clean();
                this.mBackup = null;
            }
            InstallerUtil.showInfoDialog(this, shortcutMsg + "\n" + "Installation was successful.");
            ** GOTO lbl306
        }
        catch (SecurityException e) {
            this.mLog.error("SecurityException occurred during installation.", e);
            InstallerUtil.showErrorDialog(this, "Unable to launch CWI due to applet security restrictions.\n\nPlease review the installation instructions to make sure\nthat the CWI installer is given the permissions it needs.\n\nNote that you must exit and re-start your browser in order\nfor the new permissions to take effect.\nInstallation was unsuccessful.");
            var9_13 = null;
            try {
                if (this.mBackup != null) {
                    this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                    this.mBackup.restore();
                }
            }
            catch (IOException ex) {
                errorMessage = "Unable to restore CWI to previous state";
                InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
            }
            this.mInstallerPanel.showCiscoLogo();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (isStandAloneApplication != false) return;
            try {
                this.mLog.info(" Document Base : " + this.getDocumentBase());
                this.mLog.info(" Code Base : " + this.getCodeBase());
                docBaseStr = this.getDocumentBase().toString();
                if (docBaseStr == null) return;
                if (docBaseStr.endsWith("/")) {
                    docBaseStr = docBaseStr + "closePage.html";
                } else {
                    docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                    docBaseStr = docBaseStr + "closePage.html";
                }
                this.getAppletContext().showDocument(new URL(docBaseStr));
                return;
            }
            catch (Exception e) {
                this.mLog.error("Error while loading the Close Page :", e);
                return;
            }
        }
        catch (NoRouteToHostException e) {
            block65: {
                this.mLog.error("NoRouteToHostException occurred during installation.", e);
                InstallerUtil.showErrorDialog(this, "The host name (e.g., for the network element)\nwas successfully resolved to its address, but\nno route can be found through the network to\nreach the address.\nInstallation was unsuccessful.");
                var9_14 = null;
                ** try [egrp 3[TRYBLOCK] [22 : 696->724)] { 
lbl88:
                // 1 sources

                if (this.mBackup != null) {
                    this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                    this.mBackup.restore();
                }
                break block65;
lbl92:
                // 1 sources

                catch (IOException ex) {
                    errorMessage = "Unable to restore CWI to previous state";
                    InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                    this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
                }
            }
            this.mInstallerPanel.showCiscoLogo();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (isStandAloneApplication != false) return;
            try {}
            catch (Exception e) {
                this.mLog.error("Error while loading the Close Page :", e);
                return;
            }
            this.mLog.info(" Document Base : " + this.getDocumentBase());
            this.mLog.info(" Code Base : " + this.getCodeBase());
            docBaseStr = this.getDocumentBase().toString();
            if (docBaseStr == null) return;
            if (docBaseStr.endsWith("/")) {
                docBaseStr = docBaseStr + "closePage.html";
            } else {
                docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                docBaseStr = docBaseStr + "closePage.html";
            }
            this.getAppletContext().showDocument(new URL(docBaseStr));
            return;
        }
        catch (UnknownHostException e) {
            block66: {
                this.mLog.error("UnknownHostException occurred during installation.", e);
                InstallerUtil.showErrorDialog(this, "The host name of the network element cannot\nbe resolved to an address.\nInstallation was unsuccessful.");
                var9_15 = null;
                ** try [egrp 3[TRYBLOCK] [22 : 696->724)] { 
lbl121:
                // 1 sources

                if (this.mBackup != null) {
                    this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                    this.mBackup.restore();
                }
                break block66;
lbl125:
                // 1 sources

                catch (IOException ex) {
                    errorMessage = "Unable to restore CWI to previous state";
                    InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                    this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
                }
            }
            this.mInstallerPanel.showCiscoLogo();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (isStandAloneApplication != false) return;
            try {}
            catch (Exception e) {
                this.mLog.error("Error while loading the Close Page :", e);
                return;
            }
            this.mLog.info(" Document Base : " + this.getDocumentBase());
            this.mLog.info(" Code Base : " + this.getCodeBase());
            docBaseStr = this.getDocumentBase().toString();
            if (docBaseStr == null) return;
            if (docBaseStr.endsWith("/")) {
                docBaseStr = docBaseStr + "closePage.html";
            } else {
                docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                docBaseStr = docBaseStr + "closePage.html";
            }
            this.getAppletContext().showDocument(new URL(docBaseStr));
            return;
        }
        catch (IOException e) {
            block67: {
                this.mLog.error("IOException occurred during installation.", e);
                InstallerUtil.showErrorDialog(this, e.getMessage() + "\n" + "Installation was unsuccessful.");
                var9_16 = null;
                ** try [egrp 3[TRYBLOCK] [22 : 696->724)] { 
lbl154:
                // 1 sources

                if (this.mBackup != null) {
                    this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                    this.mBackup.restore();
                }
                break block67;
lbl158:
                // 1 sources

                catch (IOException ex) {
                    errorMessage = "Unable to restore CWI to previous state";
                    InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                    this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
                }
            }
            this.mInstallerPanel.showCiscoLogo();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (isStandAloneApplication != false) return;
            try {}
            catch (Exception e) {
                this.mLog.error("Error while loading the Close Page :", e);
                return;
            }
            this.mLog.info(" Document Base : " + this.getDocumentBase());
            this.mLog.info(" Code Base : " + this.getCodeBase());
            docBaseStr = this.getDocumentBase().toString();
            if (docBaseStr == null) return;
            if (docBaseStr.endsWith("/")) {
                docBaseStr = docBaseStr + "closePage.html";
            } else {
                docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                docBaseStr = docBaseStr + "closePage.html";
            }
            this.getAppletContext().showDocument(new URL(docBaseStr));
            return;
        }
        catch (InstallFailException e) {
            block68: {
                this.mLog.error("InstallFailException occurred during installation.", e);
                InstallerUtil.showErrorDialog(this, e.getMessage() + "\n" + "Installation was unsuccessful.");
                var9_17 = null;
                ** try [egrp 3[TRYBLOCK] [22 : 696->724)] { 
lbl187:
                // 1 sources

                if (this.mBackup != null) {
                    this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                    this.mBackup.restore();
                }
                break block68;
lbl191:
                // 1 sources

                catch (IOException ex) {
                    errorMessage = "Unable to restore CWI to previous state";
                    InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                    this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
                }
            }
            this.mInstallerPanel.showCiscoLogo();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (isStandAloneApplication != false) return;
            try {}
            catch (Exception e) {
                this.mLog.error("Error while loading the Close Page :", e);
                return;
            }
            this.mLog.info(" Document Base : " + this.getDocumentBase());
            this.mLog.info(" Code Base : " + this.getCodeBase());
            docBaseStr = this.getDocumentBase().toString();
            if (docBaseStr == null) return;
            if (docBaseStr.endsWith("/")) {
                docBaseStr = docBaseStr + "closePage.html";
            } else {
                docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                docBaseStr = docBaseStr + "closePage.html";
            }
            this.getAppletContext().showDocument(new URL(docBaseStr));
            return;
        }
        catch (Exception e) {
            block69: {
                this.mLog.error("Exception occurred during installation.", e);
                InstallerUtil.showErrorDialog(this, e.getMessage() + "\n" + "Installation was unsuccessful.");
                var9_18 = null;
                ** try [egrp 3[TRYBLOCK] [22 : 696->724)] { 
lbl220:
                // 1 sources

                if (this.mBackup != null) {
                    this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                    this.mBackup.restore();
                }
                break block69;
lbl224:
                // 1 sources

                catch (IOException ex) {
                    errorMessage = "Unable to restore CWI to previous state";
                    InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                    this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
                }
            }
            this.mInstallerPanel.showCiscoLogo();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (isStandAloneApplication != false) return;
            try {}
            catch (Exception e) {
                this.mLog.error("Error while loading the Close Page :", e);
                return;
            }
            this.mLog.info(" Document Base : " + this.getDocumentBase());
            this.mLog.info(" Code Base : " + this.getCodeBase());
            docBaseStr = this.getDocumentBase().toString();
            if (docBaseStr == null) return;
            if (docBaseStr.endsWith("/")) {
                docBaseStr = docBaseStr + "closePage.html";
            } else {
                docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                docBaseStr = docBaseStr + "closePage.html";
            }
            this.getAppletContext().showDocument(new URL(docBaseStr));
            return;
        }
        {
            block72: {
                block71: {
                    catch (Throwable var8_42) {
                        block70: {
                            var9_19 = null;
                            ** try [egrp 3[TRYBLOCK] [22 : 696->724)] { 
lbl251:
                            // 1 sources

                            if (this.mBackup != null) {
                                this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                                this.mBackup.restore();
                            }
                            break block70;
lbl255:
                            // 1 sources

                            catch (IOException ex) {
                                errorMessage = "Unable to restore CWI to previous state";
                                InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                                this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
                            }
                        }
                        this.mInstallerPanel.showCiscoLogo();
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        if (isStandAloneApplication != false) throw var8_42;
                        ** try [egrp 4[TRYBLOCK] [23 : 768->939)] { 
lbl264:
                        // 1 sources

                        this.mLog.info(" Document Base : " + this.getDocumentBase());
                        this.mLog.info(" Code Base : " + this.getCodeBase());
                        docBaseStr = this.getDocumentBase().toString();
                        if (docBaseStr == null) throw var8_42;
                        if (docBaseStr.endsWith("/")) {
                            docBaseStr = docBaseStr + "closePage.html";
                        } else {
                            docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                            docBaseStr = docBaseStr + "closePage.html";
                        }
                        this.getAppletContext().showDocument(new URL(docBaseStr));
                        throw var8_42;
lbl275:
                        // 1 sources

                        catch (Exception e) {
                            this.mLog.error("Error while loading the Close Page :", e);
                        }
                        throw var8_42;
                    }
lbl278:
                    // 1 sources

                    ** try [egrp 3[TRYBLOCK] [22 : 696->724)] { 
lbl279:
                    // 1 sources

                    if (this.mBackup != null) {
                        this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                        this.mBackup.restore();
                    }
                    break block71;
lbl283:
                    // 1 sources

                    catch (IOException ex) {
                        errorMessage = "Unable to restore CWI to previous state";
                        InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                        this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
                    }
                }
                this.mInstallerPanel.showCiscoLogo();
                this.setCursor(Cursor.getPredefinedCursor(0));
                if (isStandAloneApplication != false) return;
                ** try [egrp 4[TRYBLOCK] [23 : 768->939)] { 
lbl292:
                // 1 sources

                this.mLog.info(" Document Base : " + this.getDocumentBase());
                this.mLog.info(" Code Base : " + this.getCodeBase());
                docBaseStr = this.getDocumentBase().toString();
                if (docBaseStr == null) return;
                if (docBaseStr.endsWith("/")) {
                    docBaseStr = docBaseStr + "closePage.html";
                } else {
                    docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                    docBaseStr = docBaseStr + "closePage.html";
                }
                this.getAppletContext().showDocument(new URL(docBaseStr));
                return;
lbl303:
                // 1 sources

                catch (Exception e) {
                    this.mLog.error("Error while loading the Close Page :", e);
                }
                return;
lbl306:
                // 1 sources

                var9_12 = null;
                ** try [egrp 3[TRYBLOCK] [22 : 696->724)] { 
lbl308:
                // 1 sources

                if (this.mBackup != null) {
                    this.mInstallerPanel.setInfoLabel("Restoring backed up cache...");
                    this.mBackup.restore();
                }
                break block72;
lbl312:
                // 1 sources

                catch (IOException ex) {
                    errorMessage = "Unable to restore CWI to previous state";
                    InstallerUtil.showErrorDialog(this, "Unable to restore CWI to previous state\nInstallation was unsuccessful.");
                    this.mLog.warn("Unexpected IOException occurred during restoring the backup : Unable to restore CWI to previous state", ex);
                }
            }
            this.mInstallerPanel.showCiscoLogo();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (isStandAloneApplication != false) return;
            try {}
            catch (Exception e) {}
            this.mLog.error("Error while loading the Close Page :", e);
            return;
            this.mLog.info(" Document Base : " + this.getDocumentBase());
            this.mLog.info(" Code Base : " + this.getCodeBase());
            docBaseStr = this.getDocumentBase().toString();
            if (docBaseStr == null) return;
            if (docBaseStr.endsWith("/")) {
                docBaseStr = docBaseStr + "closePage.html";
            } else {
                docBaseStr = docBaseStr.substring(0, docBaseStr.lastIndexOf(47) + 1);
                docBaseStr = docBaseStr + "closePage.html";
            }
            this.getAppletContext().showDocument(new URL(docBaseStr));
            return;
        }
    }
}

