/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.CompatibilityDirectory;
import com.cisco.hfr.cwi.installer.IProgressObserver;
import com.cisco.hfr.cwi.installer.Preferences;
import com.cisco.hfr.mgbl.security.SSLInitializer;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstallerUtil {
    private static Log sLog = LogFactory.getLog(InstallerUtil.class);
    private static final String ERROR_ICON = "/images/fatal_error32.gif";
    private static final String INFO_ICON = "/images/informational32.gif";
    private static final String QUESTION_ICON = "/images/question32.gif";

    public static void showErrorDialog(Component parent, String message) {
        InstallerUtil.showErrorDialog(parent, message, "CWI Installer - Error");
    }

    public static void showErrorDialog(Component parent, String message, String title) {
        JOptionPane.showMessageDialog(parent, message, title, 0, new ImageIcon(InstallerUtil.class.getResource(ERROR_ICON)));
    }

    public static boolean showQuestionDialog(Component parent, String message) {
        int option = JOptionPane.showConfirmDialog(parent, message, "CWI Installer", 0, 3, new ImageIcon(InstallerUtil.class.getResource(QUESTION_ICON)));
        return option == 0;
    }

    public static void showInfoDialog(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "CWI Installer", 1, new ImageIcon(InstallerUtil.class.getResource(INFO_ICON)));
    }

    public static String getCWIHomeDirectory() {
        String cwiHomeDir = Preferences.getPreferenceInstance(InstallerUtil.getCWIPreferenceFileName()).getProperty("cwi", "home", "");
        if (cwiHomeDir.length() != 0) {
            File cwiHome = new File(cwiHomeDir);
            cwiHomeDir = cwiHome.getPath();
        }
        return cwiHomeDir;
    }

    public static synchronized boolean checkPermissions() {
        return InstallerUtil.checkPermissions(null);
    }

    public static synchronized boolean checkPermissions(File dir) {
        String CWI_FILENAME = "cwi";
        String TXT_SUFFIX = ".txt";
        try {
            File tmpFile = null;
            tmpFile = dir == null ? File.createTempFile("cwi", ".txt") : File.createTempFile("cwi", ".txt", dir);
            tmpFile.delete();
            return true;
        }
        catch (IOException ex) {
            sLog.warn("IOException occurred during creation/deletion of temporary file - cwi.txt", ex);
            return false;
        }
    }

    public static final void createCWIDirectoryStructure(String cwiHome) {
        File cwiHomeDir = new File(cwiHome);
        if (!cwiHomeDir.exists() || !cwiHomeDir.isDirectory()) {
            cwiHomeDir.mkdirs();
        }
        String cacheDirPath = cwiHome + File.separator + "versions";
        String binPath = cwiHome + File.separator + "bin";
        String loggerPath = cwiHome + File.separator + "logger";
        String uninstallPath = cwiHome + File.separator + "uninstall";
        File dir = new File(cacheDirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        if (!(dir = new File(binPath)).exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        if (!(dir = new File(loggerPath)).exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        if (!(dir = new File(uninstallPath)).exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
    }

    public static final boolean isWindows() {
        String os = System.getProperty("os.name").toUpperCase();
        return os.startsWith("WINDOWS");
    }

    public static final boolean isMacOS() {
        String os = System.getProperty("os.name").toUpperCase();
        return os.startsWith("MAC OS");
    }

    public static final boolean isLinux() {
        String os = System.getProperty("os.name").toUpperCase();
        return os.indexOf("LINUX") >= 0;
    }

    public static String getOSName() {
        if (InstallerUtil.isWindows()) {
            return "Windows";
        }
        if (InstallerUtil.isMacOS()) {
            return "Mac";
        }
        if (InstallerUtil.isLinux()) {
            return "Linux";
        }
        return "Unix";
    }

    public static final void createDirectoryIfNecessary(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
    }

    public static void initializeProtocol(String protocol) {
        if ("https".equalsIgnoreCase(protocol)) {
            try {
                SSLInitializer.instance();
            }
            catch (Exception ex) {
                sLog.error("CWI: Error Initializing SSL libraries", ex);
            }
        }
    }

    public static void createFile(CompatibilityDirectory compatibilityDirectory, String dirName, String fileName, String fileContents) {
        InstallerUtil.createFile(compatibilityDirectory, dirName, fileName, fileContents, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void createFile(CompatibilityDirectory compatibilityDirectory, String dirName, String fileName, String fileContents, String installLogDirName) {
        block15: {
            BufferedWriter execFile;
            block14: {
                execFile = null;
                File directory = new File(dirName);
                if (!directory.exists()) {
                    directory.mkdirs();
                }
                if (!InstallerUtil.checkPermissions(directory)) {
                    throw new IOException(dirName + " has read-only access");
                }
                String filePath = dirName + File.separator + fileName;
                execFile = new BufferedWriter(new FileWriter(filePath));
                execFile.write(fileContents);
                if (compatibilityDirectory != null) {
                    compatibilityDirectory.addToInstallFileLog(filePath, installLogDirName);
                }
                if (InstallerUtil.isWindows()) break block14;
                String command = "chmod oug+x " + dirName + File.separator + fileName;
                Runtime.getRuntime().exec(command);
            }
            Object var10_10 = null;
            try {
                if (execFile != null) {
                    execFile.close();
                }
                break block15;
            }
            catch (Exception ex) {
                sLog.error("Error while closing the file writer for " + fileName, ex);
            }
            break block15;
            {
                catch (IOException e) {
                    sLog.error("Error writing to the file: " + fileName, e);
                    Object var10_11 = null;
                    try {
                        if (execFile != null) {
                            execFile.close();
                        }
                        break block15;
                    }
                    catch (Exception ex) {
                        sLog.error("Error while closing the file writer for " + fileName, ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (execFile != null) {
                        execFile.close();
                    }
                }
                catch (Exception ex) {
                    sLog.error("Error while closing the file writer for " + fileName, ex);
                }
                throw throwable;
            }
        }
    }

    public static String getCWIPreferenceFileName() {
        String userHomePath = System.getProperty("user.home");
        StringBuffer fileName = new StringBuffer();
        if (InstallerUtil.isWindows()) {
            fileName.append(userHomePath).append(File.separator).append("cwi.ini");
        } else {
            fileName.append(userHomePath).append(File.separator).append(".cwirc");
        }
        return fileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashMap readFileAsMap(String filePath) throws IOException {
        HashMap fileMap = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filePath));
            fileMap = InstallerUtil.readReaderAsMap(in);
            Object var4_3 = null;
            if (in == null) return fileMap;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                sLog.warn("IOException occurred while closing the input stream attached to file " + filePath, ex);
            }
            throw throwable;
        }
        try {
            in.close();
            return fileMap;
        }
        catch (IOException ex) {
            sLog.warn("IOException occurred while closing the input stream attached to file " + filePath, ex);
        }
        return fileMap;
    }

    public static HashMap readReaderAsMap(BufferedReader reader) throws IOException {
        HashMap<String, String> fileContents = new HashMap<String, String>();
        String line = reader.readLine();
        while (line != null && line.length() > 0) {
            int index = line.indexOf(": ");
            if (index != -1) {
                fileContents.put(line.substring(0, index), line.substring(index + ": ".length()));
            } else {
                fileContents.put(line, null);
            }
            line = reader.readLine();
        }
        return fileContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFile(String filePath) {
        String fileContents = "";
        BufferedReader in = null;
        in = new BufferedReader(new FileReader(filePath));
        fileContents = InstallerUtil.readFile(in);
        Object var5_3 = null;
        if (in == null) return fileContents;
        try {
            in.close();
            return fileContents;
        }
        catch (IOException ex2) {
            sLog.warn("IOException occurred while closing the input stream attached to file " + filePath, ex2);
        }
        return fileContents;
        {
            catch (FileNotFoundException ex) {
                sLog.warn("FileNotFoundException occurred while reading " + filePath, ex);
                Object var5_4 = null;
                if (in == null) return fileContents;
                try {
                    in.close();
                    return fileContents;
                }
                catch (IOException ex2) {
                    sLog.warn("IOException occurred while closing the input stream attached to file " + filePath, ex2);
                }
                return fileContents;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                sLog.warn("IOException occurred while closing the input stream attached to file " + filePath, ex2);
            }
            throw throwable;
        }
    }

    public static String readFile(BufferedReader in) {
        char[] data = new char[16384];
        StringBuffer fileContents = new StringBuffer();
        try {
            int nread = in.read(data, 0, data.length);
            while (nread > 0) {
                fileContents.append(new String(data, 0, nread));
                nread = in.read(data, 0, data.length);
            }
        }
        catch (IOException ex) {
            sLog.error("Unexpected IOException occurred while reading through BufferedReader", ex);
        }
        return fileContents.toString();
    }

    public static String getCompatibilityString(String buildString) {
        StringBuffer compatibilityBuffer = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(buildString, ".");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (i == 2 || i == 3) {
                compatibilityBuffer.append(token);
                if (i != 2) break;
                compatibilityBuffer.append(".");
            }
            ++i;
        }
        return compatibilityBuffer.toString();
    }

    public static String getParentDirName(String fileName) {
        String parentDirName = null;
        int index = fileName.lastIndexOf(File.separator);
        if (index != -1) {
            parentDirName = fileName.substring(0, index);
        }
        return parentDirName;
    }

    public static void copyDirectory(File fromDir, File toDir) throws IOException {
        if (fromDir.exists() && fromDir.isDirectory()) {
            if (toDir.exists()) {
                InstallerUtil.deleteDirectory(toDir);
            }
            InstallerUtil.copyDirectoryRecursively(fromDir, toDir);
        }
    }

    private static void copyDirectoryRecursively(File fromDir, File toDir) throws IOException {
        String toDirPath = toDir.getPath();
        File[] files = fromDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i].getName();
            if (files[i].isDirectory()) {
                File toSubDir = new File(toDirPath + File.separator + fileName);
                toSubDir.mkdirs();
                InstallerUtil.copyDirectoryRecursively(files[i], toSubDir);
                continue;
            }
            String toDirFileName = toDirPath + File.separator + fileName;
            InstallerUtil.copyFile(files[i].getPath(), toDirFileName);
        }
    }

    private static void copyFile(String fromFileName, String toFileName) throws IOException {
        InstallerUtil.copyFile(fromFileName, toFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fromFileName, String toFileName, IProgressObserver progressObserver) throws IOException {
        IOException ex22;
        FilterOutputStream cached;
        block15: {
            byte[] data = new byte[16384];
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(fromFileName));
            cached = null;
            try {
                int nread = reader.read(data, 0, data.length);
                if (nread > 0) {
                    File toFile = new File(toFileName);
                    File toDir = new File(toFile.getParent());
                    if (!InstallerUtil.checkPermissions(toDir)) {
                        throw new IOException(toFile.getParent() + " has read-only access");
                    }
                    cached = new BufferedOutputStream(new FileOutputStream(toFileName));
                }
                while (nread > 0) {
                    ((BufferedOutputStream)cached).write(data, 0, nread);
                    if (progressObserver != null) {
                        progressObserver.progressUpdate(nread);
                    }
                    nread = reader.read(data, 0, data.length);
                }
                Object var10_9 = null;
                if (reader == null) break block15;
            }
            catch (Throwable throwable) {
                IOException ex22;
                Object var10_10 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex22) {
                        sLog.warn("IOException occurred while closing the input stream attached to file " + fromFileName, ex22);
                    }
                }
                if (cached != null) {
                    try {
                        cached.close();
                    }
                    catch (IOException ex22) {
                        sLog.warn("IOException occurred while closing the output stream attached to file " + toFileName, ex22);
                    }
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException ex22) {
                sLog.warn("IOException occurred while closing the input stream attached to file " + fromFileName, ex22);
            }
        }
        if (cached != null) {
            try {
                cached.close();
            }
            catch (IOException ex22) {
                sLog.warn("IOException occurred while closing the output stream attached to file " + toFileName, ex22);
            }
        }
    }

    public static void deleteDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                InstallerUtil.deleteDirectory(files[i]);
            }
        }
        directory.delete();
    }
}

