/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.CWIFile;
import com.cisco.hfr.cwi.installer.CacheUtilities;
import com.cisco.hfr.cwi.installer.CachedFile;
import com.cisco.hfr.cwi.installer.CompatibilityDirectory;
import com.cisco.hfr.cwi.installer.DownloadUpdate;
import com.cisco.hfr.cwi.installer.ICopy;
import com.cisco.hfr.cwi.installer.IDescriptorRetriever;
import com.cisco.hfr.cwi.installer.IFileRetriever;
import com.cisco.hfr.cwi.installer.IProgressObserver;
import com.cisco.hfr.cwi.installer.IVersion;
import com.cisco.hfr.cwi.installer.InstallerPanel;
import com.cisco.hfr.cwi.installer.InstallerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalCopyFileRetriever
implements IFileRetriever,
IDescriptorRetriever,
ICopy {
    private Log mLog = LogFactory.getLog(LocalCopyFileRetriever.class);
    private File mFromDir = null;
    private InstallerPanel mInstallerPanel = null;

    public LocalCopyFileRetriever(File dir, InstallerPanel panel) {
        this.mFromDir = dir;
        this.mInstallerPanel = panel;
    }

    public InputStream getDescriptorFile() throws IOException {
        String descriptorFileName = this.mFromDir.getPath() + File.separator + "cwi.xml";
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(descriptorFileName));
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFiles(CWIFile[] files, CompatibilityDirectory downloadDirectory) throws IOException {
        long maxSize = 0L;
        for (int i = 0; i < files.length; ++i) {
            maxSize += ((Long)files[i].getProperty("size")).longValue();
        }
        this.mInstallerPanel.showProgress();
        DownloadUpdate downloadUpdate = new DownloadUpdate(this.mInstallerPanel.getProgressBar());
        long currentOffset = 0L;
        for (int i = 0; i < files.length; ++i) {
            Object var15_14;
            String fileName = files[i].getFileName();
            this.mInstallerPanel.setProgressLabel("Copying " + fileName);
            IVersion version = files[i].getVersion();
            String cacheFileName = CacheUtilities.getCacheFilePath(downloadDirectory.getAbsolutePath(), fileName, version);
            String fromStr = this.mFromDir.getPath() + File.separator + files[i].getProperty("contextname");
            this.mLog.info("File to be copied is : " + cacheFileName);
            this.mLog.info("Caching : " + fromStr);
            CachedFile file = new CachedFile(fromStr, cacheFileName, maxSize, this);
            file.setCurrent(currentOffset);
            file.addObserver(downloadUpdate);
            try {
                file.init();
                downloadDirectory.addFileVersionInfo(fileName, files[i].getVersion(), true);
                var15_14 = null;
            }
            catch (Throwable throwable) {
                var15_14 = null;
                file.deleteObserver(downloadUpdate);
                throw throwable;
            }
            file.deleteObserver(downloadUpdate);
            currentOffset = file.getCurrent();
        }
        this.mInstallerPanel.setProgressMaximum();
        this.mInstallerPanel.setProgressLabel("");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            this.mLog.warn("Sleep before showing Cisco logo disrupted", ex);
        }
        this.mInstallerPanel.showCiscoLogo();
    }

    public void copyFile(String from, String to, IProgressObserver observer) throws IOException {
        InstallerUtil.copyFile(from, to, observer);
    }
}

