/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.INEVersion;
import com.cisco.hfr.cwi.installer.IVersion;
import com.cisco.hfr.cwi.installer.IncompatibleCWIFileVersionException;
import com.cisco.hfr.cwi.installer.Version;
import java.io.File;

public class NEVersion
extends Version
implements INEVersion {
    private String mNEType = null;

    public NEVersion(String neType, String version, String versionList) {
        super(version);
        this.mNEType = neType;
        if (versionList != null) {
            this.mVersionList = new Version.VersionList(this, versionList, neType);
        }
    }

    public NEVersion(String neType, String version) {
        this(neType, version, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareVersion(IVersion versionObject) throws IncompatibleCWIFileVersionException {
        int localFeatureVersion = this.getFeatureVersion();
        int localMaintenanceVersion = this.getMaintenanceVersion();
        int versionCompareResult = 0;
        if (!(versionObject instanceof INEVersion)) throw new IncompatibleCWIFileVersionException("The object is nota Version object.");
        INEVersion neVersion = (INEVersion)versionObject;
        if (!this.mNEType.equals(neVersion.getNEType())) throw new IncompatibleCWIFileVersionException("Compatible NE version object not found");
        int featureVersion = versionObject.getFeatureVersion();
        int maintenanceVersion = versionObject.getMaintenanceVersion();
        if (localFeatureVersion == featureVersion) {
            if (localMaintenanceVersion > maintenanceVersion) {
                return 1;
            }
            if (localMaintenanceVersion >= maintenanceVersion) return versionCompareResult;
            return -1;
        }
        if (localFeatureVersion <= featureVersion) return -1;
        return 1;
    }

    public String toString() {
        return this.mNEType + File.separator + this.getVersionStringWithoutNE();
    }

    public String getNEType() {
        return this.mNEType;
    }

    public String getVersionStringWithoutNE() {
        return this.getFeatureVersion() + "." + this.getMaintenanceVersion();
    }
}

