/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.cwi.installer;

import com.cisco.hfr.cwi.installer.INEVersion;
import com.cisco.hfr.cwi.installer.IVersion;
import com.cisco.hfr.cwi.installer.IVersionList;
import com.cisco.hfr.cwi.installer.IncompatibleCWIFileVersionException;
import com.cisco.hfr.cwi.installer.IncompatibleVersionListException;
import com.cisco.hfr.cwi.installer.IncompatibleVersionStringException;
import com.cisco.hfr.cwi.installer.NEVersion;
import com.cisco.hfr.cwi.installer.VersionFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Version
implements IVersion {
    private Log mLog = LogFactory.getLog(Version.class);
    private int mFeatureVersion = 0;
    private int mMaintenanceVersion = 0;
    protected IVersionList mVersionList = null;

    public Version(String version, String versionList) {
        int index = version.indexOf(".");
        try {
            this.mFeatureVersion = Integer.parseInt(version.substring(0, index));
            this.mMaintenanceVersion = Integer.parseInt(version.substring(index + 1));
        }
        catch (NumberFormatException e) {
            this.mLog.warn("Version : " + version + " is not integral");
        }
        if (versionList != null) {
            this.mVersionList = new VersionList(versionList);
        }
    }

    public Version(String version) {
        this(version, null);
    }

    public int getFeatureVersion() {
        return this.mFeatureVersion;
    }

    public int getMaintenanceVersion() {
        return this.mMaintenanceVersion;
    }

    public int compareVersion(IVersion versionObject) throws IncompatibleCWIFileVersionException {
        int versionCompareResult = 0;
        if (versionObject instanceof IVersion) {
            int featureVersion = versionObject.getFeatureVersion();
            int maintenanceVersion = versionObject.getMaintenanceVersion();
            if (this.mFeatureVersion == featureVersion) {
                if (this.mMaintenanceVersion > maintenanceVersion) {
                    versionCompareResult = 1;
                } else if (this.mMaintenanceVersion < maintenanceVersion) {
                    versionCompareResult = -1;
                }
            } else {
                versionCompareResult = this.mFeatureVersion > featureVersion ? 1 : -1;
            }
        } else {
            throw new IncompatibleCWIFileVersionException("The object is nota Version object.");
        }
        return versionCompareResult;
    }

    public IVersionList getBackwardCompatibleVersionList() {
        return this.mVersionList;
    }

    public String toString() {
        return String.valueOf(this.mFeatureVersion) + "." + String.valueOf(this.mMaintenanceVersion);
    }

    public class VersionList
    implements IVersionList {
        HashMap mLowerRanges = new HashMap();
        HashMap mHigherRanges = new HashMap();
        HashSet mSingleVersions = new HashSet();
        String mNEType = null;
        String mVersionList = null;

        public VersionList(String versionListString) {
            this(versionListString, null);
        }

        public VersionList(String versionListString, String neType) {
            this.mVersionList = versionListString;
            this.mNEType = neType;
            try {
                StringTokenizer tokenizer1 = new StringTokenizer(versionListString, ",");
                while (tokenizer1.hasMoreTokens()) {
                    String token = tokenizer1.nextToken();
                    if (token.indexOf("-") == -1) {
                        this.mSingleVersions.add(token);
                        continue;
                    }
                    StringTokenizer tokenizer2 = new StringTokenizer(token, "-");
                    String token1 = tokenizer2.nextToken();
                    String token2 = tokenizer2.nextToken();
                    IVersion version1 = VersionFactory.instance().getVersion(token1);
                    IVersion version2 = VersionFactory.instance().getVersion(token2);
                    if (version2.compareVersion(version1) >= 0) {
                        this.mHigherRanges.put(token2, token1);
                        continue;
                    }
                    this.mLowerRanges.put(token2, token1);
                }
            }
            catch (IncompatibleVersionStringException ex) {
                Version.this.mLog.warn("IncompatibleVersionStringException occurred during initialization of VersionList ", ex);
            }
            catch (IncompatibleVersionListException ex) {
                Version.this.mLog.warn("IncompatibleVersionListException occurred during initialization of VersionList ", ex);
            }
            catch (IncompatibleCWIFileVersionException ex) {
                Version.this.mLog.warn("IncompatibleCWIFileVersionException occurred during initialization of VersionList ", ex);
            }
        }

        public boolean contains(IVersion version) throws IncompatibleCWIFileVersionException, IncompatibleVersionStringException, IncompatibleVersionListException {
            boolean isContains = false;
            String versionString = null;
            if (this.mNEType != null && version instanceof INEVersion && this.mNEType.equals(((INEVersion)version).getNEType())) {
                NEVersion neVersionObj = (NEVersion)version;
                versionString = neVersionObj.getVersionStringWithoutNE();
            } else if (this.mNEType == null && version instanceof IVersion) {
                versionString = ((Object)version).toString();
            } else {
                throw new IncompatibleCWIFileVersionException("Compatible NE version object not found");
            }
            if (this.mSingleVersions.contains(versionString) || this.mHigherRanges.get(versionString) != null || this.mLowerRanges.get(versionString) != null) {
                isContains = true;
            } else {
                IVersion versionObj = VersionFactory.instance().getVersion(versionString);
                Set higherSet = this.mHigherRanges.keySet();
                for (String higherVersion : higherSet) {
                    IVersion higherVersionObj = VersionFactory.instance().getVersion(higherVersion);
                    if (higherVersionObj.compareVersion(versionObj) != 1) continue;
                    String lowerVersion = (String)this.mHigherRanges.get(higherVersion);
                    IVersion lowerVersionObj = VersionFactory.instance().getVersion(lowerVersion);
                    if (lowerVersionObj.compareVersion(versionObj) != -1 || !this.isSameRangeType(higherVersionObj, lowerVersionObj, versionObj)) continue;
                    isContains = true;
                    break;
                }
            }
            return isContains;
        }

        private boolean isSameRangeType(IVersion higherVersionObj, IVersion lowerVersionObj, IVersion versionObj) {
            return higherVersionObj.getFeatureVersion() == lowerVersionObj.getFeatureVersion() && higherVersionObj.getFeatureVersion() == versionObj.getFeatureVersion() || higherVersionObj.getMaintenanceVersion() == lowerVersionObj.getMaintenanceVersion() && higherVersionObj.getMaintenanceVersion() == versionObj.getMaintenanceVersion();
        }

        public String toString() {
            return this.mVersionList;
        }
    }
}

