/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.mgbl.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import sun.misc.HexDumpEncoder;

public class CertificateViewerDialog
extends JDialog {
    private static final String DIALOG_TITLE = "CWI - Certificate Details";
    private static final String DEFAULT_FONT_NAME = "Monospaced";
    private static final int DEFAULT_FONT_STYLE = 0;
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final Color DEFAULT_BG_COLOR = Color.white;
    private static final String DISPLAY_NAME = "Display String";
    private static final String VERSION = "Version";
    private static final String SERIAL_NUMBER = "Serial Number";
    private static final String ALGORITHM = "Signature Algorithm";
    private static final String ISSUER = "Issuer";
    private static final String EFFECTIVE_DATE = "Effective Date";
    private static final String EXPIRATION_DATE = "Expiration Date";
    private static final String SUBJECT = "Subject";
    private static final String SIGNATURE = "Signature";
    private JScrollPane mTableScrollPane = new JScrollPane();
    private JScrollPane mListScrollPane = new JScrollPane();
    private JScrollPane mTextScrollPane = new JScrollPane();
    private JButton mCloseButton = new JButton();
    private JList mCertificateList = new JList();
    private JTable mPropertiesTable = new JTable();
    private JTextArea mValueTextArea = new JTextArea();
    private JPanel mMainPanel = new JPanel();
    private JPanel mButtonPanel = new JPanel();
    private JSplitPane mSplitPane = null;
    private HashMap[] mCertificateData = null;
    private int mSelectedRow = 0;

    public CertificateViewerDialog(Frame parent, X509Certificate[] certificates) throws Exception {
        super(parent, DIALOG_TITLE, true);
        this.initializeCertificates(certificates);
        this.initializeUI();
    }

    private void initializeCertificates(X509Certificate[] certificates) throws Exception {
        if (certificates == null || certificates.length == 0) {
            throw new Exception("No Certificates Retrieved");
        }
        this.mCertificateData = new HashMap[certificates.length];
        for (int i = 0; i < certificates.length; ++i) {
            this.mCertificateData[i] = new HashMap();
            this.mCertificateData[i].put(DISPLAY_NAME, ((Object)certificates[i].getIssuerDN()).toString());
            this.mCertificateData[i].put(VERSION, new Integer(certificates[i].getVersion()).toString());
            this.mCertificateData[i].put(SERIAL_NUMBER, certificates[i].getSerialNumber().toString());
            this.mCertificateData[i].put(ALGORITHM, certificates[i].getSigAlgName());
            this.mCertificateData[i].put(ISSUER, ((Object)certificates[i].getIssuerDN()).toString());
            this.mCertificateData[i].put(EFFECTIVE_DATE, certificates[i].getNotBefore().toString());
            this.mCertificateData[i].put(EXPIRATION_DATE, certificates[i].getNotAfter().toString());
            this.mCertificateData[i].put(SUBJECT, ((Object)certificates[i].getSubjectDN()).toString());
            this.mCertificateData[i].put(SIGNATURE, new HexDumpEncoder().encode(certificates[i].getSignature()));
        }
    }

    private void initializeUI() throws Exception {
        this.mPropertiesTable.setBackground(DEFAULT_BG_COLOR);
        this.mPropertiesTable.setBackground(DEFAULT_BG_COLOR);
        this.mValueTextArea.setBackground(DEFAULT_BG_COLOR);
        this.mTableScrollPane.setBackground(DEFAULT_BG_COLOR);
        this.mListScrollPane.setBackground(DEFAULT_BG_COLOR);
        this.mTextScrollPane.setBackground(DEFAULT_BG_COLOR);
        this.setSize(new Dimension(700, 400));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                CertificateViewerDialog.this.dispose();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.mMainPanel.setLayout(new BorderLayout());
        this.mButtonPanel.setLayout(new FlowLayout(2));
        this.mCloseButton.setText("Close");
        this.mCloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CertificateViewerDialog.this.dispose();
            }
        });
        this.mButtonPanel.add(this.mCloseButton);
        this.mValueTextArea.setWrapStyleWord(true);
        this.mValueTextArea.setLineWrap(true);
        this.mValueTextArea.setEditable(false);
        this.mValueTextArea.setFont(new Font(DEFAULT_FONT_NAME, 0, 12));
        this.mValueTextArea.setMinimumSize(new Dimension(530, 165));
        this.mTableScrollPane.getViewport().add((Component)this.mPropertiesTable, null);
        this.mListScrollPane.setHorizontalScrollBarPolicy(30);
        this.mListScrollPane.setViewportView(this.mCertificateList);
        this.mTextScrollPane.setViewportView(this.mValueTextArea);
        this.mPropertiesTable.setCellSelectionEnabled(false);
        this.mPropertiesTable.setRowSelectionAllowed(true);
        this.mPropertiesTable.setSelectionMode(0);
        this.mPropertiesTable.getSelectionModel().setSelectionInterval(0, 0);
        this.mPropertiesTable.setAutoResizeMode(3);
        this.mPropertiesTable.setModel(new CertificatePropertiesModel());
        this.mPropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CertificateViewerDialog.this.tableSelectionChanged(evt);
            }
        });
        this.mPropertiesTable.setMinimumSize(new Dimension(530, 150));
        this.mPropertiesTable.getColumnModel().getColumn(0).setMaxWidth(150);
        this.mPropertiesTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.mCertificateList.setSelectedIndex(0);
        this.mCertificateList.setPreferredSize(new Dimension(150, 100));
        this.mCertificateList.setSelectionMode(0);
        this.mCertificateList.setModel(this.getListModel());
        this.mCertificateList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CertificateViewerDialog.this.certificateListSelectionChanged(evt);
            }
        });
        this.mSplitPane = new JSplitPane(0);
        this.mSplitPane.setTopComponent(this.mTableScrollPane);
        this.mSplitPane.setBottomComponent(this.mTextScrollPane);
        this.mSplitPane.setDividerLocation(153);
        this.mMainPanel.add((Component)this.mSplitPane, "Center");
        this.mMainPanel.add((Component)this.mListScrollPane, "West");
        contentPane.add((Component)this.mMainPanel, "Center");
        contentPane.add((Component)this.mButtonPanel, "South");
        this.setResizable(false);
    }

    private DefaultListModel getListModel() {
        DefaultListModel listModel = new DefaultListModel();
        for (int i = 0; i < this.mCertificateData.length; ++i) {
            listModel.addElement(this.mCertificateData[i].get(DISPLAY_NAME));
        }
        return listModel;
    }

    private void certificateListSelectionChanged(ListSelectionEvent evt) {
        int selectedRow = this.mCertificateList.getSelectedIndex();
        if (selectedRow >= 0) {
            this.mSelectedRow = selectedRow;
            this.mPropertiesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void tableSelectionChanged(ListSelectionEvent evt) {
        int selectedRow = this.mPropertiesTable.getSelectedRow();
        this.mValueTextArea.setText(this.mPropertiesTable.getValueAt(selectedRow, 1).toString());
    }

    public void show() {
        super.setLocationRelativeTo(this.getParent());
        super.show();
    }

    class CertificatePropertiesModel
    extends AbstractTableModel {
        private static final int COLUMN_NAME_NAME_INDEX = 0;
        private static final int COLUMN_NAME_VALUE_INDEX = 1;
        private String[] COLUMN_NAMES = new String[]{"Property Name", "Value"};
        private String[] PROPERTIES = new String[]{"Version", "Serial Number", "Signature Algorithm", "Issuer", "Effective Date", "Expiration Date", "Subject", "Signature"};

        CertificatePropertiesModel() {
        }

        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public int getRowCount() {
            return this.PROPERTIES.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.PROPERTIES[rowIndex];
                }
            }
            return CertificateViewerDialog.this.mCertificateData[CertificateViewerDialog.this.mSelectedRow].get(this.PROPERTIES[rowIndex]);
        }
    }
}

