/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.hfr.mgbl.security;

import com.cisco.hfr.mgbl.security.CertificateViewerDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;

public class VerifyCertificateDialog
extends JDialog {
    public static final int GRANT_NO = 0;
    public static final int GRANT_YES = 1;
    public static final int GRANT_ALWAYS = 2;
    private X509Certificate[] mCertificates = null;
    private int mSelectedOption = 0;
    private JFrame mParent = null;
    private JButton mNoButton = new JButton();
    private JButton mYesButton = new JButton();
    private JButton mAlwaysButton = new JButton();
    private JButton mViewButton = new JButton();
    private JLabel mMessageLabel = new JLabel();
    private JPanel mMainPanel = new JPanel();
    private JPanel mButtonPanel = new JPanel();

    public VerifyCertificateDialog(JFrame parent, boolean modal, X509Certificate[] certificates) {
        super((Frame)parent, modal);
        this.mParent = parent;
        this.mCertificates = certificates;
        this.initializeUI();
    }

    private void initializeUI() {
        this.setTitle("CWI - Verify Certificate");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                VerifyCertificateDialog.this.mSelectedOption = 0;
                VerifyCertificateDialog.this.dispose();
            }
        });
        this.mMainPanel.setLayout(new BorderLayout());
        this.mMainPanel.setBorder(new CompoundBorder(new SoftBevelBorder(0), new LineBorder(new Color(204, 204, 204), 10)));
        this.mMessageLabel.setText(this.createText());
        this.mMainPanel.add((Component)this.mMessageLabel, "Center");
        this.mButtonPanel.setLayout(new FlowLayout(2));
        this.mYesButton.setText("Yes");
        this.mYesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerifyCertificateDialog.this.mSelectedOption = 1;
                VerifyCertificateDialog.this.dispose();
            }
        });
        this.mButtonPanel.add(this.mYesButton);
        this.mNoButton.setText("No");
        this.mNoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerifyCertificateDialog.this.mSelectedOption = 0;
                VerifyCertificateDialog.this.dispose();
            }
        });
        this.mButtonPanel.add(this.mNoButton);
        this.mAlwaysButton.setText("Always");
        this.mAlwaysButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VerifyCertificateDialog.this.mSelectedOption = 2;
                VerifyCertificateDialog.this.dispose();
            }
        });
        this.mButtonPanel.add(this.mAlwaysButton);
        this.mViewButton.setText("View Certificate...");
        this.mViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    new CertificateViewerDialog((Frame)VerifyCertificateDialog.this.mParent, VerifyCertificateDialog.this.mCertificates).show();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mButtonPanel.add(this.mViewButton);
        this.getContentPane().add((Component)this.mMainPanel, "Center");
        this.getContentPane().add((Component)this.mButtonPanel, "South");
        this.setSize(400, 200);
        this.setResizable(false);
        this.pack();
    }

    private String createText() {
        String hostName = "Unknown host";
        String companyName = "Unknown Company";
        String dn = ((Object)this.mCertificates[0].getSubjectDN()).toString();
        StringTokenizer tokenizer = new StringTokenizer(dn, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.startsWith("CN=")) {
                hostName = token.substring(3);
                continue;
            }
            if (!token.startsWith("O=")) continue;
            companyName = token.substring(2);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>Do you want to accept the certificate from the web site \"").append(hostName).append("\" for the purpose of <br>exchanging encrypted information?").append("<p><p>").append("Publisher authenticity verified by: \"").append(companyName).append("\"<p><p>").append("Caution: \"").append(hostName).append("\"").append("asserts that this content is safe. You should only accept this content").append("<br>").append("if you trust \"").append(hostName).append("\" to make that assertion.").append("<p>").append("</html>");
        return buffer.toString();
    }

    public int getSelectedOption() {
        return this.mSelectedOption;
    }

    public void show() {
        super.setLocationRelativeTo(this.getParent());
        super.show();
    }
}

