/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AuthorizedKeys;
import com.sshtools.common.automate.AuthorizedKeysFileLoader;
import com.sshtools.common.automate.AuthorizedKeysFileSaver;
import com.sshtools.common.automate.AuthorizedKeysFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;

public class OpenSSHAuthorizedKeysFormat
implements AuthorizedKeysFormat {
    public byte[] format(AuthorizedKeys keys, AuthorizedKeysFileSaver saver) throws IOException, InvalidSshKeyException {
        throw new UnsupportedOperationException("The OpenSSH authorized key file does not support additional key files!");
    }

    public AuthorizedKeys unformat(byte[] formatted, AuthorizedKeysFileLoader loader) throws IOException, InvalidSshKeyException {
        throw new UnsupportedOperationException("The OpenSSH authorized key file does not support additional key files!");
    }

    public byte[] format(AuthorizedKeys keys) throws IOException, InvalidSshKeyException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OpenSSHPublicKeyFormat openssh = new OpenSSHPublicKeyFormat();
        Iterator it = keys.getAuthorizedKeys().entrySet().iterator();
        while (it != null && it.hasNext()) {
            Map.Entry entry = it.next();
            openssh.setComment((String)entry.getValue());
            SshPublicKeyFile pubfile = SshPublicKeyFile.create((SshPublicKey)entry.getKey(), openssh);
            out.write(pubfile.toString().getBytes("US-ASCII"));
            out.write(10);
        }
        return out.toByteArray();
    }

    public AuthorizedKeys unformat(byte[] formatted) throws IOException, InvalidSshKeyException {
        String line;
        AuthorizedKeys keys = new AuthorizedKeys();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(formatted)));
        while ((line = reader.readLine()) != null) {
            SshPublicKeyFile pubfile = SshPublicKeyFile.parse(line.getBytes("US-ASCII"));
            keys.addKey(pubfile.getComment(), pubfile.toPublicKey());
        }
        return keys;
    }

    public boolean requiresKeyFiles() {
        return false;
    }
}

