/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AuthorizedKeys;
import com.sshtools.common.automate.AuthorizedKeysFileLoader;
import com.sshtools.common.automate.AuthorizedKeysFileSaver;
import com.sshtools.common.automate.AuthorizedKeysFormat;
import com.sshtools.common.automate.RemoteIdentificationException;
import com.sshtools.common.automate.RemoteIdentificationRule;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteIdentification {
    public static final int ADD_AUTHORIZEDKEY = 1;
    public static final int REMOVE_AUTHORIZEDKEY = 2;
    private String defaultName;
    private Vector rules = new Vector();
    private Class authorizedKeysFormat;
    private String defaultPath;
    protected Log log = LogFactory.getLog(RemoteIdentification.class);

    public RemoteIdentification(String defaultName) {
        this.defaultName = defaultName;
    }

    protected List getRules() {
        return this.rules;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getName(String ident) throws RemoteIdentificationException {
        RemoteIdentificationRule rule;
        boolean pass = false;
        Iterator it = this.rules.iterator();
        Vector<RemoteIdentificationRule> passed = new Vector<RemoteIdentificationRule>();
        Object rulename = null;
        while (it.hasNext()) {
            rule = (RemoteIdentificationRule)it.next();
            if (!rule.testRule(ident)) continue;
            passed.add(rule);
        }
        if (passed.size() > 0) {
            it = passed.iterator();
            RemoteIdentificationRule ret = null;
            while (it.hasNext()) {
                rule = (RemoteIdentificationRule)it.next();
                if (ret == null) {
                    ret = rule;
                    continue;
                }
                if (rule.getPriority() >= ret.getPriority()) continue;
                ret = rule;
            }
            if (ret.getName() != null) {
                return ret.getName();
            }
            return this.defaultName;
        }
        throw new RemoteIdentificationException("No rules exist to identify the remote host with ident string " + ident);
    }

    protected void addRule(RemoteIdentificationRule rule) {
        this.rules.add(rule);
    }

    protected boolean testRules(String ident) {
        boolean pass = false;
        Iterator it = this.rules.iterator();
        while (it.hasNext() && !pass) {
            RemoteIdentificationRule rule = (RemoteIdentificationRule)it.next();
            pass = rule.testRule(ident);
        }
        return pass;
    }

    protected void setAuthorizedKeysFormat(Class implementationClass) {
        this.authorizedKeysFormat = implementationClass;
    }

    protected void setAuthorizedKeysDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    public String getAuthorizedKeysDefaultPath() {
        return this.defaultPath;
    }

    public AuthorizedKeysFormat getAuthorizedKeysFormat() throws RemoteIdentificationException {
        try {
            if (this.authorizedKeysFormat != null) {
                return (AuthorizedKeysFormat)this.authorizedKeysFormat.newInstance();
            }
            throw new RemoteIdentificationException("There is no authorized keys format set for this remote id");
        }
        catch (Exception ex) {
            throw new RemoteIdentificationException("Failed to instansiate " + this.authorizedKeysFormat.getName());
        }
    }

    public boolean configureUserAccess(SftpClient sftp, String serverId, String system, String username, SshPublicKey pk, String authorizationFile, int mode) throws RemoteIdentificationException {
        Vector<SshPublicKey> keys = new Vector<SshPublicKey>();
        keys.add(pk);
        return this.configureUserAccess(sftp, serverId, system, username, keys, authorizationFile, mode);
    }

    public boolean configureUserAccess(final SftpClient sftp, String serverId, String system, String username, List keys, String authorizationFile, int mode) throws RemoteIdentificationException {
        try {
            AuthorizedKeys authorizedKeys;
            if (sftp.isClosed()) {
                throw new RemoteIdentificationException("SFTP connection must be open");
            }
            if (authorizationFile == null) {
                throw new RemoteIdentificationException("authorization file cannot be null");
            }
            if (mode != 1 && mode != 2) {
                throw new RemoteIdentificationException("Invalid configuration mode specifed in call to configureUserAccess");
            }
            authorizationFile.replace('\\', '/');
            final String directory = authorizationFile.lastIndexOf("/") > 0 ? authorizationFile.substring(0, authorizationFile.lastIndexOf("/") + 1) : "";
            try {
                try {
                    sftp.rm(authorizationFile + ".bak");
                }
                catch (IOException ex) {
                    // empty catch block
                }
                sftp.rename(authorizationFile, authorizationFile + ".bak");
                this.log.info("Opening existing authorized keys file from " + authorizationFile + ".bak");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                sftp.get(authorizationFile + ".bak", out);
                byte[] backup = out.toByteArray();
                out.close();
                this.log.info("Parsing authorized keys file");
                authorizedKeys = AuthorizedKeys.parse(backup, serverId, system, new AuthorizedKeysFileLoader(){

                    public byte[] loadFile(String filename) throws IOException {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        sftp.get(directory + filename, out);
                        out.close();
                        return out.toByteArray();
                    }
                });
            }
            catch (IOException ioe) {
                authorizedKeys = new AuthorizedKeys();
            }
            catch (RemoteIdentificationException rie) {
                throw new RemoteIdentificationException("Open3SP cannot identify the remote host.\nPlease email support@open3sp.org with specifying 'remote identification' in the subject and supplying the server type and the follwing data '" + serverId + "'");
            }
            this.log.info("Updating authorized keys file");
            for (SshPublicKey pk : keys) {
                if (!authorizedKeys.containsKey(pk) && mode == 1) {
                    authorizedKeys.addKey(username, pk);
                    continue;
                }
                if (!authorizedKeys.containsKey(pk) || mode != 2) continue;
                authorizedKeys.removeKey(pk);
            }
            this.log.info("Verifying directory " + directory);
            int umask = sftp.umask(18);
            sftp.mkdirs(directory);
            this.log.info("Writing new authorized keys file to " + authorizationFile);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(AuthorizedKeys.create(authorizedKeys, serverId, system, new AuthorizedKeysFileSaver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void saveFile(String filename, byte[] filedata) throws IOException {
                    ByteArrayInputStream in = null;
                    try {
                        try {
                            in = new ByteArrayInputStream(filedata);
                            sftp.put(in, directory + filename);
                        }
                        catch (IOException ex) {
                            RemoteIdentification.this.log.info("Error writing public key file to server" + filename, ex);
                            Object var6_5 = null;
                            if (in == null) return;
                            in.close();
                            return;
                        }
                        Object var6_4 = null;
                        if (in == null) return;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
            }));
            out.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            sftp.umask(91);
            sftp.put(in, authorizationFile);
            sftp.umask(umask);
            return true;
        }
        catch (IOException ioe) {
            throw new RemoteIdentificationException(ioe.getMessage());
        }
        catch (RemoteIdentificationException rie) {
            throw new RemoteIdentificationException("SSHTools cannot identify the remote host.\nPlease email support@sshtools.com specifying 'remote identification' in the subject, supplying the server type and the following data: '" + serverId + "'");
        }
    }
}

