/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.hosts;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractHostKeyVerification
extends DefaultHandler
implements HostKeyVerification {
    private static String defaultHostFile;
    private static Log log;
    private List deniedHosts;
    private Map allowedHosts;
    private String hostFile;
    private boolean hostFileWriteable;
    private boolean expectEndElement;
    private String currentElement;

    public AbstractHostKeyVerification() throws InvalidHostFileException {
        this(defaultHostFile);
        this.hostFile = defaultHostFile;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractHostKeyVerification(String hostFileName) throws InvalidHostFileException {
        InputStream in;
        block16: {
            File f;
            this.deniedHosts = new ArrayList();
            this.allowedHosts = new HashMap();
            this.expectEndElement = false;
            this.currentElement = null;
            in = null;
            if (hostFileName == null) break block16;
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission(hostFileName, "read"));
            }
            if ((f = new File(hostFileName)).exists()) {
                in = new FileInputStream(f);
                this.hostFile = hostFileName;
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = saxFactory.newSAXParser();
                saxParser.parse(in, (DefaultHandler)this);
                this.hostFileWriteable = f.canWrite();
            } else if (f.createNewFile()) {
                FileOutputStream out = new FileOutputStream(f);
                out.write(this.toString().getBytes());
                out.close();
                this.hostFileWriteable = true;
            } else {
                this.hostFileWriteable = false;
            }
            if (this.hostFileWriteable) break block16;
            log.warn("Host file is not writeable.");
        }
        Object var7_11 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (AccessControlException ace) {
                log.warn("Not enough permission to load a hosts file, so just creating an empty list");
                Object var7_12 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
            catch (IOException ioe) {
                throw new InvalidHostFileException("Could not open or read " + hostFileName);
            }
            catch (SAXException sax) {
                throw new InvalidHostFileException("Failed XML parsing: " + sax.getMessage());
            }
            catch (ParserConfigurationException pce) {
                throw new InvalidHostFileException("Failed to initialize xml parser: " + pce.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        if (this.currentElement == null) {
            if (!qname.equals("HostAuthorizations")) throw new SAXException("Unexpected document element!");
            this.allowedHosts.clear();
            this.deniedHosts.clear();
            this.currentElement = qname;
            return;
        } else {
            if (!this.currentElement.equals("HostAuthorizations")) {
                throw new SAXException("Unexpected parent element found!");
            }
            if (qname.equals("AllowHost")) {
                String hostname = attrs.getValue("HostName");
                String fingerprint = attrs.getValue("Fingerprint");
                if (hostname == null || fingerprint == null) throw new SAXException("Requried attribute(s) missing!");
                if (log.isDebugEnabled()) {
                    log.debug("AllowHost element for host '" + hostname + "' with fingerprint '" + fingerprint + "'");
                }
                this.allowedHosts.put(hostname, fingerprint);
                this.currentElement = qname;
                return;
            } else if (qname.equals("DenyHost")) {
                String hostname = attrs.getValue("HostName");
                if (hostname == null) throw new SAXException("Required attribute hostname missing");
                if (log.isDebugEnabled()) {
                    log.debug("DenyHost element for host " + hostname);
                }
                this.deniedHosts.add(hostname);
                this.currentElement = qname;
                return;
            } else {
                log.warn("Unexpected " + qname + " element found in allowed hosts file");
            }
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.currentElement == null) {
            throw new SAXException("Unexpected end element found!");
        }
        if (this.currentElement.equals("HostAuthorizations")) {
            this.currentElement = null;
            return;
        }
        if (this.currentElement.equals("AllowHost")) {
            this.currentElement = "HostAuthorizations";
            return;
        }
        if (this.currentElement.equals("DenyHost")) {
            this.currentElement = "HostAuthorizations";
            return;
        }
    }

    public boolean isHostFileWriteable() {
        return this.hostFileWriteable;
    }

    public abstract void onDeniedHost(String var1) throws TransportProtocolException;

    public abstract void onHostKeyMismatch(String var1, String var2, String var3) throws TransportProtocolException;

    public abstract void onUnknownHost(String var1, String var2) throws TransportProtocolException;

    public void allowHost(String host, String hostKeyFingerprint, boolean always) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug("Allowing " + host + " with fingerprint " + hostKeyFingerprint);
        }
        this.allowedHosts.put(host, hostKeyFingerprint);
        if (always) {
            this.saveHostFile();
        }
    }

    public Map allowedHosts() {
        return this.allowedHosts;
    }

    public List deniedHosts() {
        return this.deniedHosts;
    }

    public void removeAllowedHost(String host) {
        this.allowedHosts.remove(host);
    }

    public void removeDeniedHost(String host) {
        for (int i = this.deniedHosts.size() - 1; i >= 0; --i) {
            String h = (String)this.deniedHosts.get(i);
            if (!h.equals(host)) continue;
            this.deniedHosts.remove(i);
        }
    }

    public void denyHost(String host, boolean always) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug(host + " is denied access");
        }
        if (!this.deniedHosts.contains(host)) {
            this.deniedHosts.add(host);
        }
        if (always) {
            this.saveHostFile();
        }
    }

    public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
        String fingerprint = pk.getFingerprint();
        log.info("Verifying " + host + " host key");
        if (log.isDebugEnabled()) {
            log.debug("Fingerprint: " + fingerprint);
        }
        if (this.deniedHosts.contains(host)) {
            this.onDeniedHost(host);
            return false;
        }
        if (this.allowedHosts.containsKey(host)) {
            String currentFingerprint = (String)this.allowedHosts.get(host);
            if (currentFingerprint.compareToIgnoreCase(fingerprint) == 0) {
                return true;
            }
            this.onHostKeyMismatch(host, currentFingerprint, fingerprint);
            return this.checkFingerprint(host, fingerprint);
        }
        this.onUnknownHost(host, fingerprint);
        return this.checkFingerprint(host, fingerprint);
    }

    private boolean checkFingerprint(String host, String fingerprint) {
        String currentFingerprint = (String)this.allowedHosts.get(host);
        return currentFingerprint != null && currentFingerprint.compareToIgnoreCase(fingerprint) == 0;
    }

    public void saveHostFile() throws InvalidHostFileException {
        if (!this.hostFileWriteable) {
            throw new InvalidHostFileException("Host file is not writeable.");
        }
        log.info("Saving " + defaultHostFile);
        try {
            File f = new File(this.hostFile);
            FileOutputStream out = new FileOutputStream(f);
            out.write(this.toString().getBytes());
            out.close();
        }
        catch (IOException e) {
            throw new InvalidHostFileException("Could not write to " + this.hostFile);
        }
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<HostAuthorizations>\n";
        xml = xml + "<!-- Host Authorizations file, used by the abstract class HostKeyVerification to verify the servers host key -->";
        xml = xml + "   <!-- Allow the following hosts access if they provide the correct public key -->\n";
        for (Map.Entry entry : this.allowedHosts.entrySet()) {
            xml = xml + "   <AllowHost HostName=\"" + entry.getKey().toString() + "\" Fingerprint=\"" + entry.getValue().toString() + "\"/>\n";
        }
        xml = xml + "   <!-- Deny the following hosts access -->\n";
        Iterator it = this.deniedHosts.iterator();
        while (it.hasNext()) {
            xml = xml + "   <DenyHost HostName=\"" + it.next().toString() + "\"/>\n";
        }
        xml = xml + "</HostAuthorizations>";
        return xml;
    }

    static {
        log = LogFactory.getLog(HostKeyVerification.class);
        log.info("Determining default host file");
        defaultHostFile = ConfigurationLoader.getConfigurationDirectory();
        if (defaultHostFile == null) {
            log.info("No configuration location, persistence of host keys will be disabled.");
        } else {
            defaultHostFile = defaultHostFile + "hosts.xml";
            log.info("Defaulting host file to " + defaultHostFile);
        }
    }
}

