/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.UIUtil;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultilineLabel
extends JPanel {
    private GridBagConstraints constraints = new GridBagConstraints();
    private String text;

    public MultilineLabel() {
        this("");
    }

    public MultilineLabel(String text) {
        super(new GridBagLayout());
        this.constraints.anchor = 18;
        this.constraints.fill = 0;
        this.setText(text);
    }

    public void setFont(Font f) {
        super.setFont(f);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setFont(f);
        }
    }

    public void setText(String text) {
        this.text = text;
        this.removeAll();
        StringTokenizer tok = new StringTokenizer(text, "\n");
        this.constraints.weighty = 0.0;
        this.constraints.weightx = 1.0;
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                this.constraints.weighty = 1.0;
            }
            UIUtil.jGridBagAdd(this, new JLabel(t), this.constraints, 0);
        }
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this.text;
    }
}

