/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JPanel
implements ActionListener,
Runnable {
    protected PrinterJob job;
    protected JButton setup;
    protected JComboBox scale;
    protected int pageWidth;
    protected Printable printable;
    protected PreviewContainer previewer;
    protected PageFormat pageFormat;
    protected int pageHeight;
    protected JScrollPane scrollpane;

    public PrintPreview(Printable printable, PageFormat pageFormat) {
        super(new BorderLayout());
        this.printable = printable;
        this.job = PrinterJob.getPrinterJob();
        this.pageFormat = pageFormat;
        JPanel jpanel = new JPanel(new FlowLayout(0, 2, 2));
        this.setup = new JButton("Setup");
        this.setup.addActionListener(this);
        this.setup.setMnemonic('p');
        jpanel.add(this.setup);
        String[] as = new String[]{"10 %", "25 %", "50 %", "75 %", "100 %", "200 %"};
        this.scale = new JComboBox<String>(as);
        this.scale.setSelectedItem(as[2]);
        this.scale.addActionListener(this);
        this.scale.setEditable(true);
        jpanel.add(this.scale);
        this.add((Component)jpanel, "North");
        this.previewer = new PreviewContainer();
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.pageWidth = (int)pageFormat.getWidth();
        this.pageHeight = (int)pageFormat.getHeight();
        int byte0 = 50;
        int i = this.pageWidth * byte0 / 100;
        int j = this.pageHeight * byte0 / 100;
        int k = 0;
        try {
            while (true) {
                BufferedImage bufferedimage = new BufferedImage(this.pageWidth, this.pageHeight, 1);
                Graphics g = bufferedimage.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.pageWidth, this.pageHeight);
                if (printable.print(g, pageFormat, k) == 0) {
                    PagePreview pagepreview = new PagePreview(i, j, bufferedimage);
                    this.previewer.add(pagepreview);
                    ++k;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException printerexception) {
            printerexception.printStackTrace();
            System.err.println("Printing error: " + printerexception.toString());
        }
        this.scrollpane = new JScrollPane(this.previewer);
        this.add((Component)this.scrollpane, "Center");
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    private void setup() {
        this.pageFormat = this.job.pageDialog(this.pageFormat);
        this.pageWidth = (int)this.pageFormat.getWidth();
        this.pageHeight = (int)this.pageFormat.getHeight();
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        String s = this.scale.getSelectedItem().toString();
        this.scrollpane.setViewportView(new JLabel("Resizing"));
        if (s.endsWith("%")) {
            s = s.substring(0, s.length() - 1);
        }
        s = s.trim();
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException numberformatexception) {
            i = 100;
        }
        int j = this.pageWidth * i / 100;
        int k = this.pageHeight * i / 100;
        Component[] acomponent = this.previewer.getComponents();
        for (int l = 0; l < acomponent.length; ++l) {
            if (!(acomponent[l] instanceof PagePreview)) continue;
            PagePreview pagepreview = (PagePreview)acomponent[l];
            pagepreview.setScaledSize(j, k);
        }
        this.scrollpane.setViewportView(this.previewer);
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.setup) {
            this.setup();
        } else if (actionevent.getSource() == this.scale) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    class PagePreview
    extends JPanel {
        protected int m_h;
        protected int m_w;
        protected Image m_img;
        protected Image m_source;

        public PagePreview(int i, int j, Image image) {
            this.m_w = i;
            this.m_h = j;
            this.m_source = image;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.m_w + insets.left + insets.right, this.m_h + insets.top + insets.bottom);
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(g);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setScaledSize(int i, int j) {
            this.m_w = i;
            this.m_h = j;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int V_GAP = 10;
        protected int H_GAP = 16;

        PreviewContainer() {
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets insets = this.getInsets();
            int i = insets.left + this.H_GAP;
            int j = insets.top + this.V_GAP;
            int k = this.getComponentCount();
            if (k == 0) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int l = dimension.width;
            int i1 = dimension.height;
            Dimension dimension1 = this.getParent().getSize();
            int j1 = Math.max((dimension1.width - this.H_GAP) / (l + this.H_GAP), 1);
            int k1 = k / j1;
            if (k1 * j1 < k) {
                ++k1;
            }
            int l1 = 0;
            for (int i2 = 0; i2 < k1; ++i2) {
                for (int j2 = 0; j2 < j1; ++j2) {
                    if (l1 >= k) {
                        return;
                    }
                    Component component1 = this.getComponent(l1++);
                    component1.setBounds(i, j, l, i1);
                    i += l + this.H_GAP;
                }
                j += i1 + this.V_GAP;
                i = insets.left + this.H_GAP;
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            int i = this.getComponentCount();
            if (i == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int j = dimension.width;
            int k = dimension.height;
            Dimension dimension1 = this.getParent().getSize();
            int l = Math.max((dimension1.width - this.H_GAP) / (j + this.H_GAP), 1);
            int i1 = i / l;
            if (i1 * l < i) {
                ++i1;
            }
            int j1 = l * (j + this.H_GAP) + this.H_GAP;
            int k1 = i1 * (k + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            return new Dimension(j1 + insets.left + insets.right, k1 + insets.top + insets.bottom);
        }
    }
}

