/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.ResourceIcon;

public class SessionProvider {
    String id;
    String name;
    Class cls;
    String description;
    char mnemonic;
    ResourceIcon smallicon;
    ResourceIcon largeicon;
    Class[] propertypages;
    int weight;
    Class optionsClass;

    SessionProvider(String id, String name, Class cls, String description, String mnemonic, String smallicon, String largeicon, Class optionsClass, Class[] propertypages, int weight) {
        this.id = id;
        this.name = name;
        this.cls = cls;
        this.description = description;
        this.mnemonic = mnemonic.charAt(0);
        this.propertypages = propertypages;
        this.optionsClass = optionsClass;
        this.smallicon = new ResourceIcon(cls, smallicon);
        this.largeicon = new ResourceIcon(cls, largeicon);
        this.weight = weight;
    }

    public String getName() {
        return this.name;
    }

    public Class getProviderClass() {
        return this.cls;
    }

    public Class[] getPropertyPages() {
        return this.propertypages;
    }

    public String getDescription() {
        return this.description;
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getId() {
        return this.id;
    }

    public ResourceIcon getSmallIcon() {
        return this.smallicon;
    }

    public ResourceIcon getLargeIcon() {
        return this.largeicon;
    }

    public Class getOptionsClass() {
        return this.optionsClass;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SessionProvider) {
            SessionProvider provider = (SessionProvider)obj;
            return provider.id.equals(this.id) && provider.getProviderClass().equals(this.cls);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

