/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.SessionProvider;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.util.ExtensionClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionProviderFactory {
    private static Log log = LogFactory.getLog(SessionProviderFactory.class);
    private static SessionProviderFactory instance;
    HashMap providers = new HashMap();

    SessionProviderFactory() {
        ExtensionClassLoader classloader = ConfigurationLoader.getExtensionClassLoader();
        try {
            Enumeration<URL> enumer = classloader.getResources("session.provider");
            URL url = null;
            while (enumer.hasMoreElements()) {
                try {
                    String pageclass;
                    url = enumer.nextElement();
                    InputStream in = url.openStream();
                    Properties properties = new Properties();
                    properties.load(in);
                    IOUtil.closeStream(in);
                    if (!properties.containsKey("provider.class") || !properties.containsKey("provider.name")) continue;
                    Class<?> cls = classloader.loadClass(properties.getProperty("provider.class"));
                    String optionsClassName = properties.getProperty("provider.options");
                    Class<?> optionsClass = optionsClassName == null || optionsClassName.equals("") ? null : classloader.loadClass(optionsClassName);
                    int num = 1;
                    Vector pages = new Vector();
                    do {
                        if ((pageclass = properties.getProperty("property.page." + String.valueOf(num), null)) == null) continue;
                        pages.add(classloader.loadClass(pageclass));
                        ++num;
                    } while (pageclass != null);
                    Class[] propertypages = new Class[pages.size()];
                    pages.toArray(propertypages);
                    String name = properties.getProperty("provider.name");
                    int weight = Integer.parseInt(properties.getProperty("provider.weight"));
                    String id = properties.getProperty("provider.id", name);
                    SessionProvider provider = new SessionProvider(id, name, cls, properties.getProperty("provider.shortdesc"), properties.getProperty("provider.mnemonic"), properties.getProperty("provider.smallicon"), properties.getProperty("provider.largeicon"), optionsClass, propertypages, weight);
                    this.providers.put(id, provider);
                    log.info("Installed " + provider.getName() + " session provider");
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Session provider class not found", ex);
                }
                catch (IOException ex) {
                    log.warn("Failed to read " + url.toExternalForm(), ex);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List getSessionProviders() {
        return new Vector(this.providers.values());
    }

    public SessionProvider getProvider(String id) {
        return (SessionProvider)this.providers.get(id);
    }

    public static SessionProviderFactory getInstance() {
        return instance == null ? (instance = new SessionProviderFactory()) : instance;
    }
}

