/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;

public abstract class StandardAction
extends AbstractAction {
    public static final String ON_TOOLBAR = "onToolBar";
    public static final String TOOLBAR_GROUP = "toolBarGroup";
    public static final String TOOLBAR_WEIGHT = "toolBarWeight";
    public static final String ON_MENUBAR = "onMenuBar";
    public static final String MENU_NAME = "menuName";
    public static final String MENU_ITEM_GROUP = "menuItemGroup";
    public static final String MENU_ITEM_WEIGHT = "menuItemWeight";
    public static final String IMAGE_DIR = "/com/sshtools/sshterm/";
    public static final String HIDE_TOOLBAR_TEXT = "hideToolbarText";
    public static final String IS_TOGGLE_BUTTON = "isToggleButton";
    public static final String LARGE_ICON = "LargeIcon";
    public static final String ON_CONTEXT_MENU = "onContextMenu";
    public static final String CONTEXT_MENU_GROUP = "contextMenuGroup";
    public static final String CONTEXT_MENU_WEIGHT = "contextMenuWeight";
    public static final String MENU_ICON = "menuIcon";
    private EventListenerList listeners;

    public String getActionCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    public String getShortDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public String getLongDescription() {
        return (String)this.getValue("LongDescription");
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public String getSmallIcon() {
        return (String)this.getValue("SmallIcon");
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.listeners != null) {
            Object[] listenerList = this.listeners.getListenerList();
            ActionEvent e = new ActionEvent(evt.getSource(), evt.getID(), (String)this.getValue("ActionCommandKey"));
            for (int i = 0; i <= listenerList.length - 2; i += 2) {
                ((ActionListener)listenerList[i + 1]).actionPerformed(e);
            }
        }
    }

    public void addActionListener(ActionListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(ActionListener.class, l);
    }

    public ImageIcon getIcon(String name) {
        String imagePath = name.startsWith("/") ? name : IMAGE_DIR + name;
        URL url = this.getClass().getResource(imagePath);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }
}

