/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

import com.sshtools.common.util.UIDException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.io.ByteArrayInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class UID {
    byte[] uid;

    private UID(String str) throws UIDException {
        if (str == null) {
            throw new UIDException("UID cannot be NULL");
        }
        try {
            this.uid = new byte[str.length() / 2];
            int pos = 0;
            for (int i = 0; i < str.length(); i += 2) {
                String tmp = str.substring(i, i + 2);
                this.uid[pos++] = (byte)Integer.parseInt(tmp, 16);
            }
        }
        catch (NumberFormatException ex) {
            throw new UIDException("Failed to parse UID String: " + ex.getMessage());
        }
    }

    private UID(byte[] uid) {
        this.uid = uid;
    }

    public static UID generateUniqueId(byte[] content) throws UIDException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (content != null) {
                ByteArrayInputStream in = new ByteArrayInputStream(content);
                DigestInputStream dis = new DigestInputStream(in, messageDigest);
                while (dis.read() != -1) {
                }
                dis.close();
                in.close();
            }
            byte[] noise = new byte[1024];
            ConfigurationLoader.getRND().nextBytes(noise);
            messageDigest.update(noise);
            UID uid = new UID(messageDigest.digest());
            return uid;
        }
        catch (Exception ex) {
            throw new UIDException("Failed to generate a unique identifier: " + ex.getMessage());
        }
    }

    public static UID fromString(String uid) throws UIDException {
        return new UID(uid);
    }

    public String toString() {
        StringBuffer checksumSb = new StringBuffer();
        for (int i = 0; i < this.uid.length; ++i) {
            String hexStr = Integer.toHexString(0xFF & this.uid[i]);
            if (hexStr.length() < 2) {
                checksumSb.append("0");
            }
            checksumSb.append(hexStr);
        }
        return checksumSb.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof UID) {
            return Arrays.equals(this.uid, ((UID)obj).uid);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

