/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon;

import com.sshtools.daemon.authentication.AuthenticationProtocolServer;
import com.sshtools.daemon.configuration.PlatformConfiguration;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.transport.TransportProtocolServer;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.net.ConnectedSocketTransportProvider;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolEventAdapter;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshServer {
    private static Log log = LogFactory.getLog(SshServer.class);
    private ConnectionListener listener = null;
    private ServerSocket server = null;
    private boolean shutdown = false;
    private ServerSocket commandServerSocket;
    protected List activeConnections = new Vector();
    Thread thread;

    public SshServer() throws IOException {
        String serverId = System.getProperty("sshtools.serverid");
        if (serverId != null) {
            TransportProtocolServer.SOFTWARE_VERSION_COMMENTS = serverId;
        }
        if (!ConfigurationLoader.isConfigurationAvailable(ServerConfiguration.class)) {
            throw new SshException("Server configuration not available!");
        }
        if (!ConfigurationLoader.isConfigurationAvailable(PlatformConfiguration.class)) {
            throw new SshException("Platform configuration not available");
        }
        if (((ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class)).getServerHostKeys().size() <= 0) {
            throw new SshException("Server cannot start because there are no server host keys available");
        }
    }

    public void startServer() throws IOException {
        log.info("Starting server");
        this.shutdown = false;
        this.startServerSocket();
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    SshServer.this.startCommandSocket();
                }
                catch (IOException ex) {
                    log.info("Failed to start command socket", ex);
                    try {
                        SshServer.this.stopServer("The command socket failed to start");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.thread.start();
    }

    protected void processCommand(int command, Socket client) throws IOException {
        if (command == 58) {
            int len = client.getInputStream().read();
            byte[] msg = new byte[len];
            client.getInputStream().read(msg);
            this.stopServer(new String(msg));
        }
    }

    protected void startCommandSocket() throws IOException {
        block3: {
            try {
                Socket client;
                this.commandServerSocket = new ServerSocket(((ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class)).getCommandPort(), 50, InetAddress.getLocalHost());
                while ((client = this.commandServerSocket.accept()) != null) {
                    log.info("Command request received");
                    this.processCommand(client.getInputStream().read(), client);
                    client.close();
                    if (!this.shutdown) continue;
                }
                this.commandServerSocket.close();
            }
            catch (Exception e) {
                if (this.shutdown) break block3;
                log.fatal("The command socket failed", e);
            }
        }
    }

    protected void startServerSocket() throws IOException {
        this.listener = new ConnectionListener(((ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class)).getListenAddress(), ((ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class)).getPort());
        this.listener.start();
    }

    public void stopServer(String msg) throws IOException {
        log.info("Shutting down server");
        this.shutdown = true;
        log.debug(msg);
        this.shutdown(msg);
        this.listener.stop();
        log.debug("Stopping command server");
        try {
            if (this.commandServerSocket != null) {
                this.commandServerSocket.close();
            }
        }
        catch (IOException ioe) {
            log.error(ioe);
        }
    }

    protected abstract void shutdown(String var1);

    protected abstract void configureServices(ConnectionProtocol var1) throws IOException;

    protected void refuseSession(Socket socket) throws IOException {
        TransportProtocolServer transport = new TransportProtocolServer(true);
        transport.startTransportProtocol(new ConnectedSocketTransportProvider(socket), new SshConnectionProperties());
    }

    protected TransportProtocolServer createSession(Socket socket) throws IOException {
        log.debug("Initializing connection");
        InetAddress address = socket.getInetAddress();
        log.debug("Remote Hostname: " + address.getHostName());
        log.debug("Remote IP: " + address.getHostAddress());
        TransportProtocolServer transport = new TransportProtocolServer();
        AuthenticationProtocolServer authentication = new AuthenticationProtocolServer();
        ConnectionProtocol connection = new ConnectionProtocol();
        this.configureServices(connection);
        authentication.acceptService(connection);
        transport.acceptService(authentication);
        transport.startTransportProtocol(new ConnectedSocketTransportProvider(socket), new SshConnectionProperties());
        return transport;
    }

    class ConnectionListener
    implements Runnable {
        private Log log = LogFactory.getLog(ConnectionListener.class);
        private ServerSocket server;
        private String listenAddress;
        private Thread thread;
        private int maxConnections;
        private int port;
        private StartStopState state = new StartStopState(2);

        public ConnectionListener(String listenAddress, int port) {
            this.port = port;
            this.listenAddress = listenAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    block12: {
                        this.log.debug("Starting connection listener thread");
                        this.state.setValue(1);
                        this.server = new ServerSocket(this.port);
                        this.maxConnections = ((ServerConfiguration)ConfigurationLoader.getConfiguration(ServerConfiguration.class)).getMaxConnections();
                        boolean refuse = false;
                        TransportProtocolEventAdapter eventHandler = new TransportProtocolEventAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onDisconnect(TransportProtocol transport) {
                                if (ConnectionListener.this.state.getValue() != 2) {
                                    List list = SshServer.this.activeConnections;
                                    synchronized (list) {
                                        ConnectionListener.this.log.info(transport.getUnderlyingProviderDetail() + " connection closed");
                                        SshServer.this.activeConnections.remove(transport);
                                    }
                                }
                            }
                        };
                        try {
                            Socket socket;
                            while ((socket = this.server.accept()) != null && this.state.getValue() == 1) {
                                this.log.debug("New connection requested");
                                if (this.maxConnections < SshServer.this.activeConnections.size()) {
                                    SshServer.this.refuseSession(socket);
                                    continue;
                                }
                                TransportProtocolServer transport = SshServer.this.createSession(socket);
                                this.log.info("Monitoring active session from " + socket.getInetAddress().getHostName());
                                List list = SshServer.this.activeConnections;
                                synchronized (list) {
                                    SshServer.this.activeConnections.add(transport);
                                }
                                transport.addEventHandler(eventHandler);
                            }
                        }
                        catch (IOException ex) {
                            if (this.state.getValue() == 2) break block12;
                            this.log.info("The server was shutdown unexpectedly", ex);
                        }
                    }
                    this.state.setValue(2);
                    this.log.info("Disconnecting active sessions");
                    Iterator it = SshServer.this.activeConnections.iterator();
                    while (it.hasNext()) {
                        ((TransportProtocolServer)it.next()).disconnect("The server is shuting down");
                    }
                    SshServer.this.listener = null;
                    this.log.info("Exiting connection listener thread");
                }
                catch (IOException ex) {
                    this.log.info("The server thread failed", ex);
                    Object var8_10 = null;
                    this.thread = null;
                }
                Object var8_9 = null;
                this.thread = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.thread = null;
                throw throwable;
            }
        }

        public void start() {
            this.thread = new SshThread(this, "Connection listener", true);
            this.thread.start();
        }

        public void stop() {
            try {
                this.state.setValue(2);
                this.server.close();
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
            catch (IOException ioe) {
                this.log.warn("The listening socket reported an error during shutdown", ioe);
            }
        }
    }
}

