/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.AuthenticationProtocolServer;
import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.daemon.platform.PasswordChangeException;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthInfoRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthInfoResponse;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KBIPasswordAuthenticationServer
extends SshAuthenticationServer {
    private static Log log = LogFactory.getLog(KBIPasswordAuthenticationServer.class);

    public final String getMethodName() {
        return "keyboard-interactive";
    }

    public void setAuthenticatedTokens(Map tokens) {
    }

    public int authenticate(AuthenticationProtocolServer authentication, SshMsgUserAuthRequest msg) throws IOException {
        NativeAuthenticationProvider authImpl = NativeAuthenticationProvider.getInstance();
        if (authImpl == null) {
            log.error("Cannot perfrom authentication witout native authentication provider");
            return 2;
        }
        authentication.registerMessage(61, SshMsgUserAuthInfoResponse.class);
        SshMsgUserAuthInfoRequest info = new SshMsgUserAuthInfoRequest("Password authentication", "", "");
        info.addPrompt(msg.getUsername() + "'s password", false);
        authentication.sendMessage(info);
        SshMessage response = authentication.readMessage();
        if (response instanceof SshMsgUserAuthInfoResponse) {
            String[] responses = ((SshMsgUserAuthInfoResponse)response).getResponses();
            if (responses.length == 1) {
                String password = responses[0];
                try {
                    if (authImpl.logonUser(msg.getUsername(), password)) {
                        log.info(msg.getUsername() + " has passed password authentication");
                        return 4;
                    }
                    log.info(msg.getUsername() + " has failed password authentication");
                    return 2;
                }
                catch (PasswordChangeException ex) {
                    info = new SshMsgUserAuthInfoRequest("Password change required", "", "");
                    info.addPrompt("New password", false);
                    info.addPrompt("Confirm password", false);
                    authentication.sendMessage(info);
                    response = authentication.readMessage();
                    if (response instanceof SshMsgUserAuthInfoResponse) {
                        responses = ((SshMsgUserAuthInfoResponse)response).getResponses();
                        if (responses.length == 2) {
                            if (responses[0].equals(responses[1])) {
                                if (authImpl.changePassword(msg.getUsername(), password, responses[0])) {
                                    return 4;
                                }
                                return 2;
                            }
                            return 2;
                        }
                        log.error("Client replied with an invalid message " + response.getMessageName());
                        return 2;
                    }
                    log.error("Client replied with an invalid message " + response.getMessageName());
                    return 2;
                }
            }
            log.error("Client responded with too many values!");
            return 2;
        }
        log.error("Client replied with an invalid message " + response.getMessageName());
        return 2;
    }
}

