/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

import com.sshtools.daemon.terminal.BufferOverflowException;
import java.util.Vector;

class CharBuffer {
    private Vector myBuffer;
    private int mySize;

    public CharBuffer(int size) {
        this.myBuffer = new Vector(size);
        this.mySize = size;
    }

    public char getCharAt(int pos) throws IndexOutOfBoundsException {
        return ((Character)this.myBuffer.elementAt(pos)).charValue();
    }

    public void setCharAt(int pos, char ch) throws IndexOutOfBoundsException {
        this.myBuffer.setElementAt(new Character(ch), pos);
    }

    public void insertCharAt(int pos, char ch) throws BufferOverflowException, IndexOutOfBoundsException {
        this.myBuffer.insertElementAt(new Character(ch), pos);
    }

    public void append(char aChar) throws BufferOverflowException {
        this.myBuffer.addElement(new Character(aChar));
    }

    public void removeCharAt(int pos) throws IndexOutOfBoundsException {
        this.myBuffer.removeElementAt(pos);
    }

    public void clear() {
        this.myBuffer.removeAllElements();
    }

    public int size() {
        return this.myBuffer.size();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.myBuffer.size(); ++i) {
            sbuf.append(((Character)this.myBuffer.elementAt(i)).charValue());
        }
        return sbuf.toString();
    }

    public void ensureSpace(int chars) throws BufferOverflowException {
        if (chars > this.mySize - this.myBuffer.size()) {
            throw new BufferOverflowException();
        }
    }
}

