/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.terminal;

public class ColorHelper {
    public static final String INTERNAL_MARKER = "\u0001";
    public static final int MARKER_CODE = 1;
    public static final String BLACK = "S";
    public static final String RED = "R";
    public static final String GREEN = "G";
    public static final String YELLOW = "Y";
    public static final String BLUE = "B";
    public static final String MAGENTA = "M";
    public static final String CYAN = "C";
    public static final String white = "W";
    public static final String BOLD = "f";
    public static final String BOLD_OFF = "d";
    public static final String ITALIC = "i";
    public static final String ITALIC_OFF = "j";
    public static final String UNDERLINED = "u";
    public static final String UNDERLINED_OFF = "v";
    public static final String BLINK = "e";
    public static final String BLINK_OFF = "n";
    public static final String RESET_ALL = "a";

    public static String colorizeText(String str, String color) {
        return INTERNAL_MARKER + color + str + INTERNAL_MARKER + RESET_ALL;
    }

    public static String colorizeBackground(String str, String color) {
        return INTERNAL_MARKER + color.toLowerCase() + str + INTERNAL_MARKER + RESET_ALL;
    }

    public static String colorizeText(String str, String fgc, String bgc) {
        return INTERNAL_MARKER + fgc + INTERNAL_MARKER + bgc.toLowerCase() + str + INTERNAL_MARKER + RESET_ALL;
    }

    public static String boldcolorizeText(String str, String color) {
        return "\u0001f\u0001" + color + str + INTERNAL_MARKER + RESET_ALL;
    }

    public static String boldcolorizeText(String str, String fgc, String bgc) {
        return "\u0001f\u0001" + fgc + INTERNAL_MARKER + bgc.toLowerCase() + str + INTERNAL_MARKER + RESET_ALL;
    }

    public static String boldText(String str) {
        return "\u0001f" + str + INTERNAL_MARKER + BOLD_OFF;
    }

    public static String italicText(String str) {
        return "\u0001i" + str + INTERNAL_MARKER + ITALIC_OFF;
    }

    public static String underlinedText(String str) {
        return "\u0001u" + str + INTERNAL_MARKER + UNDERLINED_OFF;
    }

    public static String blinkingText(String str) {
        return "\u0001e" + str + INTERNAL_MARKER + BLINK_OFF;
    }

    public static long getVisibleLength(String str) {
        int counter = 0;
        int parsecursor = 0;
        int foundcursor = 0;
        boolean done = false;
        while (!done) {
            foundcursor = str.indexOf(1, parsecursor);
            if (foundcursor != -1) {
                ++counter;
                parsecursor = foundcursor + 1;
                continue;
            }
            done = true;
        }
        return str.length() - counter * 2;
    }
}

