/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.vfs;

public class VFSPermission {
    private boolean canRead;
    private boolean canWrite;
    private boolean canExecute;
    private String name;

    public VFSPermission(String name, String permissions) {
        this.name = name;
        this.setPermissions(permissions);
    }

    public VFSPermission(String name) {
        this.name = name;
        this.setPermissions("rwx");
    }

    public String getName() {
        return this.name;
    }

    public void setPermissions(String permissions) {
        this.canRead = false;
        this.canWrite = false;
        this.canExecute = false;
        block5: for (int i = 0; i < permissions.length(); ++i) {
            switch (permissions.charAt(i)) {
                case 'r': {
                    this.canRead = true;
                    continue block5;
                }
                case 'w': {
                    this.canWrite = true;
                    continue block5;
                }
                case 'x': {
                    this.canExecute = true;
                }
            }
        }
    }

    public String getPermissions() {
        return (this.canRead ? "r" : "") + (this.canWrite ? "w" : "") + (this.canExecute ? "x" : "");
    }

    public boolean verifyPermissions(String permissions) {
        String tmp = this.getPermissions();
        for (int i = 0; i < permissions.length(); ++i) {
            String ch = permissions.substring(i, 1);
            if (tmp.indexOf(ch) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean canExecute() {
        return this.canExecute;
    }
}

