/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.windows;

import com.sshtools.daemon.configuration.PlatformConfiguration;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.daemon.platform.NativeProcessProvider;
import com.sshtools.daemon.windows.WindowsAuthentication;
import com.sshtools.daemon.windows.WindowsAuthenticationInfo;
import com.sshtools.daemon.windows.WindowsProcessInfo;
import com.sshtools.daemon.windows.WindowsProcessInputStream;
import com.sshtools.daemon.windows.WindowsProcessOutputStream;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WindowsProcess
extends NativeProcessProvider {
    private static Log log;
    WindowsAuthenticationInfo authInfo;
    WindowsProcessInfo processInfo;
    WindowsProcessInputStream input;
    WindowsProcessInputStream error;
    WindowsProcessOutputStream output;

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public InputStream getStderrInputStream() {
        return this.error;
    }

    public void kill() {
        this.killProcess(this.processInfo);
    }

    public String getDefaultTerminalProvider() {
        return this.getNativeTerminalProvider();
    }

    public boolean supportsPseudoTerminal(String term) {
        return false;
    }

    public boolean allocatePseudoTerminal(String term, int cols, int rows, int width, int height, String modes) {
        return false;
    }

    public int waitForExitCode() {
        return this.waitForProcessExitCode(this.processInfo.getProcessHandle());
    }

    public boolean stillActive() {
        return this.isProcessActive(this.processInfo.getProcessHandle());
    }

    public void start() throws IOException {
        if (!this.resumeProcess(this.processInfo)) {
            throw new IOException("Process could not be resumed");
        }
    }

    public boolean createProcess(String command, Map environment) throws IOException {
        String directory;
        String env;
        if (!(Thread.currentThread() instanceof SshThread)) {
            log.error("Calling thread is not an SshThread, failed to read username");
            return false;
        }
        SshThread thread = (SshThread)Thread.currentThread();
        if (thread.containsProperty("Win32UserAuthInfo")) {
            this.authInfo = (WindowsAuthenticationInfo)thread.getProperty("Win32UserAuthInfo");
            WindowsAuthentication auth = (WindowsAuthentication)NativeAuthenticationProvider.getInstance();
            env = "";
            String username = thread.getUsername();
            directory = auth.getHomeDirectory(username);
            if (directory == null || directory.trim().equals("")) {
                directory = auth.getNativeProfileDirectory(this.authInfo.getLogonToken());
            }
            if (directory == null || directory.equals("")) {
                directory = ((PlatformConfiguration)ConfigurationLoader.getConfiguration(PlatformConfiguration.class)).getSetting("DefaultHomeDir");
            }
        } else {
            return false;
        }
        this.processInfo = this.createProcess(command, env, directory, this.authInfo.getLogonToken());
        if (this.processInfo == null) {
            return false;
        }
        this.input = new WindowsProcessInputStream(this.processInfo.getStdoutReadHandle());
        this.output = new WindowsProcessOutputStream(this.processInfo.getStdinWriteHandle());
        this.error = new WindowsProcessInputStream(this.processInfo.getStderrReadHandle());
        return true;
    }

    private native int waitForProcessExitCode(int var1);

    private native boolean isProcessActive(int var1);

    private native WindowsProcessInfo createProcess(String var1, String var2, String var3, int var4);

    private native void killProcess(WindowsProcessInfo var1);

    private native String getNativeTerminalProvider();

    private native boolean resumeProcess(WindowsProcessInfo var1);

    static {
        System.loadLibrary("sshtools-daemon-win32");
        log = LogFactory.getLog(WindowsProcess.class);
    }
}

