/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.File;
import java.util.List;
import java.util.Vector;

public class DirectoryOperation {
    Vector unchangedFiles = new Vector();
    Vector newFiles = new Vector();
    Vector updatedFiles = new Vector();
    Vector deletedFiles = new Vector();
    Vector recursedDirectories = new Vector();

    protected void addNewFile(File f) {
        this.newFiles.add(f);
    }

    protected void addUpdatedFile(File f) {
        this.updatedFiles.add(f);
    }

    protected void addDeletedFile(File f) {
        this.deletedFiles.add(f);
    }

    protected void addUnchangedFile(File f) {
        this.unchangedFiles.add(f);
    }

    protected void addNewFile(SftpFile f) {
        this.newFiles.add(f);
    }

    protected void addUpdatedFile(SftpFile f) {
        this.updatedFiles.add(f);
    }

    protected void addDeletedFile(SftpFile f) {
        this.deletedFiles.add(f);
    }

    protected void addUnchangedFile(SftpFile f) {
        this.unchangedFiles.add(f);
    }

    public List getNewFiles() {
        return this.newFiles;
    }

    public List getUpdatedFiles() {
        return this.updatedFiles;
    }

    public List getUnchangedFiles() {
        return this.unchangedFiles;
    }

    public List getDeletedFiles() {
        return this.deletedFiles;
    }

    public boolean containsFile(File f) {
        return this.unchangedFiles.contains(f) || this.newFiles.contains(f) || this.updatedFiles.contains(f) || this.deletedFiles.contains(f) || this.recursedDirectories.contains(f);
    }

    public boolean containsFile(SftpFile f) {
        return this.unchangedFiles.contains(f) || this.newFiles.contains(f) || this.updatedFiles.contains(f) || this.deletedFiles.contains(f) || this.recursedDirectories.contains(f.getAbsolutePath());
    }

    public void addDirectoryOperation(DirectoryOperation op, File f) {
        this.updatedFiles.addAll(op.getUpdatedFiles());
        this.newFiles.addAll(op.getNewFiles());
        this.unchangedFiles.addAll(op.getUnchangedFiles());
        this.deletedFiles.addAll(op.getDeletedFiles());
        this.recursedDirectories.add(f);
    }

    public int getFileCount() {
        return this.newFiles.size() + this.updatedFiles.size();
    }

    public void addDirectoryOperation(DirectoryOperation op, String file) {
        this.updatedFiles.addAll(op.getUpdatedFiles());
        this.newFiles.addAll(op.getNewFiles());
        this.unchangedFiles.addAll(op.getUnchangedFiles());
        this.deletedFiles.addAll(op.getDeletedFiles());
        this.recursedDirectories.add(file);
    }

    public long getTransferSize() {
        SftpFile sftpfile;
        File file;
        long size = 0L;
        for (Object obj : this.newFiles) {
            if (obj instanceof File) {
                file = (File)obj;
                if (!file.isFile()) continue;
                size += file.length();
                continue;
            }
            if (!(obj instanceof SftpFile) || !(sftpfile = (SftpFile)obj).isFile()) continue;
            size += sftpfile.getAttributes().getSize().longValue();
        }
        for (Object obj : this.updatedFiles) {
            if (obj instanceof File) {
                file = (File)obj;
                if (!file.isFile()) continue;
                size += file.length();
                continue;
            }
            if (!(obj instanceof SftpFile) || !(sftpfile = (SftpFile)obj).isFile()) continue;
            size += sftpfile.getAttributes().getSize().longValue();
        }
        return size;
    }
}

