/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.KeyConstraints;
import com.sshtools.j2ssh.agent.KeyStoreListener;
import com.sshtools.j2ssh.agent.KeyTimeoutException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyStore {
    private static Log log = LogFactory.getLog(KeyStore.class);
    HashMap publickeys = new HashMap();
    HashMap privatekeys = new HashMap();
    HashMap constraints = new HashMap();
    Vector index = new Vector();
    Vector listeners = new Vector();
    String lockedPassword = null;

    public Map getPublicKeys() {
        return (Map)this.publickeys.clone();
    }

    public int indexOf(SshPublicKey key) {
        return this.index.indexOf(key);
    }

    public SshPublicKey elementAt(int i) {
        return (SshPublicKey)this.index.elementAt(i);
    }

    public String getDescription(SshPublicKey key) {
        return (String)this.publickeys.get(key);
    }

    public KeyConstraints getKeyConstraints(SshPublicKey key) {
        return (KeyConstraints)this.constraints.get(key);
    }

    public int size() {
        return this.index.size();
    }

    public void addKeyStoreListener(KeyStoreListener listener) {
        this.listeners.add(listener);
    }

    public void removeKeyStoreListener(KeyStoreListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKey(SshPrivateKey prvkey, SshPublicKey pubkey, String description, KeyConstraints cs) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            if (!this.publickeys.containsKey(pubkey)) {
                this.publickeys.put(pubkey, description);
                this.privatekeys.put(pubkey, prvkey);
                this.constraints.put(pubkey, cs);
                this.index.add(pubkey);
                for (KeyStoreListener listener : this.listeners) {
                    listener.onAddKey(this);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllKeys() {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            this.publickeys.clear();
            this.privatekeys.clear();
            this.constraints.clear();
            this.index.clear();
            for (KeyStoreListener listener : this.listeners) {
                listener.onDeleteAllKeys(this);
            }
        }
    }

    public byte[] performHashAndSign(SshPublicKey pubkey, List forwardingNodes, byte[] data) throws KeyTimeoutException, InvalidSshKeyException, InvalidSshKeySignatureException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.privatekeys.containsKey(pubkey)) {
                SshPrivateKey key = (SshPrivateKey)this.privatekeys.get(pubkey);
                KeyConstraints cs = (KeyConstraints)this.constraints.get(pubkey);
                if (cs.canUse()) {
                    if (!cs.hasTimedOut()) {
                        cs.use();
                        byte[] sig = key.generateSignature(data);
                        for (KeyStoreListener listener : this.listeners) {
                            listener.onKeyOperation(this, "hash-and-sign");
                        }
                        return sig;
                    }
                    throw new KeyTimeoutException();
                }
                throw new KeyTimeoutException();
            }
            throw new InvalidSshKeyException("The key does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteKey(SshPublicKey pubkey, String description) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            String desc;
            if (this.publickeys.containsKey(pubkey) && description.equals(desc = (String)this.publickeys.get(pubkey))) {
                this.publickeys.remove(pubkey);
                this.privatekeys.remove(pubkey);
                this.constraints.remove(pubkey);
                this.index.remove(pubkey);
                for (KeyStoreListener listener : this.listeners) {
                    listener.onDeleteKey(this);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(String password) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.lockedPassword == null) {
                this.lockedPassword = password;
                for (KeyStoreListener listener : this.listeners) {
                    listener.onLock(this);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(String password) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            if (this.lockedPassword != null && password.equals(this.lockedPassword)) {
                this.lockedPassword = null;
                for (KeyStoreListener listener : this.listeners) {
                    listener.onUnlock(this);
                }
                return true;
            }
            return false;
        }
    }
}

