/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPKOK;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublicKeyAuthenticationClient
extends SshAuthenticationClient {
    private static Log log = LogFactory.getLog(PublicKeyAuthenticationClient.class);
    protected SshPrivateKey key;
    private String privateKeyFile = null;
    private String passphrase = null;

    public void setKey(SshPrivateKey key) {
        this.key = key;
    }

    public void setKeyfile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getKeyfile() {
        return this.privateKeyFile;
    }

    public void reset() {
        this.privateKeyFile = null;
        this.passphrase = null;
    }

    public String getMethodName() {
        return "publickey";
    }

    public boolean acceptsKey(AuthenticationProtocolClient authentication, String username, String serviceToStart, SshPublicKey key) throws IOException {
        authentication.registerMessage(SshMsgUserAuthPKOK.class, 60);
        log.info("Determining if server can accept public key for authentication");
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.write(0);
        baw.writeString(key.getAlgorithmName());
        baw.writeBinaryString(key.getEncoded());
        SshMessage msg = new SshMsgUserAuthRequest(username, serviceToStart, this.getMethodName(), baw.toByteArray());
        authentication.sendMessage(msg);
        try {
            msg = authentication.readMessage(60);
            if (msg instanceof SshMsgUserAuthPKOK) {
                return true;
            }
            throw new IOException("Unexpected message returned from readMessage");
        }
        catch (TerminatedStateException ex) {
            return false;
        }
    }

    public void authenticate(AuthenticationProtocolClient authentication, String serviceToStart) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter baw = new ByteArrayWriter();
        log.info("Generating data to sign");
        SshPublicKey pub = this.key.getPublicKey();
        log.info("Preparing public key authentication request");
        baw.write(1);
        baw.writeString(pub.getAlgorithmName());
        baw.writeBinaryString(pub.getEncoded());
        ByteArrayWriter data = new ByteArrayWriter();
        data.writeBinaryString(authentication.getSessionIdentifier());
        data.write(50);
        data.writeString(this.getUsername());
        data.writeString(serviceToStart);
        data.writeString(this.getMethodName());
        data.write(1);
        data.writeString(pub.getAlgorithmName());
        data.writeBinaryString(pub.getEncoded());
        baw.writeBinaryString(this.key.generateSignature(data.toByteArray()));
        SshMsgUserAuthRequest msg = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, this.getMethodName(), baw.toByteArray());
        authentication.sendMessage(msg);
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        if (this.privateKeyFile != null) {
            properties.setProperty("PrivateKey", this.privateKeyFile);
        }
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("PrivateKey") != null) {
            this.privateKeyFile = properties.getProperty("PrivateKey");
        }
        if (properties.getProperty("Passphrase") != null) {
            this.passphrase = properties.getProperty("Passphrase");
        }
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }
}

