/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.io.FilePermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationClientFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";
    public static final String AUTH_HOSTBASED = "hostbased";

    protected SshAuthenticationClientFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList list = new ArrayList(auths.keySet());
        return list;
    }

    public static SshAuthenticationClient newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshAuthenticationClient)((Class)auths.get(methodName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog(SshAuthenticationClientFactory.class);
        auths = new HashMap();
        log.info("Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, PasswordAuthenticationClient.class);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            auths.put(AUTH_PK, PublicKeyAuthenticationClient.class);
        }
        catch (AccessControlException ace) {
            log.info("The security manager prevents use of Public Key Authentication on the client");
        }
        auths.put(AUTH_KBI, KBIAuthenticationClient.class);
    }
}

