/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.KBIPrompt;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgUserAuthInfoResponse
extends SshMessage {
    public static final int SSH_MSG_USERAUTH_INFO_RESPONSE = 61;
    private KBIPrompt[] prompts;
    String[] responses;

    public SshMsgUserAuthInfoResponse() {
        super(61);
    }

    public SshMsgUserAuthInfoResponse(KBIPrompt[] prompts) {
        super(61);
        if (prompts != null) {
            this.responses = new String[prompts.length];
            for (int i = 0; i < this.responses.length; ++i) {
                this.responses[i] = prompts[i].getResponse();
            }
        }
    }

    public String getMessageName() {
        return "SSH_MSG_USERAUTH_INFO_RESPONSE";
    }

    public String[] getResponses() {
        return this.responses;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            if (this.responses == null) {
                baw.writeInt(0);
            } else {
                baw.writeInt(this.responses.length);
                for (int i = 0; i < this.responses.length; ++i) {
                    baw.writeString(this.responses[i]);
                }
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Failed to write message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            int num = (int)bar.readInt();
            if (num > 0) {
                this.responses = new String[num];
                for (int i = 0; i < this.responses.length; ++i) {
                    this.responses[i] = bar.readString();
                }
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Failed to read message data");
        }
    }
}

