/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingListener;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import com.sshtools.j2ssh.forwarding.XDisplay;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketPermission;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingClient
implements ChannelFactory {
    private static Log log = LogFactory.getLog(ForwardingClient.class);
    public static final String REMOTE_FORWARD_REQUEST = "tcpip-forward";
    public static final String REMOTE_FORWARD_CANCEL_REQUEST = "cancel-tcpip-forward";
    private ConnectionProtocol connection;
    private List channelTypes = new Vector();
    private Map localForwardings = new HashMap();
    private Map remoteForwardings = new HashMap();
    private XDisplay xDisplay;
    private ForwardingConfiguration x11ForwardingConfiguration;

    public ForwardingClient(ConnectionProtocol connection) throws IOException {
        this.connection = connection;
        connection.addChannelFactory("forwarded-tcpip", this);
        connection.addChannelFactory("x11", this);
    }

    public List getChannelType() {
        return this.channelTypes;
    }

    public void enableX11Forwarding(XDisplay localDisplay) {
        this.xDisplay = localDisplay;
        this.x11ForwardingConfiguration = new ForwardingConfiguration("x11", "", 0, this.xDisplay.getHost(), this.xDisplay.getPort());
    }

    public ForwardingConfiguration getX11ForwardingConfiguration() {
        return this.x11ForwardingConfiguration;
    }

    public boolean hasActiveConfigurations() {
        if (this.localForwardings.size() == 0 && this.remoteForwardings.size() == 0) {
            return false;
        }
        Iterator it = this.localForwardings.values().iterator();
        while (it.hasNext()) {
            if (((ForwardingConfiguration)it.next()).getState().getValue() != 1) continue;
            return true;
        }
        it = this.remoteForwardings.values().iterator();
        while (it.hasNext()) {
            if (((ForwardingConfiguration)it.next()).getState().getValue() != 1) continue;
            return true;
        }
        return false;
    }

    public void synchronizeConfiguration(SshConnectionProperties properties) {
        Iterator it;
        ForwardingConfiguration fwd = null;
        if (properties.getLocalForwardings().size() > 0) {
            it = properties.getLocalForwardings().values().iterator();
            while (it.hasNext()) {
                try {
                    fwd = (ForwardingConfiguration)it.next();
                    fwd = this.addLocalForwarding(fwd);
                    if (!properties.getForwardingAutoStartMode()) continue;
                    this.startLocalForwarding(fwd.getName());
                }
                catch (Throwable ex) {
                    log.warn("Failed to start local forwarding " + fwd != null ? fwd.getName() : "", ex);
                }
            }
        }
        if (properties.getRemoteForwardings().size() > 0) {
            it = properties.getRemoteForwardings().values().iterator();
            while (it.hasNext()) {
                try {
                    fwd = (ForwardingConfiguration)it.next();
                    this.addRemoteForwarding(fwd);
                    if (!properties.getForwardingAutoStartMode()) continue;
                    this.startRemoteForwarding(fwd.getName());
                }
                catch (Throwable ex) {
                    log.warn("Failed to start remote forwarding " + fwd != null ? fwd.getName() : "", ex);
                }
            }
        }
    }

    public boolean hasActiveForwardings() {
        if (this.localForwardings.size() == 0 && this.remoteForwardings.size() == 0) {
            return false;
        }
        Iterator it = this.localForwardings.values().iterator();
        while (it.hasNext()) {
            if (((ForwardingConfiguration)it.next()).getActiveForwardingSocketChannels().size() <= 0) continue;
            return true;
        }
        it = this.remoteForwardings.values().iterator();
        while (it.hasNext()) {
            if (((ForwardingConfiguration)it.next()).getActiveForwardingSocketChannels().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public ForwardingConfiguration getLocalForwardingByAddress(String addressToBind, int portToBind) throws ForwardingConfigurationException {
        for (ForwardingConfiguration config : this.localForwardings.values()) {
            if (!config.getAddressToBind().equals(addressToBind) || config.getPortToBind() != portToBind) continue;
            return config;
        }
        throw new ForwardingConfigurationException("The configuration does not exist");
    }

    public ForwardingConfiguration getLocalForwardingByName(String name) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(name)) {
            throw new ForwardingConfigurationException("The configuraiton does not exist!");
        }
        return (ForwardingConfiguration)this.localForwardings.get(name);
    }

    public ForwardingConfiguration getRemoteForwardingByName(String name) throws ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(name)) {
            throw new ForwardingConfigurationException("The configuraiton does not exist!");
        }
        return (ForwardingConfiguration)this.remoteForwardings.get(name);
    }

    public Map getLocalForwardings() {
        return this.localForwardings;
    }

    public Map getRemoteForwardings() {
        return this.remoteForwardings;
    }

    public ForwardingConfiguration getRemoteForwardingByAddress(String addressToBind, int portToBind) throws ForwardingConfigurationException {
        for (ForwardingConfiguration config : this.remoteForwardings.values()) {
            if (!config.getAddressToBind().equals(addressToBind) || config.getPortToBind() != portToBind) continue;
            return config;
        }
        throw new ForwardingConfigurationException("The configuration does not exist");
    }

    public void removeLocalForwarding(String name) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(name)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingListener listener = (ForwardingListener)this.localForwardings.get(name);
        if (listener.isRunning()) {
            this.stopLocalForwarding(name);
        }
        this.localForwardings.remove(name);
    }

    public void removeRemoteForwarding(String name) throws IOException, ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(name)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingListener listener = (ForwardingListener)this.remoteForwardings.get(name);
        if (listener.isRunning()) {
            this.stopRemoteForwarding(name);
        }
        this.remoteForwardings.remove(name);
    }

    public ForwardingConfiguration addLocalForwarding(String uniqueName, String addressToBind, int portToBind, String hostToConnect, int portToConnect) throws ForwardingConfigurationException {
        if (this.localForwardings.containsKey(uniqueName)) {
            throw new ForwardingConfigurationException("The configuration name already exists!");
        }
        for (ForwardingConfiguration config : this.localForwardings.values()) {
            if (!config.getAddressToBind().equals(addressToBind) || config.getPortToBind() != portToBind) continue;
            throw new ForwardingConfigurationException("The address and port are already in use");
        }
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(new SocketPermission(addressToBind + ":" + String.valueOf(portToBind), "accept,listen"));
            }
            catch (SecurityException e) {
                throw new ForwardingConfigurationException("The security manager has denied listen permision on " + addressToBind + ":" + String.valueOf(portToBind));
            }
        }
        ClientForwardingListener cf = new ClientForwardingListener(uniqueName, this.connection, addressToBind, portToBind, hostToConnect, portToConnect);
        this.localForwardings.put(uniqueName, cf);
        return cf;
    }

    public ForwardingConfiguration addLocalForwarding(ForwardingConfiguration fwd) throws ForwardingConfigurationException {
        return this.addLocalForwarding(fwd.getName(), fwd.getAddressToBind(), fwd.getPortToBind(), fwd.getHostToConnect(), fwd.getPortToConnect());
    }

    public void addRemoteForwarding(String uniqueName, String addressToBind, int portToBind, String hostToConnect, int portToConnect) throws ForwardingConfigurationException {
        if (this.remoteForwardings.containsKey(uniqueName)) {
            throw new ForwardingConfigurationException("The remote forwaring configuration name already exists!");
        }
        for (ForwardingConfiguration config : this.remoteForwardings.values()) {
            if (!config.getAddressToBind().equals(addressToBind) || config.getPortToBind() != portToBind) continue;
            throw new ForwardingConfigurationException("The remote forwarding address and port are already in use");
        }
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(new SocketPermission(hostToConnect + ":" + String.valueOf(portToConnect), "connect"));
            }
            catch (SecurityException e) {
                throw new ForwardingConfigurationException("The security manager has denied connect permision on " + hostToConnect + ":" + String.valueOf(portToConnect));
            }
        }
        this.remoteForwardings.put(uniqueName, new ForwardingConfiguration(uniqueName, addressToBind, portToBind, hostToConnect, portToConnect));
    }

    public void addRemoteForwarding(ForwardingConfiguration fwd) throws ForwardingConfigurationException {
        if (this.remoteForwardings.containsKey(fwd.getName())) {
            throw new ForwardingConfigurationException("The remote forwaring configuration name already exists!");
        }
        for (ForwardingConfiguration config : this.remoteForwardings.values()) {
            if (!config.getAddressToBind().equals(fwd.getAddressToBind()) || config.getPortToBind() != fwd.getPortToBind()) continue;
            throw new ForwardingConfigurationException("The remote forwarding address and port are already in use");
        }
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(new SocketPermission(fwd.getHostToConnect() + ":" + String.valueOf(fwd.getPortToConnect()), "connect"));
            }
            catch (SecurityException e) {
                throw new ForwardingConfigurationException("The security manager has denied connect permision on " + fwd.getHostToConnect() + ":" + String.valueOf(fwd.getPortToConnect()));
            }
        }
        this.remoteForwardings.put(fwd.getName(), fwd);
    }

    public Channel createChannel(String channelType, byte[] requestData) throws InvalidChannelException {
        if (channelType.equals("x11")) {
            if (this.xDisplay == null) {
                throw new InvalidChannelException("Local display has not been set for X11 forwarding.");
            }
            try {
                ByteArrayReader bar = new ByteArrayReader(requestData);
                String originatingHost = bar.readString();
                int originatingPort = (int)bar.readInt();
                log.debug("Creating socket to " + this.x11ForwardingConfiguration.getHostToConnect() + "/" + this.x11ForwardingConfiguration.getPortToConnect());
                Socket socket = new Socket(this.x11ForwardingConfiguration.getHostToConnect(), this.x11ForwardingConfiguration.getPortToConnect());
                ForwardingSocketChannel channel = this.x11ForwardingConfiguration.createForwardingSocketChannel(channelType, this.x11ForwardingConfiguration.getHostToConnect(), this.x11ForwardingConfiguration.getPortToConnect(), originatingHost, originatingPort);
                channel.bindSocket(socket);
                channel.addEventListener(this.x11ForwardingConfiguration.monitor);
                return channel;
            }
            catch (IOException ioe) {
                throw new InvalidChannelException(ioe.getMessage());
            }
        }
        if (channelType.equals("forwarded-tcpip")) {
            try {
                ByteArrayReader bar = new ByteArrayReader(requestData);
                String addressBound = bar.readString();
                int portBound = (int)bar.readInt();
                String originatingHost = bar.readString();
                int originatingPort = (int)bar.readInt();
                ForwardingConfiguration config = this.getRemoteForwardingByAddress(addressBound, portBound);
                Socket socket = new Socket(config.getHostToConnect(), config.getPortToConnect());
                ForwardingSocketChannel channel = config.createForwardingSocketChannel(channelType, config.getHostToConnect(), config.getPortToConnect(), originatingHost, originatingPort);
                channel.bindSocket(socket);
                channel.addEventListener(config.monitor);
                return channel;
            }
            catch (ForwardingConfigurationException fce) {
                throw new InvalidChannelException("No valid forwarding configuration was available for the request address");
            }
            catch (IOException ioe) {
                throw new InvalidChannelException(ioe.getMessage());
            }
        }
        throw new InvalidChannelException("The server can only request a remote forwarding channel or anX11 forwarding channel");
    }

    public void startLocalForwarding(String uniqueName) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(uniqueName)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        try {
            ForwardingListener listener = (ForwardingListener)this.localForwardings.get(uniqueName);
            listener.start();
        }
        catch (IOException ex) {
            throw new ForwardingConfigurationException(ex.getMessage());
        }
    }

    public void startX11Forwarding() throws IOException, ForwardingConfigurationException {
        if (this.x11ForwardingConfiguration == null) {
            throw new ForwardingConfigurationException("X11 forwarding hasn't been enabled.");
        }
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString(this.x11ForwardingConfiguration.getAddressToBind());
        baw.writeInt(this.x11ForwardingConfiguration.getPortToBind());
        this.x11ForwardingConfiguration.getState().setValue(1);
        if (log.isDebugEnabled()) {
            log.info("X11 forwarding started");
            log.debug("Address to bind: " + this.x11ForwardingConfiguration.getAddressToBind());
            log.debug("Port to bind: " + String.valueOf(this.x11ForwardingConfiguration.getPortToBind()));
            log.debug("Host to connect: " + this.x11ForwardingConfiguration.hostToConnect);
            log.debug("Port to connect: " + this.x11ForwardingConfiguration.portToConnect);
        } else {
            log.info("Request for X11 rejected.");
        }
    }

    public void startRemoteForwarding(String name) throws IOException, ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(name)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingConfiguration config = (ForwardingConfiguration)this.remoteForwardings.get(name);
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString(config.getAddressToBind());
        baw.writeInt(config.getPortToBind());
        this.connection.sendGlobalRequest(REMOTE_FORWARD_REQUEST, true, baw.toByteArray());
        this.remoteForwardings.put(name, config);
        config.getState().setValue(1);
        log.info("Remote forwarding configuration '" + name + "' started");
        if (log.isDebugEnabled()) {
            log.debug("Address to bind: " + config.getAddressToBind());
            log.debug("Port to bind: " + String.valueOf(config.getPortToBind()));
            log.debug("Host to connect: " + config.hostToConnect);
            log.debug("Port to connect: " + config.portToConnect);
        }
    }

    public void stopLocalForwarding(String uniqueName) throws ForwardingConfigurationException {
        if (!this.localForwardings.containsKey(uniqueName)) {
            throw new ForwardingConfigurationException("The name is not a valid forwarding configuration");
        }
        ForwardingListener listener = (ForwardingListener)this.localForwardings.get(uniqueName);
        listener.stop();
        log.info("Local forwarding configuration " + uniqueName + "' stopped");
    }

    public void stopRemoteForwarding(String name) throws IOException, ForwardingConfigurationException {
        if (!this.remoteForwardings.containsKey(name)) {
            throw new ForwardingConfigurationException("The remote forwarding configuration does not exist");
        }
        ForwardingConfiguration config = (ForwardingConfiguration)this.remoteForwardings.get(name);
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString(config.getAddressToBind());
        baw.writeInt(config.getPortToBind());
        this.connection.sendGlobalRequest(REMOTE_FORWARD_CANCEL_REQUEST, true, baw.toByteArray());
        config.getState().setValue(2);
        log.info("Remote forwarding configuration '" + name + "' stopped");
    }

    public class ClientForwardingListener
    extends ForwardingListener {
        public ClientForwardingListener(String name, ConnectionProtocol connection, String addressToBind, int portToBind, String hostToConnect, int portToConnect) {
            super(name, connection, addressToBind, portToBind, hostToConnect, portToConnect);
        }

        public ForwardingSocketChannel createChannel(String hostToConnect, int portToConnect, Socket socket) throws ForwardingConfigurationException {
            return this.createForwardingSocketChannel("direct-tcpip", hostToConnect, portToConnect, socket.getInetAddress().getHostAddress(), socket.getPort());
        }
    }
}

