/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

public class XDisplay {
    private String host;
    private int display;
    private int screen;
    private int portOffset;

    public XDisplay(String string) {
        this(string, 6000);
    }

    public XDisplay(String string, int portOffset) {
        this.setString(string);
        this.setPortOffset(portOffset);
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public void setString(String string) {
        int idx = string.indexOf(58);
        if (idx == -1) {
            this.display = 0;
            this.host = string;
        } else {
            this.host = string.substring(0, idx);
            String s = string.substring(idx + 1);
            if ((idx = s.indexOf(".")) == -1) {
                this.screen = 0;
                try {
                    this.display = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    this.display = 0;
                }
            } else {
                try {
                    this.display = Integer.parseInt(s.substring(0, idx));
                }
                catch (NumberFormatException nfe) {
                    this.display = 0;
                }
                try {
                    this.screen = Integer.parseInt(s.substring(idx + 1));
                }
                catch (NumberFormatException nfe) {
                    this.screen = 0;
                }
            }
        }
    }

    public int getPort() {
        return this.getDisplay() < this.getPortOffset() ? this.getDisplay() + this.getPortOffset() : this.getDisplay();
    }

    public int getScreen() {
        return this.screen;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setDisplay(int display) {
        this.display = display;
    }

    public void setScreen(int screen) {
        this.screen = screen;
    }

    public String getHost() {
        return this.host;
    }

    public int getDisplay() {
        return this.display;
    }

    public String toString() {
        return this.getHost() + ":" + this.getDisplay() + (this.getScreen() == 0 ? "" : "." + this.getScreen());
    }
}

