/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.IOStreamConnectorListener;
import com.sshtools.j2ssh.io.IOStreamConnectorState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOStreamConnector {
    private static Log log = LogFactory.getLog(IOStreamConnector.class);
    private IOStreamConnectorState state = new IOStreamConnectorState();
    private InputStream in = null;
    private OutputStream out = null;
    private Thread thread;
    private long bytes;
    private boolean closeInput = true;
    private boolean closeOutput = true;
    protected EventListenerList listenerList = new EventListenerList();

    public IOStreamConnector() {
    }

    public IOStreamConnector(InputStream in, OutputStream out) {
        this.connect(in, out);
    }

    public IOStreamConnectorState getState() {
        return this.state;
    }

    public void close() throws IOException {
        log.info("Closing IOStreamConnector");
        this.state.setValue(4);
        if (this.closeInput) {
            this.in.close();
        }
        if (this.closeOutput) {
            this.out.close();
        }
        this.thread = null;
    }

    public void setCloseInput(boolean closeInput) {
        this.closeInput = closeInput;
    }

    public void setCloseOutput(boolean closeOutput) {
        this.closeOutput = closeOutput;
    }

    public void connect(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        log.info("Connecting InputStream to OutputStream");
        this.state.setValue(2);
        this.thread = new SshThread(new IOStreamConnectorThread(), "IOStream connector", true);
        this.thread.start();
    }

    public long getBytes() {
        return this.bytes;
    }

    public void addIOStreamConnectorListener(IOStreamConnectorListener l) {
        this.listenerList.add(IOStreamConnectorListener.class, l);
    }

    public void removeIOStreamConnectorListener(IOStreamConnectorListener l) {
        this.listenerList.remove(IOStreamConnectorListener.class, l);
    }

    class IOStreamConnectorThread
    implements Runnable {
        private Log log = LogFactory.getLog(IOStreamConnectorThread.class);

        IOStreamConnectorThread() {
        }

        public void run() {
            byte[] buffer = new byte[4096];
            int read = 0;
            this.log.info("Starting IOStreamConnectorThread thread");
            while (IOStreamConnector.this.state.getValue() == 2) {
                try {
                    read = IOStreamConnector.this.in.read(buffer, 0, 1);
                    if (read > 0) {
                        int count = read;
                        int available = IOStreamConnector.this.in.available();
                        if (available > 0 && buffer.length - 1 < available) {
                            byte[] tmp = new byte[available + 1];
                            System.arraycopy(buffer, 0, tmp, 0, 1);
                            buffer = tmp;
                        }
                        if (available > 0) {
                            read = IOStreamConnector.this.in.read(buffer, 1, available);
                            count += read;
                        }
                        IOStreamConnector.this.out.write(buffer, 0, count);
                        IOStreamConnector.this.bytes += count;
                        IOStreamConnector.this.out.flush();
                        IOStreamConnectorListener[] l = (IOStreamConnectorListener[])IOStreamConnector.this.listenerList.getListeners(IOStreamConnectorListener.class);
                        for (int i = l.length - 1; i >= 0; --i) {
                            l[i].data(buffer, count);
                        }
                        continue;
                    }
                    this.log.debug("Blocking read returned with " + String.valueOf(read));
                    if (read >= 0) continue;
                    IOStreamConnector.this.state.setValue(3);
                }
                catch (IOException ioe) {
                    if (IOStreamConnector.this.state.getValue() != 2) continue;
                    this.log.debug(ioe.getMessage());
                    IOStreamConnector.this.state.setValue(3);
                }
            }
            try {
                if (IOStreamConnector.this.state.getValue() != 4) {
                    IOStreamConnector.this.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.log.info("IOStreamConnectorThread is exiting");
        }
    }
}

