/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;
import java.io.InputStream;

public class SubsystemInputStream
extends InputStream {
    byte[] msgdata;
    int currentPos = 0;
    private SubsystemMessageStore messageStore;

    public SubsystemInputStream(SubsystemMessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public int available() {
        if (this.msgdata == null) {
            return 0;
        }
        return this.msgdata.length - this.currentPos;
    }

    public int read() throws IOException {
        if (this.msgdata == null) {
            this.collectNextMessage();
        }
        if (this.currentPos >= this.msgdata.length) {
            this.collectNextMessage();
        }
        return this.msgdata[this.currentPos++] & 0xFF;
    }

    private void collectNextMessage() throws IOException {
        SubsystemMessage msg = this.messageStore.nextMessage();
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            byte[] data = msg.toByteArray();
            baw.writeInt(data.length);
            baw.write(data);
            this.msgdata = baw.toByteArray();
        }
        catch (InvalidMessageException ime) {
            throw new IOException("An invalid message was encountered in the inputstream");
        }
        this.currentPos = 0;
    }
}

