/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TransportProtocolOutputStream {
    private static Log log = LogFactory.getLog(TransportProtocolOutputStream.class);
    private OutputStream out;
    private TransportProtocolAlgorithmSync algorithms;
    private TransportProtocolCommon transport;
    private long sequenceNo = 0L;
    private long sequenceWrapLimit = BigInteger.valueOf(2L).pow(32).longValue();
    private Random rnd = ConfigurationLoader.getRND();
    private long bytesTransfered = 0L;

    public TransportProtocolOutputStream(OutputStream out, TransportProtocolCommon transport, TransportProtocolAlgorithmSync algorithms) throws TransportProtocolException {
        this.out = out;
        this.transport = transport;
        this.algorithms = algorithms;
    }

    protected long getNumBytesTransfered() {
        return this.bytesTransfered;
    }

    protected synchronized void sendMessage(SshMessage msg) throws TransportProtocolException {
        block7: {
            try {
                this.algorithms.lock();
                SshCipher cipher = this.algorithms.getCipher();
                SshHmac hmac = this.algorithms.getHmac();
                SshCompression compression = this.algorithms.getCompression();
                ByteArrayWriter message = new ByteArrayWriter();
                byte[] msgdata = msg.toByteArray();
                int padding = 4;
                int cipherlen = 8;
                if (cipher != null) {
                    cipherlen = cipher.getBlockSize();
                }
                if (compression != null) {
                    msgdata = compression.compress(msgdata, 0, msgdata.length);
                }
                padding += (cipherlen - (msgdata.length + 5 + padding) % cipherlen) % cipherlen;
                message.writeInt(msgdata.length + 1 + padding);
                message.write(padding);
                message.write(msgdata, 0, msgdata.length);
                byte[] pad = new byte[padding];
                this.rnd.nextBytes(pad);
                message.write(pad);
                byte[] packet = message.toByteArray();
                byte[] mac = null;
                if (hmac != null) {
                    mac = hmac.generate(this.sequenceNo, packet, 0, packet.length);
                }
                if (cipher != null) {
                    packet = cipher.transform(packet);
                }
                message.reset();
                message.write(packet);
                if (mac != null) {
                    message.write(mac);
                }
                this.bytesTransfered += (long)message.size();
                this.out.write(message.toByteArray());
                this.out.flush();
                this.algorithms.release();
                this.sequenceNo = this.sequenceNo < this.sequenceWrapLimit ? ++this.sequenceNo : 0L;
            }
            catch (IOException ioe) {
                if (this.transport.getState().getValue() == 5) break block7;
                throw new TransportProtocolException("IO Error on socket: " + ioe.getMessage());
            }
        }
    }
}

