/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshtoolsPrivateKeyFormat;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPrivateKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;

    public static List getSupportedFormats() {
        return types;
    }

    public static void initialize() {
    }

    public static SshPrivateKeyFormat newInstance(String type) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(type)) {
                return (SshPrivateKeyFormat)((Class)formatTypes.get(type)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + type + " is not supported");
        }
        catch (IllegalAccessException iae) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + type);
        }
        catch (InstantiationException ie) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + type);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }

    static {
        log = LogFactory.getLog(SshPrivateKeyFormatFactory.class);
        log.info("Loading private key formats");
        ArrayList<String> formats = new ArrayList<String>();
        types = new Vector();
        formatTypes = new HashMap();
        formats.add(SshtoolsPrivateKeyFormat.class.getName());
        defaultFormat = "SSHTools-PrivateKey-Base64Encoded";
        try {
            Enumeration<URL> enumer = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.privatekey");
            Properties properties = new Properties();
            while (enumer != null && enumer.hasMoreElements()) {
                URL url = enumer.nextElement();
                InputStream in = url.openStream();
                properties.load(in);
                IOUtil.closeStream(in);
                int num = 1;
                String name = "";
                while (properties.getProperty("privatekey.name." + String.valueOf(num)) != null) {
                    name = properties.getProperty("privatekey.name." + String.valueOf(num));
                    formats.add(properties.getProperty("privatekey.class." + String.valueOf(num)));
                    ++num;
                }
            }
        }
        catch (Throwable t) {
            log.info("Failed to load private extension key formats", t);
        }
        for (String classname : formats) {
            try {
                Class cls = ConfigurationLoader.getExtensionClass(classname);
                SshPrivateKeyFormat f = (SshPrivateKeyFormat)cls.newInstance();
                log.debug("Installing " + f.getFormatType() + " private key format");
                formatTypes.put(f.getFormatType(), cls);
                types.add(f.getFormatType());
            }
            catch (Throwable t) {
                log.warn("Private key format implemented by " + classname + " will not be available", t);
            }
        }
    }
}

